/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.player.achievement;

import com.mcsrranked.client.info.player.achievement.PlayerAchievement;
import com.mcsrranked.client.utils.ClientUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class AchievementWorker {
    private final Renderer renderer;
    private final Function<PlayerAchievement, List<class_5348>> tooltipFunction;
    private final Progress progress;
    private final class_2561 progressSuffix;
    private final Function<PlayerAchievement, class_2561> titleFunction;

    public AchievementWorker(Function<PlayerAchievement, class_2561> titleFunction, Renderer renderer, Function<PlayerAchievement, List<class_5348>> tooltipFunction) {
        this(titleFunction, renderer, tooltipFunction, null, null);
    }

    public AchievementWorker(Function<PlayerAchievement, class_2561> titleFunction, Renderer renderer, Function<PlayerAchievement, List<class_5348>> tooltipFunction, Progress progress, class_2561 progressSuffix) {
        this.titleFunction = titleFunction;
        this.renderer = renderer;
        this.tooltipFunction = tooltipFunction;
        this.progress = progress;
        this.progressSuffix = progressSuffix;
    }

    public class_2561 getTitle(PlayerAchievement achievement) {
        return this.titleFunction.apply(achievement);
    }

    public void renderIcon(class_4587 matrixStack, int x, int y, PlayerAchievement achievement) {
        this.renderer.render(matrixStack, x, y, achievement);
    }

    public List<class_5348> getTooltips(PlayerAchievement achievement) {
        List<class_5348> list = this.tooltipFunction.apply(achievement);
        if (!list.isEmpty()) {
            list.add(0, (class_5348)class_2585.field_24366);
        }
        list.add(0, (class_5348)new class_2585(this.getTitle(achievement).getString()).method_27692(class_124.field_1054));
        list.add((class_5348)class_2585.field_24366);
        list.add((class_5348)new class_2588("projectelo.text.profile.achieve_time").method_27693(": " + ClientUtils.timeToDurationFormat(achievement.getDate().getTime())));
        if (this.progress != null && achievement.getValue() != null) {
            boolean isMaxLevel = achievement.getGoal() == null;
            list.add((class_5348)class_2585.field_24366);
            class_2585 progressText = new class_2585(this.progress.getProgressString(achievement.getValue()));
            if (!isMaxLevel) {
                progressText = progressText.method_27693("/").method_27693(this.progress.getProgressString(achievement.getGoal()));
            }
            progressText = progressText.method_27693(" ").method_10852(this.progressSuffix);
            list.add((class_5348)new class_2588("projectelo.tooltip." + (!isMaxLevel ? "next_level" : "max_level")).method_27693(": ").method_27692(!isMaxLevel ? class_124.field_1054 : class_124.field_1060).method_10852((class_2561)progressText.method_27692(class_124.field_1068)));
        }
        return list;
    }

    public boolean isMouseOver(int x, int y, int mouseX, int mouseY, float size) {
        return mouseX >= x && (float)mouseX < (float)x + 32.0f * size && mouseY >= y && (float)mouseY < (float)y + 32.0f * size;
    }

    public static interface Renderer {
        public void render(class_4587 var1, int var2, int var3, PlayerAchievement var4);
    }

    public static interface Progress {
        public String getProgressString(long var1);
    }
}

