/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.player.achievement;

import com.google.common.reflect.TypeToken;
import com.mcsrranked.client.gui.toast.ToastContext;
import com.mcsrranked.client.info.player.achievement.AchievementManager;
import com.mcsrranked.client.info.player.achievement.AchievementWorker;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class PlayerAchievement
implements ToastContext {
    public static final Type LIST_TYPE_TOKEN = new TypeToken<List<PlayerAchievement>>(){}.getType();
    private final String id;
    private final int date;
    private final String[] data;
    private final int level;
    private final Long goal;
    private final Long value;

    public PlayerAchievement(String id, int date, String[] data, int level, Long goal, Long value) {
        this.id = id;
        this.date = date;
        this.data = data;
        this.level = level;
        this.goal = goal;
        this.value = value;
    }

    public String getID() {
        return this.id;
    }

    public Date getDate() {
        return new Date((long)this.date * 1000L);
    }

    public int getLevel() {
        return this.level;
    }

    public String[] getData() {
        return this.data;
    }

    public Long getGoal() {
        return this.goal;
    }

    public Long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerAchievement that = (PlayerAchievement)o;
        return this.date == that.date && this.level == that.level && Objects.equals(this.id, that.id) && Arrays.equals(this.data, that.data) && Objects.equals(this.goal, that.goal) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.date, this.level, this.goal, this.value);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public class_5250 getTitleText() {
        return new class_2588("projectelo.toast.achievement_unlocked");
    }

    @Override
    public class_2561 getText() {
        AchievementWorker worker = AchievementManager.getWorker(this);
        if (worker == null) {
            return class_2585.field_24366;
        }
        return worker.getTitle(this);
    }

    @Override
    public void renderIcon(class_4587 matrixStack, int x, int y) {
        AchievementWorker worker = AchievementManager.getWorker(this);
        if (worker == null) {
            return;
        }
        worker.renderIcon(matrixStack, x, y, this);
    }
}

