/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.race;

import com.mcsrranked.client.info.race.RaceTimeline;
import com.mcsrranked.client.info.race.WeeklyRace;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.socket.SocketStatus;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class WeeklyRaceResult {
    private long submitStartTime = System.currentTimeMillis();
    private int submitStatus = -1;
    private final WeeklyRace race;
    private final long finalTime;
    private DataInputStream inputStream;

    public WeeklyRaceResult(WeeklyRace race, long finalTime) {
        this.race = race;
        this.finalTime = finalTime;
    }

    private void createInputStream() throws IOException {
        this.inputStream = new DataInputStream(Files.newInputStream(this.race.getReplay().getPersonalPlayerTracker().getLocalFile().toPath(), new OpenOption[0]));
    }

    public DataInputStream getInputStream() {
        return this.inputStream;
    }

    public int getSubmitStatus() {
        return this.submitStatus;
    }

    public boolean isDone() {
        return this.getSubmitStatus() >= 4;
    }

    public String getStatusKey() {
        switch (this.submitStatus) {
            case 1: 
            case 2: 
            case 3: {
                return "projectelo.weeklyrace.uploading";
            }
            case 4: {
                return "projectelo.weeklyrace.submitted";
            }
            case 5: {
                return "projectelo.weeklyrace.submitted_without_replay";
            }
            case 6: {
                return "projectelo.weeklyrace.invalid";
            }
        }
        return "projectelo.weeklyrace.submitting";
    }

    public void tick() {
        if (this.submitStatus == 0 && System.currentTimeMillis() - this.submitStartTime > 15000L) {
            SocketInstance.getInstance().close();
            try {
                while (SocketInstance.getInstance().getStatus() != SocketStatus.DISCONNECTED) {
                    Thread.sleep(15L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SocketInstance.getInstance().connect();
            try {
                while (SocketInstance.getInstance().getStatus().isLoading()) {
                    Thread.sleep(15L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.submit(0);
        }
    }

    public void submit(int submitStatus) {
        if (submitStatus == 0) {
            this.submitStartTime = System.currentTimeMillis();
            SocketInstance.getInstance().emit("p$race_end", this.race.getID(), this.finalTime, submitStatus);
        }
        if (submitStatus == 1) {
            try {
                if (this.submitStatus == 0) {
                    if (this.getInputStream() != null) {
                        this.getInputStream().close();
                    }
                    this.createInputStream();
                }
                byte[] bytes = null;
                try {
                    if (this.getInputStream().available() > 0) {
                        int length = this.getInputStream().readInt();
                        bytes = new byte[length];
                        this.getInputStream().readFully(bytes);
                    }
                }
                catch (EOFException length) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                    bytes = null;
                }
                SocketInstance.getInstance().emit("p$race_end", this.race.getID(), this.finalTime, submitStatus, bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (submitStatus == 2) {
            try {
                if (this.getInputStream() != null) {
                    this.getInputStream().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (RaceTimeline currentTimeline : this.race.getCurrentTimelines()) {
                stringBuilder.append(currentTimeline.toString()).append("\n");
            }
            SocketInstance.getInstance().emit("p$race_end", this.race.getID(), this.finalTime, submitStatus, stringBuilder.substring(0, stringBuilder.length() - 1));
        }
        if (submitStatus == 3) {
            SocketInstance.getInstance().emit("p$race_end", this.race.getID(), this.finalTime, submitStatus);
        }
        this.submitStatus = submitStatus;
    }
}

