/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.interaction;

import com.google.common.collect.Sets;
import com.mcsrranked.client.MCSRRankedClient;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class AutoRequestManager {
    private static final Set<String> acceptUUIDorNames = Sets.newConcurrentHashSet();
    private static final File file = MCSRRankedClient.GLOBAL_PATH.resolve("auto_accept.txt").toFile();
    private static long lastModifiedTime = 0L;

    public static void load() {
        if (file.exists()) {
            long lastModified = file.lastModified();
            if (lastModifiedTime == lastModified) {
                return;
            }
            lastModifiedTime = lastModified;
            acceptUUIDorNames.clear();
            try {
                List result = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
                for (String s : result) {
                    if (s.trim().isEmpty()) continue;
                    acceptUUIDorNames.add(s.replaceAll("-", "").toLowerCase(Locale.ROOT).trim());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                FileUtils.writeStringToFile((File)file, (String)"", (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean contains(String uuid) {
        return acceptUUIDorNames.contains(uuid.replaceAll("-", "").toLowerCase(Locale.ROOT).trim());
    }
}

