/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.interaction;

import com.google.common.collect.Sets;
import com.mcsrranked.client.MCSRRankedClient;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class PlayerMuteManager {
    private static final Set<UUID> mutedUUID = Sets.newConcurrentHashSet();
    private static final File file = MCSRRankedClient.GLOBAL_PATH.resolve("mute_players.txt").toFile();

    public static void load() {
        if (file.exists()) {
            try {
                String result = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                for (String s : result.split("\n")) {
                    if (s.isEmpty()) continue;
                    mutedUUID.add(UUID.fromString(s));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addPlayer(UUID uuid) {
        mutedUUID.add(uuid);
        PlayerMuteManager.save();
    }

    public static void removePlayer(UUID uuid) {
        mutedUUID.remove(uuid);
        PlayerMuteManager.save();
    }

    public static boolean isMutedPlayer(UUID uuid) {
        return mutedUUID.contains(uuid) && !uuid.equals(MCSRRankedClient.LOCAL_PLAYER.getUUID());
    }

    private static void save() {
        MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (UUID uuid1 : mutedUUID) {
                stringBuilder.append(uuid1).append("\n");
            }
            try {
                FileUtils.writeStringToFile((File)file, (String)stringBuilder.toString(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

