/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.mixin;

import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.info.RunTimer;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.TimerStatus;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InGameTimer.class})
public abstract class MixinInGameTimer {
    @Unique
    private int pausesAfterIdle = 0;
    @Unique
    private long lastIdleUnpauseTime = 0L;

    @Shadow(remap=false)
    public abstract boolean isStarted();

    @Inject(method={"setPause(ZLcom/redlimerl/speedrunigt/timer/TimerStatus;Ljava/lang/String;)V"}, at={@At(value="INVOKE", target="Lcom/redlimerl/speedrunigt/timer/InGameTimer;setStatus(Lcom/redlimerl/speedrunigt/timer/TimerStatus;)V")}, remap=false)
    public void onPause(boolean toPause, TimerStatus toStatus, String reason, CallbackInfo ci) {
        RunTimer runTimer = MCSRRankedClient.getCurrentTimer().orElse(null);
        if (runTimer == null) {
            return;
        }
        if (this.isStarted() && toPause && System.currentTimeMillis() - this.lastIdleUnpauseTime < runTimer.getWorldLoadPauseTimeLimit()) {
            runTimer.setPause(true, ++this.pausesAfterIdle);
        } else {
            if (toPause && toStatus == TimerStatus.IDLE) {
                this.pausesAfterIdle = 0;
            } else if (!toPause && this.pausesAfterIdle == 0) {
                this.lastIdleUnpauseTime = System.currentTimeMillis();
            }
            runTimer.setPause(toPause, null);
        }
    }
}

