/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.remote;

import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.tracking.cinematic.CinematicCamera;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.LiveMatchPlayerListHud;
import com.mcsrranked.client.gui.widget.replay.ReplayLiveCommandMenu;
import com.mcsrranked.client.gui.widget.replay.ReplayTimeMoveCommandMenu;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.net.URL;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.NumberFormatter;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.server.MinecraftServer;

public class ReplayRemoteFrame
extends JFrame {
    private final JLabel statusLabel;
    private final JCheckBox followCameraCheckBox;
    private final JCheckBox followDimensionCheckBox;
    private final JCheckBox ghostModeCheckBox;
    private final JCheckBox displayNameTagCheckBox;
    private DefaultListModel<OnlinePlayer> playerListModel;
    private final JList<OnlinePlayer> playerList;
    private OnlineMatch onlineMatch;
    private ReplayProcessor replayProcessor;
    private int ticks;

    public ReplayRemoteFrame() {
        this.setTitle("Replay Remote Controller");
        this.setDefaultCloseOperation(1);
        this.setSize(400, 750);
        this.setLocationRelativeTo(null);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        class_3545 lastLocation = (class_3545)SpeedRunOption.getOption(RankedOptions.LAST_CONTROLLER_LOCATION);
        if (lastLocation != null) {
            int locationX = (Integer)lastLocation.method_15442();
            int locationY = (Integer)lastLocation.method_15441();
            if (locationX < 0 || locationX > screen.width - 400) {
                locationX = 400;
            }
            if (locationY < 0 || locationY > screen.height - 400) {
                locationY = 400;
            }
            this.setLocation(locationX, locationY);
        }
        try {
            URL imageUrl = ReplayRemoteFrame.class.getResource("/assets/mcsrranked/textures/gui/icon.png");
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(imageUrl));
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLayout(new BorderLayout(10, 10));
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(10, 10, 10, 10));
        this.statusLabel = new JLabel("STATUS", 0);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1, 15.0f));
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)this.statusLabel, "Center");
        this.add((Component)statusPanel, "North");
        this.playerListModel = new DefaultListModel();
        this.playerList = new JList<OnlinePlayer>(this.playerListModel);
        this.playerList.setSelectionMode(0);
        this.playerList.addListSelectionListener(event -> {
            if (this.replayProcessor == null || this.onlineMatch == null || class_310.method_1551().field_1766 == null || this.playerList.getSelectedValue() == null) {
                return;
            }
            if (this.replayProcessor.getFocusedTracker().map(tracker -> tracker.getUuid().equals(this.playerList.getSelectedValue().getUUID())).orElse(false).booleanValue()) {
                return;
            }
            this.replayProcessor.setFocusedTracker(this.playerList.getSelectedValue().getUUID(), (MinecraftServer)class_310.method_1551().field_1766);
        });
        this.playerList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (ReplayRemoteFrame.this.onlineMatch == null) {
                    return this;
                }
                OnlinePlayer player = (OnlinePlayer)value;
                String text = String.format("[%s] %s", ReplayRemoteFrame.this.onlineMatch.getPlayLog(player).getLastSplit().name().toLowerCase().replace("_", ""), player.getNickname());
                this.setText(text);
                return this;
            }
        });
        JLabel playerListLabel = new JLabel("Click player to change focus", 0);
        playerListLabel.setFont(playerListLabel.getFont().deriveFont(1));
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)playerListLabel, "North");
        centerPanel.add((Component)new JScrollPane(this.playerList), "Center");
        this.add((Component)centerPanel, "Center");
        this.followCameraCheckBox = new JCheckBox("Follow Camera");
        this.followCameraCheckBox.addActionListener(event -> {
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            if (camera instanceof CinematicCamera) {
                CinematicCamera cinematicCamera = (CinematicCamera)camera;
                cinematicCamera.ranked$setCinematicActive(this.followCameraCheckBox.isSelected());
            }
        });
        this.followDimensionCheckBox = new JCheckBox("Follow Dimension");
        this.followDimensionCheckBox.addActionListener(event -> {
            if (this.replayProcessor == null) {
                return;
            }
            this.replayProcessor.setFollowDimension(this.followDimensionCheckBox.isSelected());
        });
        this.ghostModeCheckBox = new JCheckBox("Ghost Mode");
        this.ghostModeCheckBox.addActionListener(event -> {
            if (this.replayProcessor == null || this.onlineMatch == null || class_310.method_1551().field_1766 == null) {
                return;
            }
            this.replayProcessor.setGhostMode(this.ghostModeCheckBox.isSelected(), (MinecraftServer)class_310.method_1551().field_1766);
        });
        this.displayNameTagCheckBox = new JCheckBox("Display Name Tag");
        this.displayNameTagCheckBox.addActionListener(event -> {
            if (this.replayProcessor == null) {
                return;
            }
            this.replayProcessor.setDisplayNameTag(this.displayNameTagCheckBox.isSelected());
        });
        this.followCameraCheckBox.setHorizontalAlignment(0);
        this.followDimensionCheckBox.setHorizontalAlignment(0);
        this.ghostModeCheckBox.setHorizontalAlignment(0);
        this.displayNameTagCheckBox.setHorizontalAlignment(0);
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new GridLayout(0, 1, 0, 5));
        checkboxPanel.add(this.followCameraCheckBox);
        checkboxPanel.add(this.followDimensionCheckBox);
        checkboxPanel.add(this.ghostModeCheckBox);
        checkboxPanel.add(this.displayNameTagCheckBox);
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setAllowsInvalid(false);
        formatter.setMinimum(Integer.valueOf(5));
        formatter.setMaximum(Integer.valueOf(300));
        JFormattedTextField timeMoveScaleField = new JFormattedTextField(formatter);
        timeMoveScaleField.setColumns(3);
        Dimension prefSize = timeMoveScaleField.getPreferredSize();
        timeMoveScaleField.setMaximumSize(new Dimension(prefSize.width, prefSize.height));
        timeMoveScaleField.setText("10");
        JPanel timeScalePanel = new JPanel();
        timeScalePanel.setLayout(new BoxLayout(timeScalePanel, 0));
        timeScalePanel.add(timeMoveScaleField);
        JButton timeMoveBeforeButton = new JButton("Before");
        timeMoveBeforeButton.addActionListener(event -> {
            if (this.replayProcessor == null || this.onlineMatch == null || class_310.method_1551().field_1766 == null) {
                return;
            }
            int seconds = Integer.parseInt(timeMoveScaleField.getText());
            new ReplayTimeMoveCommandMenu(true, seconds).method_2783(null);
        });
        JButton timeMoveAfterButton = new JButton("After");
        timeMoveAfterButton.addActionListener(event -> {
            if (this.replayProcessor == null || this.onlineMatch == null || class_310.method_1551().field_1766 == null) {
                return;
            }
            int seconds = Integer.parseInt(timeMoveScaleField.getText());
            new ReplayTimeMoveCommandMenu(false, seconds).method_2783(null);
        });
        JButton timeMoveLiveButton = new JButton("Live");
        timeMoveLiveButton.addActionListener(event -> {
            if (this.replayProcessor == null || this.onlineMatch == null || class_310.method_1551().field_1766 == null) {
                return;
            }
            new ReplayLiveCommandMenu().method_2783(null);
        });
        JPanel timeButtonsPanel = new JPanel(new GridLayout(1, 5, 0, 0));
        timeButtonsPanel.add(new JPanel());
        timeButtonsPanel.add(timeMoveBeforeButton);
        timeButtonsPanel.add(timeMoveLiveButton);
        timeButtonsPanel.add(timeMoveAfterButton);
        timeButtonsPanel.add(new JPanel());
        JLabel timeLabel = new JLabel("Live Replay Time Adjust", 0);
        timeLabel.setFont(timeLabel.getFont().deriveFont(1));
        timeLabel.setAlignmentX(0.5f);
        JPanel timeGroupPanel = new JPanel();
        timeGroupPanel.setLayout(new BoxLayout(timeGroupPanel, 1));
        timeGroupPanel.add(timeLabel);
        timeGroupPanel.add(Box.createVerticalStrut(5));
        timeGroupPanel.add(timeScalePanel);
        timeGroupPanel.add(timeButtonsPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.add(checkboxPanel);
        bottomPanel.add(Box.createVerticalStrut(15));
        bottomPanel.add(timeGroupPanel);
        this.add((Component)bottomPanel, "South");
    }

    public void syncReplay(OnlineMatch match, ReplayProcessor processor) {
        if (match != null) {
            this.onlineMatch = match;
        }
        if (processor != null) {
            this.replayProcessor = processor;
        }
        SwingUtilities.invokeLater(() -> {
            if (this.replayProcessor != null) {
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                if (camera instanceof CinematicCamera) {
                    CinematicCamera cinematicCamera = (CinematicCamera)camera;
                    this.followCameraCheckBox.setSelected(cinematicCamera.ranked$isCinematicActivated());
                }
                this.followDimensionCheckBox.setSelected(this.replayProcessor.isFollowDimension());
                this.ghostModeCheckBox.setSelected(this.replayProcessor.isGhostMode());
                this.displayNameTagCheckBox.setSelected(this.replayProcessor.shouldDisplayNameTag());
            }
        });
    }

    public void reset() {
        this.onlineMatch = null;
        this.replayProcessor = null;
        this.ticks = 0;
    }

    public void tick() {
        if (this.onlineMatch == null) {
            this.statusLabel.setText("You are not in a match!");
            return;
        }
        if (this.replayProcessor == null) {
            this.statusLabel.setText("Replay is not available!");
            return;
        }
        if (this.onlineMatch.getStatus().isPlaying()) {
            if (this.onlineMatch.getStartTime() != 0L) {
                this.statusLabel.setText("Current Time: " + InGameTimerUtils.timeToStringFormat((long)(System.currentTimeMillis() - this.onlineMatch.getStartTime())).split("\\.")[0]);
            }
        } else {
            this.statusLabel.setText("Current Status: " + this.onlineMatch.getStatus().name());
        }
        if (this.ticks++ % 20 == 0) {
            int index;
            this.syncReplay(null, null);
            SpeedRunOption.setOption(RankedOptions.LAST_CONTROLLER_LOCATION, (Object)new class_3545((Object)this.getX(), (Object)this.getY()));
            OnlinePlayer selected = this.playerList.getSelectedValue();
            this.playerListModel = new DefaultListModel();
            List<OnlinePlayer> players = LiveMatchPlayerListHud.getSortedPlayers(this.onlineMatch, true);
            for (OnlinePlayer player : players) {
                this.playerListModel.addElement(player);
            }
            this.playerList.setModel(this.playerListModel);
            if (selected != null && (index = this.playerListModel.indexOf(selected)) != -1) {
                this.playerList.addSelectionInterval(index, index);
            }
        }
    }
}

