/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.standardrng;

import com.google.common.collect.Lists;
import com.mcsrranked.client.standardrng.AccessibleRandom;
import com.mcsrranked.client.standardrng.LavaLakeInfo;
import com.mcsrranked.client.world.CloneableState;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public class WorldSpawnState
extends class_18
implements CloneableState<WorldSpawnState> {
    private final AccessibleRandom entryRandom = new AccessibleRandom();
    private final long rawSeed;
    private long entrySeed;
    private final Map<class_2338, class_2350> spawnerDirections = new ConcurrentHashMap<class_2338, class_2350>();
    private final List<LavaLakeInfo> lakeList = Lists.newCopyOnWriteArrayList();

    public WorldSpawnState(long seed) {
        super("spawn_rng");
        this.rawSeed = seed;
        this.entrySeed = seed + 3942244525L + 2831583200L;
    }

    public static WorldSpawnState fromWorld(class_3218 world) {
        return (WorldSpawnState)world.method_17983().method_17924(() -> new WorldSpawnState(world.method_8412()), "spawn_rng");
    }

    public void method_77(class_2487 tag) {
        this.entrySeed = tag.method_10537("entrySeed");
        this.entryRandom.seed.set(this.entrySeed);
    }

    public class_2487 method_75(class_2487 tag) {
        tag.method_10544("entrySeed", this.entrySeed);
        return tag;
    }

    public AccessibleRandom getEntryRandom() {
        return this.entryRandom;
    }

    public long getEntrySeed() {
        return this.entrySeed;
    }

    public void setEntrySeed(long entrySeed) {
        this.entrySeed = entrySeed;
    }

    public List<LavaLakeInfo> getLavaLakeList() {
        return this.lakeList;
    }

    public class_2350 getSpawnerDirection(class_2338 blockPos) {
        return this.spawnerDirections.getOrDefault(blockPos, class_2350.field_11043);
    }

    public void setSpawnerDirection(class_2338 blockPos, class_2350 direction) {
        this.spawnerDirections.put(blockPos, direction);
        this.method_80();
    }

    public void addLavaLake(class_1937 world, LavaLakeInfo lavaLakeInfo) {
        if (this.getLavaLakeList().isEmpty() || world == null || world.method_18456().isEmpty()) {
            this.getLavaLakeList().add(lavaLakeInfo);
        }
    }

    @Override
    public WorldSpawnState copy() {
        WorldSpawnState state = new WorldSpawnState(this.rawSeed);
        for (LavaLakeInfo lavaLakeInfo : this.getLavaLakeList()) {
            state.addLavaLake(null, lavaLakeInfo.copyForReset());
        }
        return state;
    }
}

