/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3341;

public class BlockBoxUtils {
    public static boolean contains(class_3341 container, class_3341 target, int epsilon) {
        return target.field_14381 >= container.field_14381 - epsilon && target.field_14378 <= container.field_14378 + epsilon && target.field_14380 >= container.field_14380 - epsilon && target.field_14377 <= container.field_14377 + epsilon && target.field_14379 >= container.field_14379 - epsilon && target.field_14376 <= container.field_14376 + epsilon;
    }

    private static boolean faceAligned(int min1, int max1, int min2, int max2, int epsilon) {
        int length1 = max1 - min1;
        int length2 = max2 - min2;
        return Math.abs(min1 - min2) <= epsilon && Math.abs(length1 - length2) <= epsilon;
    }

    public static boolean facesCanAlign(class_3341 a, class_3341 b, int epsilon) {
        boolean xAligned = BlockBoxUtils.faceAligned(a.field_14380, a.field_14377, b.field_14380, b.field_14377, epsilon) && BlockBoxUtils.faceAligned(a.field_14379, a.field_14376, b.field_14379, b.field_14376, epsilon);
        boolean yAligned = BlockBoxUtils.faceAligned(a.field_14381, a.field_14378, b.field_14381, b.field_14378, epsilon) && BlockBoxUtils.faceAligned(a.field_14379, a.field_14376, b.field_14379, b.field_14376, epsilon);
        boolean zAligned = BlockBoxUtils.faceAligned(a.field_14381, a.field_14378, b.field_14381, b.field_14378, epsilon) && BlockBoxUtils.faceAligned(a.field_14380, a.field_14377, b.field_14380, b.field_14377, epsilon);
        return xAligned || yAligned || zAligned;
    }

    public static boolean shouldMerge(class_3341 a, class_3341 b, int epsilon) {
        return BlockBoxUtils.contains(a, b, epsilon) || BlockBoxUtils.contains(b, a, epsilon) || BlockBoxUtils.facesCanAlign(a, b, epsilon);
    }

    public static class_3341 mergeBox(class_3341 a, class_3341 b) {
        return new class_3341(Math.min(a.field_14381, b.field_14381), Math.min(a.field_14380, b.field_14380), Math.min(a.field_14379, b.field_14379), Math.max(a.field_14378, b.field_14378), Math.max(a.field_14377, b.field_14377), Math.max(a.field_14376, b.field_14376));
    }

    public static List<class_3341> merge(List<class_3341> boxes, int epsilon) {
        boolean mergedAny;
        ArrayList<Object> result = new ArrayList<class_3341>(boxes);
        do {
            mergedAny = false;
            ArrayList<class_3341> newResult = new ArrayList<class_3341>();
            while (!result.isEmpty()) {
                class_3341 current = (class_3341)result.remove(result.size() - 1);
                boolean merged = false;
                for (int i = 0; i < result.size(); ++i) {
                    class_3341 other = (class_3341)result.get(i);
                    if (!BlockBoxUtils.shouldMerge(current, other, epsilon)) continue;
                    class_3341 mergedBox = BlockBoxUtils.mergeBox(current, other);
                    result.remove(i);
                    result.add(mergedBox);
                    merged = true;
                    mergedAny = true;
                    break;
                }
                if (merged) continue;
                newResult.add(current);
            }
            result = newResult;
        } while (mergedAny);
        return result;
    }
}

