/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.ActivityType;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.Packet;
import com.jagrosh.discordipc.entities.PartyPrivacy;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.User;
import com.jagrosh.discordipc.entities.pipe.PipeStatus;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.screen.RankedMainScreen;
import com.mcsrranked.client.gui.screen.match.MatchPrivateRoomScreen;
import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_310;

public class DiscordRPCUtils {
    private static boolean HAS_DISCORD_ERROR = false;
    private static IPCClient CLIENT = null;
    private static long LATEST_JOIN_TIME = 0L;
    private static final long START_TIME = System.currentTimeMillis();

    public static boolean hasDiscordError() {
        return HAS_DISCORD_ERROR;
    }

    public static boolean isIntegrated() {
        return CLIENT != null && CLIENT.getStatus() == PipeStatus.CONNECTED && !HAS_DISCORD_ERROR;
    }

    public static void close() {
        if (CLIENT != null) {
            CLIENT.close();
        }
    }

    public static void start() {
        try {
            CLIENT = new IPCClient(1067614836059545661L, false, "1067614836059545661");
            CLIENT.setListener(new IPCListener(){

                @Override
                public void onPacketSent(IPCClient client, Packet packet) {
                }

                @Override
                public void onPacketReceived(IPCClient client, Packet packet) {
                }

                @Override
                public void onActivityJoin(IPCClient client, String secret) {
                    if (System.currentTimeMillis() > LATEST_JOIN_TIME + 5000L) {
                        MatchPrivateRoomScreen.makeQueue(class_310.method_1551(), RankedMainScreen.create(), secret);
                        LATEST_JOIN_TIME = System.currentTimeMillis();
                    }
                }

                @Override
                public void onActivitySpectate(IPCClient client, String secret) {
                }

                @Override
                public void onActivityJoinRequest(IPCClient client, String secret, User user) {
                }

                @Override
                public void onReady(IPCClient client) {
                    DiscordRPCUtils.updateRichPresence(builder -> builder, true);
                }

                @Override
                public void onClose(IPCClient client, JsonObject json) {
                    CLIENT = null;
                }

                @Override
                public void onDisconnect(IPCClient client, Throwable t) {
                }
            });
            CLIENT.connect(new DiscordBuild[0]);
            CLIENT.subscribe(IPCClient.Event.ACTIVITY_JOIN);
            MCSRRankedClient.LOGGER.info("Initialized Discord RPC");
        }
        catch (Throwable e) {
            e.printStackTrace();
            HAS_DISCORD_ERROR = true;
        }
    }

    public static void updateRichPresence(Function<RichPresence.Builder, RichPresence.Builder> function) {
        DiscordRPCUtils.updateRichPresence(function, DiscordRPCUtils.isIntegrated());
    }

    public static void updateRichPresence(Function<RichPresence.Builder, RichPresence.Builder> function, boolean isIntegrated) {
        if (isIntegrated && ((Boolean)SpeedRunOption.getOption(RankedOptions.ENABLE_DISCORD_RPC)).booleanValue()) {
            CLIENT.sendRichPresence(function.apply(DiscordRPCUtils.defaultBuilder()).build());
        }
    }

    public static void updateRichPresenceByOnlineMatch(OnlineMatch onlineMatch) {
        DiscordRPCUtils.updateRichPresence(builder -> {
            if (onlineMatch.getType() == MatchType.PRIVATE && onlineMatch.getHost() != null) {
                builder.setState("Waiting Players...").setParty(onlineMatch.getHost().getUUIDString(), onlineMatch.getPlayers().size(), onlineMatch.getMaxPlayers(), PartyPrivacy.Private).setButtons(null).setJoinSecret(onlineMatch.getCode());
            } else {
                builder.setState("Queuing Match...");
            }
            return builder;
        });
    }

    public static void disableRichPresence() {
        if (DiscordRPCUtils.isIntegrated()) {
            DiscordRPCUtils.close();
        }
    }

    public static void enableRichPresence() {
        if (!DiscordRPCUtils.isIntegrated()) {
            DiscordRPCUtils.start();
        }
        if (DiscordRPCUtils.isIntegrated()) {
            CLIENT.sendRichPresence(DiscordRPCUtils.defaultBuilder().build());
        }
    }

    private static RichPresence.Builder defaultBuilder() {
        JsonArray jsonArray = new JsonArray();
        JsonObject buttonObject = new JsonObject();
        buttonObject.addProperty("label", "Download");
        buttonObject.addProperty("url", "https://mcsrranked.com/download");
        jsonArray.add((JsonElement)buttonObject);
        int score = Optional.ofNullable(MCSRRankedClient.LOCAL_PLAYER).map(OnlinePlayer::getEloRate).orElse(-1);
        RichPresence.Builder builder = new RichPresence.Builder();
        builder.setDetails("Current Elo: " + (score == -1 ? "?" : Integer.valueOf(score))).setState("Waiting Match...").setStartTimestamp(START_TIME).setLargeImage("icon_x512", "MCSR Ranked").setActivityType(ActivityType.Competing).setButtons(jsonArray);
        return builder;
    }
}

