/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.utils;

import com.google.common.collect.Sets;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.utils.UUIDUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4587;

public class TextureUtils {
    private static final ExecutorService SKIN_LOADER = Executors.newFixedThreadPool(5);
    private static final ConcurrentHashMap<UUID, class_3545<class_2960, Boolean>> PLAYER_SKIN_MAP = new ConcurrentHashMap();
    private static final Set<UUID> LOADING_PLAYER_UUID = Sets.newHashSet();
    public static final class_2960 DEFAULT_GUI_TEXTURE = new class_2960("mcsrranked", "textures/gui/default_gui.png");

    public static void loadPlayerSkin(UUID uuid) {
        if (PLAYER_SKIN_MAP.containsKey(uuid)) {
            return;
        }
        try {
            class_1071 skinProvider = class_310.method_1551().method_1582();
            skinProvider.method_4652(new GameProfile(uuid, null), (type, identifier, texture) -> {
                if (type == MinecraftProfileTexture.Type.SKIN) {
                    String model = texture.getMetadata("model");
                    PLAYER_SKIN_MAP.put(uuid, (class_3545<class_2960, Boolean>)new class_3545((Object)identifier, (Object)Objects.equals(model, "slim")));
                }
            }, false);
        }
        catch (Exception e) {
            MCSRRankedClient.LOGGER.error("Failed to load player skin - \"{}\"%n", (Object)uuid);
        }
    }

    public static class_2960 getPlayerSkin(String rawUuid) {
        UUID uuid = UUIDUtils.fromString(rawUuid);
        if (PLAYER_SKIN_MAP.containsKey(uuid)) {
            return (class_2960)PLAYER_SKIN_MAP.get(uuid).method_15442();
        }
        if (!LOADING_PLAYER_UUID.contains(uuid)) {
            LOADING_PLAYER_UUID.add(uuid);
            SKIN_LOADER.submit(() -> {
                TextureUtils.loadPlayerSkin(uuid);
                LOADING_PLAYER_UUID.remove(uuid);
            });
        }
        return class_1068.method_4649();
    }

    public static boolean isPlayerSlim(String uuid) {
        return (Boolean)PLAYER_SKIN_MAP.getOrDefault(UUIDUtils.fromString(uuid), (class_3545<class_2960, Boolean>)new class_3545(null, (Object)false)).method_15441();
    }

    public static class_1011 getNativeImageFromUrlImage(String targetUrl) {
        try {
            URL url = new URL(targetUrl);
            URLConnection conn = url.openConnection();
            InputStream inputStream = conn.getInputStream();
            return class_1011.method_4310((class_1011.class_1012)class_1011.class_1012.field_4997, (InputStream)inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void registerTextureSafe(class_2960 identifier, class_1044 texture) {
        TextureUtils.registerTextureSafe(identifier, texture, () -> {});
    }

    public static void registerTextureSafe(class_2960 identifier, class_1044 texture, Runnable callback) {
        class_310.method_1551().execute(() -> RenderSystem.recordRenderCall(() -> {
            try {
                if (class_310.method_1551().method_1531().method_4619(identifier) != null) {
                    class_310.method_1551().method_1531().method_4615(identifier);
                }
                class_310.method_1551().method_1531().method_4616(identifier, texture);
                callback.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    public static void renderPhasePointIcon(class_4587 matrices, int x, int y, int width) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        class_310.method_1551().method_1531().method_22813(DEFAULT_GUI_TEXTURE);
        class_332.method_25293((class_4587)matrices, (int)x, (int)y, (int)width, (int)width, (float)0.0f, (float)16.0f, (int)16, (int)16, (int)128, (int)128);
        RenderSystem.popMatrix();
    }

    public static void renderChatDisabledIcon(class_4587 matrices, int x, int y, int width, float alpha) {
        class_310.method_1551().method_1531().method_22813(DEFAULT_GUI_TEXTURE);
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        class_332.method_25293((class_4587)matrices, (int)x, (int)y, (int)width, (int)width, (float)48.0f, (float)0.0f, (int)16, (int)16, (int)128, (int)128);
        RenderSystem.popMatrix();
    }
}

