/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.UUID;

public class UUIDUtils {
    public static UUID fromString(String uuid) {
        if (uuid == null) {
            return null;
        }
        return UUID.fromString(uuid.replaceAll("-", "").replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
    }

    public static String toString(UUID uuid) {
        return uuid.toString().replaceAll("-", "");
    }

    public static UUID getHardwareUUID() {
        try {
            String host;
            String macAddress = "";
            String macName = "";
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (mac == null) continue;
                macName = networkInterface.getName();
                macAddress = new String(mac);
                break;
            }
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                host = System.getProperty("os.arch");
            }
            String uuid = String.format("%08x", host.hashCode()) + String.format("%08x", macAddress.hashCode()) + String.format("%08x", macName.hashCode()) + String.format("%08x", System.getProperty("user.name").hashCode());
            return UUIDUtils.fromString(uuid);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

