/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.vanillafix;

import com.mcsrranked.client.interf.AccessorMinecraftServerTick;
import java.io.File;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_156;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaWatchdog
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MinecraftServer server;
    private final long maxTickTime;

    public VanillaWatchdog(MinecraftServer server, long maxTickTime) {
        this.server = server;
        this.maxTickTime = maxTickTime;
    }

    @Override
    public void run() {
        while (this.server.method_3806() && !this.server.method_16043()) {
            long l = ((AccessorMinecraftServerTick)this.server).ranked$getLastTickTime();
            long m = class_156.method_658();
            long n = m - l;
            if (n > this.maxTickTime) {
                LOGGER.fatal("A single server tick took {} seconds (should be max {})", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf((float)n / 1000.0f)), (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(0.05f)));
                LOGGER.fatal("Considering it to be crashed, server will forcibly shutdown.");
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
                StringBuilder stringBuilder = new StringBuilder();
                Error error = new Error();
                for (ThreadInfo threadInfo : threadInfos) {
                    if (threadInfo.getThreadId() == this.server.method_3777().getId()) {
                        error.setStackTrace(threadInfo.getStackTrace());
                    }
                    stringBuilder.append((CharSequence)this.threadInfoToString(threadInfo));
                    stringBuilder.append("\n");
                }
                class_128 crashReport = new class_128("Watching Server", (Throwable)error);
                this.server.method_3859(crashReport);
                class_129 crashReportSection = crashReport.method_562("Thread Dump");
                crashReportSection.method_578("Threads", (Object)stringBuilder);
                File file = new File(new File(this.server.method_3831(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
                if (crashReport.method_569(file)) {
                    LOGGER.error("This crash report has been saved to: {}", (Object)file.getAbsolutePath());
                } else {
                    LOGGER.error("We were unable to save this crash report to disk.");
                }
                this.shutdown();
            }
            try {
                Thread.sleep(l + this.maxTickTime - m);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void shutdown() {
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable throwable) {
            Runtime.getRuntime().halt(1);
        }
    }

    private StringBuilder threadInfoToString(ThreadInfo threadInfo) {
        LockInfo[] locks;
        int i;
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId() + " " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            sb.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(threadInfo.getLockOwnerName()).append("\" Id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i = 0; i < threadInfo.getStackTrace().length; ++i) {
            StackTraceElement ste = threadInfo.getStackTrace()[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : threadInfo.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo);
                sb.append('\n');
            }
        }
        if (i < threadInfo.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = threadInfo.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- ").append(lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb;
    }
}

