/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.world;

import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.info.match.MatchSplit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class RunSplitState
extends class_18 {
    private final Map<MatchSplit, PlayerPosition> splitPairMap = new ConcurrentHashMap<MatchSplit, PlayerPosition>();
    private final List<PlayerPosition> deathPointList = new CopyOnWriteArrayList<PlayerPosition>();
    private class_3545<class_5321<class_1937>, class_2338> beginnerSpawn = null;
    private boolean updateBeginnerSpawn = false;

    public static RunSplitState fromServer(MinecraftServer server) {
        class_3218 serverWorld = server.method_30002();
        return (RunSplitState)serverWorld.method_17983().method_17924(RunSplitState::new, "run_splits");
    }

    public RunSplitState() {
        super("run_splits");
    }

    public Map<MatchSplit, PlayerPosition> getSplitPosMap() {
        return this.splitPairMap;
    }

    public void addSplit(MatchSplit split, class_1657 player) {
        if (split != MatchSplit.STARTED && split != MatchSplit.ENTER_END && !this.getSplitPosMap().containsKey((Object)split)) {
            this.updateBeginnerSpawn = true;
        }
        this.getSplitPosMap().putIfAbsent(split, new PlayerPosition(player));
        this.method_80();
    }

    public List<PlayerPosition> getDeathPointList() {
        return this.deathPointList;
    }

    public void addDeathPoint(class_1657 player) {
        this.getDeathPointList().add(new PlayerPosition(player));
        this.method_80();
    }

    public class_3545<class_5321<class_1937>, class_2338> getBeginnerSpawn() {
        return this.beginnerSpawn;
    }

    public void setBeginnerSpawn(class_5321<class_1937> dimensionKey, class_2338 blockPos) {
        this.beginnerSpawn = new class_3545(dimensionKey, (Object)blockPos);
        this.method_80();
        this.updateBeginnerSpawn = false;
    }

    public boolean shouldUpdateBeginnerSpawn() {
        return this.updateBeginnerSpawn;
    }

    public void method_77(class_2487 tag) {
        for (MatchSplit split : MatchSplit.values()) {
            if (!tag.method_10545(split.name().toLowerCase())) continue;
            class_2487 splitTag = tag.method_10562(split.name().toLowerCase());
            this.getSplitPosMap().put(split, new PlayerPosition(splitTag));
        }
        for (class_2520 deathTag : tag.method_10554("death_points", (int)new class_2487().method_10711())) {
            class_2487 splitTag = (class_2487)deathTag;
            this.getDeathPointList().add(new PlayerPosition(splitTag));
        }
        if (tag.method_10573("beginner_spawn", 10)) {
            class_2487 beginnerTag = tag.method_10562("beginner_spawn");
            this.beginnerSpawn = new class_3545((Object)class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)class_2960.method_12829((String)beginnerTag.method_10558("world"))), (Object)new class_2338(beginnerTag.method_10550("x"), beginnerTag.method_10550("y"), beginnerTag.method_10550("z")));
        }
    }

    public class_2487 method_75(class_2487 tag) {
        for (Map.Entry<MatchSplit, PlayerPosition> entry : this.getSplitPosMap().entrySet()) {
            tag.method_10566(entry.getKey().name().toLowerCase(), (class_2520)entry.getValue().toTag());
        }
        class_2499 listTag = new class_2499();
        for (PlayerPosition deathPoint : this.getDeathPointList()) {
            listTag.add((Object)deathPoint.toTag());
        }
        tag.method_10566("death_points", (class_2520)listTag);
        if (this.beginnerSpawn != null) {
            class_2487 class_24872 = new class_2487();
            class_24872.method_10582("world", ((class_5321)this.beginnerSpawn.method_15442()).method_29177().toString());
            class_24872.method_10569("x", ((class_2338)this.beginnerSpawn.method_15441()).method_10263());
            class_24872.method_10569("y", ((class_2338)this.beginnerSpawn.method_15441()).method_10264());
            class_24872.method_10569("z", ((class_2338)this.beginnerSpawn.method_15441()).method_10260());
            tag.method_10566("beginner_spawn", (class_2520)class_24872);
        }
        return tag;
    }

    public static class PlayerPosition {
        private final WorldTypes world;
        private final class_243 pos;
        private final float pitch;
        private final float yaw;

        private PlayerPosition(class_1657 player) {
            this.world = WorldTypes.fromDimension(player.field_6002.method_8597());
            this.pos = player.method_19538();
            this.pitch = player.field_5965;
            this.yaw = player.method_5791();
        }

        private PlayerPosition(class_2487 tag) {
            this.world = WorldTypes.values()[tag.method_10550("dimension")];
            this.pos = new class_243(tag.method_10574("x"), tag.method_10574("y"), tag.method_10574("z"));
            this.pitch = tag.method_10583("pitch");
            this.yaw = tag.method_10583("yaw");
        }

        class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10569("dimension", this.world.ordinal());
            tag.method_10549("x", this.pos.method_10216());
            tag.method_10549("y", this.pos.method_10214());
            tag.method_10549("z", this.pos.method_10215());
            tag.method_10548("pitch", this.pitch);
            tag.method_10548("yaw", this.yaw);
            return tag;
        }

        public WorldTypes getWorld() {
            return this.world;
        }

        public class_243 getPos() {
            return this.pos;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getYaw() {
            return this.yaw;
        }
    }
}

