/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.world;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.compatible.CompatibleWorker;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.standardrng.LavaLakeInfo;
import com.mcsrranked.client.standardrng.WorldSpawnState;
import com.mcsrranked.client.standardrng.interfaces.PreInitWorldData;
import com.mcsrranked.client.vanillafix.RenderTaskQueue;
import com.mcsrranked.client.vanillafix.WorldLeaveWorker;
import com.mcsrranked.client.world.CloneableState;
import com.mcsrranked.client.world.SeedSeparateHelper;
import com.mcsrranked.client.world.ServerTaskClearer;
import com.mcsrranked.client.world.WorldCacheStatus;
import com.mcsrranked.client.world.WorldCreatorBuilder;
import com.mcsrranked.client.world.WorldResourceManager;
import com.mcsrranked.client.world.WorldServerInfo;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import com.redlimerl.speedrunigt.timer.running.RunType;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1132;
import net.minecraft.class_1267;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_2170;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2631;
import net.minecraft.class_2791;
import net.minecraft.class_2852;
import net.minecraft.class_2889;
import net.minecraft.class_2915;
import net.minecraft.class_31;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3286;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_3312;
import net.minecraft.class_3928;
import net.minecraft.class_3949;
import net.minecraft.class_3952;
import net.minecraft.class_3953;
import net.minecraft.class_424;
import net.minecraft.class_435;
import net.minecraft.class_437;
import net.minecraft.class_5219;
import net.minecraft.class_5281;
import net.minecraft.class_5285;
import net.minecraft.class_5318;
import net.minecraft.class_5321;
import net.minecraft.class_5359;
import net.minecraft.class_5363;
import net.minecraft.class_5382;
import net.minecraft.class_634;
import net.minecraft.class_635;
import net.minecraft.class_638;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class WorldCreator {
    private static final class_310 client = class_310.method_1551();
    private static final List<String> CURRENT_WORLD_STACK = Lists.newArrayList();
    private static final class_5359 DEFAULT_DATAPACKS = new class_5359((List)ImmutableList.of((Object)"vanilla"), (List)ImmutableList.of());
    private static WorldCreator LAST_INSTANCE = new WorldCreatorBuilder(0L, 0L).build();
    public static final Pattern WORLD_NAME_REGEX = Pattern.compile("mcsrranked #([a-zA-Z0-9]{9})$");
    private final long overworldSeed;
    private final long netherSeed;
    private final long theEndSeed;
    private final long rngSeed;
    private final int serverCount;
    private final int queuePriority;
    private final boolean spectate;
    private final class_1934 defaultGameMode;
    private final boolean hardcore;
    private final boolean allowCommands;
    private final TimerInitializer timerConsumer;
    private final DataPacksModifier dataPacksModifier;
    private final Runnable beforeReset;
    private final Runnable beforeLeave;
    private final Consumer<class_1928> gameRulesConsumer;
    private final Consumer<WorldCreator> beforeJoin;
    private final AtomicReference<WorldServerInfo> currentServer = new AtomicReference();
    private final Set<String> levelNameSet = new CopyOnWriteArraySet<String>();
    private final CopyOnWriteArrayList<WorldServerInfo> serverInfoList = new CopyOnWriteArrayList();
    private final AtomicInteger serverIndex = new AtomicInteger(1);
    private final AtomicReference<WorldResourceManager> resourceManager = new AtomicReference();
    private final AtomicReference<MinecraftSessionService> sessionService = new AtomicReference();
    private final AtomicReference<GameProfileRepository> gameProfileRepository = new AtomicReference();
    private final AtomicReference<class_3312> userCache = new AtomicReference();
    private WorldCacheStatus cacheStatus = WorldCacheStatus.NONE;
    private final Map<String, Map<Long, class_2487>> cachedChunkMap = new HashMap<String, Map<Long, class_2487>>();
    private List<class_1923> cachedStrongholds = Lists.newArrayList();
    private Map<class_5321<class_1937>, Map<String, CloneableState<?>>> cachedStates = null;
    private boolean running = false;
    private boolean enableCheat = false;

    public static WorldCreator getInstance() {
        return LAST_INSTANCE;
    }

    WorldCreator(long overworldSeed, long netherSeed, long theEndSeed, long rngSeed, int serverCount, int queuePriority, boolean spectate, class_1934 defaultGameMode, boolean hardcore, boolean allowCommands, TimerInitializer timerConsumer, DataPacksModifier dataPacksModifier, Runnable beforeReset, Runnable beforeLeave, Consumer<class_1928> gameRulesConsumer, Consumer<WorldCreator> beforeJoin) {
        this.overworldSeed = overworldSeed;
        this.netherSeed = netherSeed;
        this.theEndSeed = theEndSeed;
        this.rngSeed = rngSeed;
        this.serverCount = serverCount;
        this.queuePriority = queuePriority;
        this.spectate = spectate;
        this.defaultGameMode = defaultGameMode;
        this.hardcore = hardcore;
        this.allowCommands = allowCommands;
        this.timerConsumer = timerConsumer;
        this.dataPacksModifier = dataPacksModifier;
        this.beforeReset = beforeReset;
        this.beforeLeave = beforeLeave;
        this.gameRulesConsumer = gameRulesConsumer;
        this.beforeJoin = beforeJoin;
    }

    @Nullable
    public WorldServerInfo getCurrentServer() {
        return this.currentServer.get();
    }

    public void start() {
        if (LAST_INSTANCE != null) {
            LAST_INSTANCE.shutdown();
        }
        MCSRRankedClient.LOGGER.info("[WorldCreator] Start creating worlds...");
        LAST_INSTANCE = this;
        this.cacheStatus = WorldCacheStatus.CACHING;
        this.openLoadingScreen();
        this.running = true;
        this.createWorld();
        this.joinWorld();
        this.cacheStatus = WorldCacheStatus.READY;
        for (int i = 1; i <= this.serverCount; ++i) {
            this.createQueue();
        }
    }

    public void shutdown() {
        MCSRRankedClient.LOGGER.info("[WorldCreator] Shutdown all servers...");
        this.cachedChunkMap.clear();
        this.cacheStatus = WorldCacheStatus.NONE;
        this.levelNameSet.clear();
        this.running = false;
        WorldServerInfo serverInfo = this.getCurrentServer();
        if (serverInfo != null && !serverInfo.getServer().method_3750()) {
            class_1132 server = serverInfo.getServer();
            server.execute(() -> {
                MCSRRankedClient.LOGGER.info("[WorldCreator] Stopping '{}'...", (Object)server.method_27728().method_150());
                server.method_3747(false);
            });
        }
        for (WorldServerInfo info : this.serverInfoList) {
            class_1132 server = info.getServer();
            if (server.method_3750()) continue;
            server.execute(() -> {
                MCSRRankedClient.LOGGER.info("[WorldCreator] Stopping '{}'...", (Object)server.method_27728().method_150());
                server.method_3747(false);
            });
        }
        this.serverInfoList.clear();
        this.levelNameSet.clear();
        WorldResourceManager resource = this.resourceManager.get();
        if (resource != null) {
            resource.shutdown();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void createQueue() {
        MCSRRankedClient.LOGGER.info("[WorldCreator] creating new queue...");
        Thread thread = new Thread(() -> {
            try {
                this.createWorld();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        thread.setName("Queue Server #" + this.serverIndex.getAndIncrement());
        thread.setPriority(this.queuePriority);
        thread.start();
    }

    private void openLoadingScreen() {
        client.method_18099();
        class_435 progressScreen = new class_435();
        progressScreen.method_15412((class_2561)new class_2588("menu.generatingLevel").method_27693("..."));
        client.method_29970((class_437)progressScreen);
    }

    private void await() {
        try {
            Thread.sleep(16L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void createWorld() {
        String newWorldName = String.format("%s #%s", "mcsrranked", RandomStringUtils.randomAlphanumeric((int)9));
        WorldCreator.deleteOldWorlds();
        CURRENT_WORLD_STACK.add(newWorldName);
        CompatibleWorker.disableAtumResetting();
        WorldCreator.client.field_1705.method_1763(null, null, -1, -1, -1);
        class_1928 gameRules = new class_1928();
        this.gameRulesConsumer.accept(gameRules);
        ArrayList enabledDataPacks = Lists.newArrayList((Iterable)DEFAULT_DATAPACKS.method_29547());
        ArrayList disabledDataPacks = Lists.newArrayList((Iterable)DEFAULT_DATAPACKS.method_29550());
        this.dataPacksModifier.modify(enabledDataPacks, disabledDataPacks);
        class_5359 dataPackSettings = new class_5359((List)enabledDataPacks, (List)disabledDataPacks);
        class_1940 levelInfo = new class_1940(newWorldName, this.defaultGameMode != null ? this.defaultGameMode : class_1934.field_9215, this.hardcore, this.hardcore ? class_1267.field_5807 : class_1267.field_5805, this.allowCommands, gameRules, dataPackSettings);
        class_5285 generatorOptions = class_5285.method_28009().method_28024(false, OptionalLong.of(this.overworldSeed));
        if (!generatorOptions.method_28029()) {
            generatorOptions = generatorOptions.method_28037();
        }
        if (generatorOptions.method_28030()) {
            generatorOptions = generatorOptions.method_28038();
        }
        ((SeedSeparateHelper)generatorOptions).ss$setNetherSeed(this.netherSeed);
        ((SeedSeparateHelper)generatorOptions).ss$setTheEndSeed(this.theEndSeed);
        ((SeedSeparateHelper)generatorOptions).ss$setRNGSeed(this.rngSeed);
        this.levelNameSet.add(levelInfo.method_27339());
        try {
            this.startServer(levelInfo, generatorOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void startServer(class_1940 levelInfo, class_5285 generatorOptions) throws Exception {
        WorldCreator.deleteWorld(levelInfo.method_27339());
        class_32 levelStorage = client.method_1586();
        class_32.class_5143 session = levelStorage.method_27002(levelInfo.method_27339());
        class_5318.class_5319 registryTracker = class_5318.method_29117();
        WorldResourceManager worldResourceManager = this.createResourceManager(levelInfo);
        class_5382 registryOps = class_5382.method_29753((DynamicOps)JsonOps.INSTANCE, (class_3300)worldResourceManager.getServerResourceManager().method_29474(), (class_5318)registryTracker);
        DataResult dataResult = registryOps.method_29755(generatorOptions.method_28609(), class_2378.field_25490, class_5363.field_25411);
        class_2370 simpleRegistry = dataResult.resultOrPartial(arg_0 -> ((Logger)MCSRRankedClient.LOGGER).error(arg_0)).orElse(generatorOptions.method_28609());
        class_31 saveProperties = new class_31(levelInfo, generatorOptions.method_29573(simpleRegistry), dataResult.lifecycle());
        saveProperties.method_24285("mcsrranked", true);
        session.method_27425((class_5318)registryTracker, (class_5219)saveProperties);
        worldResourceManager.getServerResourceManager().method_29475();
        if (this.sessionService.get() == null || this.gameProfileRepository.get() == null) {
            YggdrasilAuthenticationService yggdrasilAuthenticationService = new YggdrasilAuthenticationService(client.method_1487(), UUID.randomUUID().toString());
            this.sessionService.set(yggdrasilAuthenticationService.createMinecraftSessionService());
            this.gameProfileRepository.set(yggdrasilAuthenticationService.createProfileRepository());
        }
        if (this.userCache.get() == null) {
            this.userCache.set(new class_3312(this.gameProfileRepository.get(), new File(WorldCreator.client.field_1697, MinecraftServer.field_4588.getName())));
            class_2631.method_11337((class_3312)this.userCache.get());
            class_2631.method_11336((MinecraftSessionService)this.sessionService.get());
            class_3312.method_14510((boolean)false);
        }
        class_3953 worldProgressTracker = new class_3953(11);
        Integer priority = Thread.currentThread().getName().startsWith("Queue Server #") ? Integer.valueOf(Thread.currentThread().getPriority()) : null;
        class_1132 newServer = (class_1132)MinecraftServer.method_29740(serverThread -> {
            class_1132 resultServer = new class_1132(serverThread, client, registryTracker, session, worldResourceManager.getResourcePackManager(), worldResourceManager.getServerResourceManager(), (class_5219)saveProperties, this.sessionService.get(), this.gameProfileRepository.get(), this.userCache.get(), i -> {
                worldProgressTracker.method_17675();
                return new class_3952((class_3949)worldProgressTracker, runnable -> ((RenderTaskQueue)client).ranked$addRenderTask(runnable));
            });
            if (priority != null) {
                serverThread.setPriority(priority);
            }
            this.serverInfoList.add(new WorldServerInfo(levelInfo.method_27339(), resultServer, worldProgressTracker));
            ((PreInitWorldData)resultServer).ranked$setUpdater(this::onFinishWorldLoad);
            return resultServer;
        });
        MCSRRankedClient.LOGGER.info("[WorldCreator] starting '{}'... ", (Object)newServer.method_27728().method_150());
    }

    private WorldResourceManager createResourceManager(class_1940 levelInfo) {
        if (this.resourceManager.get() == null) {
            class_3283 resourcePackManager = new class_3283(class_3288::new, new class_3285[]{new class_3286(), client.method_1516()});
            MinecraftServer.method_29736((class_3283)resourcePackManager, (class_5359)levelInfo.method_29558(), (boolean)false);
            WorldResourceManager.ResourceManager serverResourceManager = WorldResourceManager.createServer(resourcePackManager.method_29211(), class_2170.class_5364.field_25421, 2, class_156.method_18349(), class_156.method_18349()).join();
            WorldResourceManager result = new WorldResourceManager((class_3283<class_3288>)resourcePackManager, serverResourceManager);
            this.resourceManager.set(result);
        }
        return this.resourceManager.get();
    }

    private void joinWorld() {
        if (!client.method_18854()) {
            client.execute(this::joinWorld);
            return;
        }
        MCSRRankedClient.LOGGER.info("[WorldCreator] joining the server...");
        if (!this.spectate) {
            CompatibleWorker.standardSettingsInit();
            this.beforeJoin.accept(this);
        }
        if (!this.running) {
            throw new RuntimeException("you can't join world without creator start");
        }
        while (this.serverInfoList.isEmpty()) {
            this.await();
        }
        WorldServerInfo serverInfo = this.serverInfoList.remove(0);
        if (this.enableCheat) {
            serverInfo.getServer().method_3760().method_14607(true);
            if (this.defaultGameMode == null) {
                serverInfo.getServer().method_3838(class_1934.field_9220);
            }
        }
        this.currentServer.set(serverInfo);
        WorldCreator.client.field_1766 = serverInfo.getServer();
        WorldCreator.client.field_1766.method_3777().setPriority(5);
        class_3928 levelLoadingScreen = new class_3928(serverInfo.getTracker());
        client.method_1507((class_437)levelLoadingScreen);
        while (!serverInfo.getServer().method_3820() && serverInfo.getServer().method_3806()) {
            levelLoadingScreen.method_25393();
            client.method_1523(false);
            this.await();
        }
        SocketAddress socketAddress = Objects.requireNonNull(WorldCreator.client.field_1766.method_3787()).method_14353();
        class_2535 clientConnection = class_2535.method_10769((SocketAddress)socketAddress);
        clientConnection.method_10763((class_2547)new class_635(clientConnection, client, null, text -> {}));
        clientConnection.method_10743((class_2596)new class_2889(socketAddress.toString(), 0, class_2539.field_20593));
        clientConnection.method_10743((class_2596)new class_2915(client.method_1548().method_1677()));
        WorldCreator.client.field_1746 = clientConnection;
        WorldCreator.client.field_1759 = true;
        if (!this.spectate) {
            CompatibleWorker.standardSettingsTail(serverInfo.getWorldName());
        }
        this.timerConsumer.init(InGameTimer.getInstance(), serverInfo);
        InGameTimer.start((String)serverInfo.getWorldName(), (RunType)RunType.SET_SEED);
    }

    private void onFinishWorldLoad(MinecraftServer server) {
        if (this.cachedStates != null) {
            for (class_3218 world : server.method_3738()) {
                Map<String, CloneableState<?>> stateMap = this.cachedStates.get(world.method_27983());
                if (stateMap == null) continue;
                for (Map.Entry<String, CloneableState<?>> entry : stateMap.entrySet()) {
                    world.method_17983().method_123(entry.getValue().copy());
                }
            }
        } else {
            this.cachedStates = new HashMap();
            for (class_3218 world : server.method_3738()) {
                class_5321 key = world.method_27983();
                HashMap<String, CloneableState> worldStates = new HashMap<String, CloneableState>();
                for (Map.Entry entry : world.method_17983().field_134.entrySet()) {
                    if (!(entry.getValue() instanceof CloneableState)) continue;
                    worldStates.put((String)entry.getKey(), (CloneableState)entry.getValue());
                }
                this.cachedStates.put((class_5321<class_1937>)key, worldStates);
            }
        }
        this.checkArtificialLavaPool(server);
    }

    private void checkArtificialLavaPool(MinecraftServer server) {
        AtomicBoolean lavaPool = new AtomicBoolean(false);
        server.execute(() -> {
            for (LavaLakeInfo lavaLakeInfo : WorldSpawnState.fromWorld(server.method_30002()).getLavaLakeList()) {
                lavaLakeInfo.checkGenerated((class_5281)server.method_30002(), server.method_30002().method_27056(), server.method_30002().method_14178().method_12129());
            }
            lavaPool.set(true);
        });
        while (!lavaPool.get()) {
            this.await();
        }
    }

    public void stopWorld() {
        if (!client.method_18854()) {
            client.execute(this::stopWorld);
            return;
        }
        this.leaveWorld();
        MCSRRankedClient.exitReplay();
        this.shutdown();
    }

    public void leaveWorld() {
        if (!client.method_18854()) {
            client.method_19537(this::leaveWorld);
            return;
        }
        MCSRRankedClient.LOGGER.info("[WorldCreator] leaving the server...");
        CompatibleWorker.setFastResetActivate(true);
        class_1132 server = WorldCreator.client.field_1766;
        class_638 clientWorld = WorldCreator.client.field_1687;
        if (!(server == null || clientWorld != null || WorldCreator.client.field_1746 != null && WorldCreator.client.field_1746.method_10772())) {
            ((ServerTaskClearer)server).ranked$stopAllTasks();
            MCSRRankedClient.LOGGER.info("[WorldCreator] stopping '{}' before client connect...", (Object)server.method_27728().method_150());
            WorldCreator.client.field_1766 = null;
        } else if (clientWorld != null) {
            class_424 workingScreen = new class_424((class_2561)new class_2588("menu.working"));
            clientWorld.method_8525();
            class_634 clientPlayNetworkHandler = client.method_1562();
            if (clientPlayNetworkHandler != null) {
                client.method_18855();
                clientPlayNetworkHandler.method_2868();
            }
            if (server != null) {
                client.method_29970((class_437)workingScreen);
                ((ServerTaskClearer)server).ranked$stopAllTasks();
                MCSRRankedClient.LOGGER.info("[WorldCreator] stopping '{}' integrated server...", (Object)server.method_27728().method_150());
                WorldCreator.client.field_1766 = null;
            }
            client.method_18096((class_437)workingScreen);
        } else if (server != null) {
            MCSRRankedClient.LOGGER.info("[WorldCreator] stopping '{}' server only...", (Object)server.method_27728().method_150());
            ((ServerTaskClearer)server).ranked$stopAllTasks();
            WorldCreator.client.field_1766 = null;
        }
        CompatibleWorker.setFastResetActivate(false);
        ((WorldLeaveWorker)client).ranked$resetWorldCache();
    }

    public void resetWorld() {
        if (!client.method_18854()) {
            client.execute(this::resetWorld);
            return;
        }
        MCSRRankedClient.LOGGER.info("[WorldCreator] resetting the server...");
        WorldServerInfo serverInfo = this.getCurrentServer();
        if (serverInfo == null) {
            return;
        }
        if (WorldCreator.client.field_1687 == null) {
            return;
        }
        if (client.method_1562() == null) {
            return;
        }
        if (client.method_1562().method_2890() == null) {
            return;
        }
        this.beforeLeave.run();
        this.leaveWorld();
        this.beforeReset.run();
        this.createQueue();
        this.joinWorld();
    }

    public void setEnableCheat(boolean enableCheat) {
        this.enableCheat = enableCheat;
    }

    public void addCachedChunk(class_1923 chunkPos, class_2791 chunk, class_3218 world) {
        String registryKey = world.method_27983().toString();
        if (!this.cachedChunkMap.containsKey(registryKey)) {
            this.cachedChunkMap.put(registryKey, new HashMap());
        }
        Map<Long, class_2487> map = this.cachedChunkMap.get(registryKey);
        map.put(chunkPos.method_8324(), class_2852.method_12410((class_3218)world, (class_2791)chunk));
    }

    public class_2487 getCachedChunkTag(class_1923 chunkPos, class_3218 world) {
        Map<Long, class_2487> map = this.cachedChunkMap.get(world.method_27983().toString());
        return map == null ? null : map.get(chunkPos.method_8324());
    }

    public void updateCachedStrongholds(List<class_1923> strongholds) {
        this.cachedStrongholds = strongholds;
    }

    public List<class_1923> getCachedStrongholds() {
        return this.cachedStrongholds;
    }

    public WorldCacheStatus getCacheStatus() {
        return this.cacheStatus;
    }

    public boolean isInCreator(MinecraftServer server) {
        return this.levelNameSet.contains(server.method_27728().method_150());
    }

    private static void deleteOldWorlds() {
        File[] saves;
        class_32 levelStorage = client.method_1586();
        if (CURRENT_WORLD_STACK.isEmpty() && (saves = levelStorage.method_19636().toFile().listFiles()) != null) {
            Arrays.stream(saves).filter(Objects::nonNull).sorted(Comparator.comparingLong(File::lastModified).thenComparing(File::getName)).forEach(save -> {
                Matcher nameMatcher;
                if (save.isDirectory() && (nameMatcher = WORLD_NAME_REGEX.matcher(save.getName())).find()) {
                    CURRENT_WORLD_STACK.add(save.getName());
                }
            });
        }
        MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
            int worldCount = (Integer)SpeedRunOption.getOption(RankedOptions.WORLD_MAX_SAVE);
            while (CURRENT_WORLD_STACK.size() > worldCount) {
                String target = CURRENT_WORLD_STACK.remove(0);
                WorldCreator.deleteWorld(target);
            }
        });
    }

    private static void deleteWorld(String worldName) {
        class_32 levelStorage = client.method_1586();
        if (levelStorage.method_230(worldName)) {
            try {
                class_32.class_5143 session = levelStorage.method_27002(worldName);
                session.method_27015();
                session.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface TimerInitializer {
        public void init(InGameTimer var1, WorldServerInfo var2);
    }

    public static interface DataPacksModifier {
        public void modify(List<String> var1, List<String> var2);
    }
}

