/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.file.verifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.file.verifiers.FileVerifier;
import com.mcsrranked.client.utils.ClientUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModOrigin;
import org.apache.commons.codec.binary.Hex;

public class ModVerifier
extends FileVerifier<ModContainer> {
    public static final String SRC_WHITELIST = "https://raw.githubusercontent.com/tildejustin/mcsr-meta/refs/heads/schema-6/mods.json";

    public ModVerifier() throws IOException, IllegalStateException {
        super("allowed-mods");
        try {
            JsonElement response = Optional.ofNullable(ClientUtils.getApiResponse(SRC_WHITELIST)).orElseThrow(IOException::new);
            JsonArray mods = response.getAsJsonObject().getAsJsonArray("mods");
            for (JsonElement mod : mods) {
                JsonObject modObject = mod.getAsJsonObject();
                for (JsonElement version : modObject.getAsJsonArray("versions")) {
                    JsonObject versionObject = version.getAsJsonObject();
                    String modVersion = versionObject.get("version").getAsString();
                    boolean hasVersion = false;
                    for (JsonElement targetVersion : versionObject.getAsJsonArray("target_version")) {
                        if (!targetVersion.getAsString().equals(((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow(IllegalStateException::new)).getMetadata().getVersion().getFriendlyString())) continue;
                        hasVersion = true;
                    }
                    if (!hasVersion) continue;
                    for (FileVerifier.VerifiableFile allowedFile : this.getAllowedFiles()) {
                        if (!allowedFile.name.equals(modObject.get("modid").getAsString()) || !allowedFile.hashes.stream().noneMatch(h -> {
                            assert (h.version != null);
                            return h.version.equals(modVersion);
                        })) continue;
                        allowedFile.hashes.add(new FileVerifier.VerifiableFile.Hash(Base64.getEncoder().encodeToString(Hex.decodeHex((char[])versionObject.get("hash").getAsString().toCharArray())), versionObject.get("version").getAsString(), "SHA-512"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void preLaunch() {
        Set illegalMods = this.filterStream(FabricLoader.getInstance().getAllMods().stream()).collect(Collectors.toSet());
        if (!illegalMods.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            HashMap rejectionMaps = new HashMap();
            for (FileVerifier.IllegalFile illegalFile : illegalMods) {
                FileVerifier.RejectionReason reason = illegalFile.getRejectionReason();
                if (((ModContainer)illegalFile.file).getOrigin().getKind() == ModOrigin.Kind.NESTED || ((ModContainer)illegalFile.file).getOrigin().getPaths() == null) continue;
                for (Path path : ((ModContainer)illegalFile.file).getOrigin().getPaths()) {
                    if (!rejectionMaps.containsKey((Object)reason)) {
                        rejectionMaps.put(reason, new HashSet());
                    }
                    ((Set)rejectionMaps.get((Object)reason)).add(path.toFile().getName() + " [" + ((ModContainer)illegalFile.file).getMetadata().getId() + "]");
                }
            }
            for (Map.Entry entry : rejectionMaps.entrySet()) {
                builder.append(((FileVerifier.RejectionReason)((Object)entry.getKey())).getRejectionTitle("Fabric Mod")).append("\n");
                for (String s : (Set)entry.getValue()) {
                    builder.append("\t").append(s).append("\n");
                }
            }
            if (!rejectionMaps.isEmpty()) {
                RuntimeException exception = new RuntimeException("Incompatible mod set found! READ THE BELOW LINES!\n" + builder);
                exception.setStackTrace(new StackTraceElement[0]);
                throw exception;
            }
        }
    }

    @Override
    public void preMixin() {
    }

    @Override
    public void preClient() {
    }

    @Override
    public Stream<FileVerifier.IllegalFile> filterStream(Stream<ModContainer> input) {
        return super.filterStream(input).filter(Objects::nonNull).filter(modContainer -> {
            if (((ModContainer)modContainer.file).getMetadata().getId().equals("fabricloader") || ((ModContainer)modContainer.file).getMetadata().getId().equals("minecraft") || ((ModContainer)modContainer.file).getMetadata().getId().equals("java")) {
                return false;
            }
            ModOrigin origin = ((ModContainer)modContainer.file).getOrigin();
            if (origin.getKind() == ModOrigin.Kind.NESTED && Objects.equals(origin.getParentModId(), "mcsrranked")) {
                MCSRRankedClient.LOGGER.warn("Builtin mod '{}' in MCSR Ranked", (Object)((ModContainer)modContainer.file).getMetadata().getId());
                return false;
            }
            return true;
        });
    }

    @Override
    public Optional<FileVerifier.RejectionReason> compareFiles(ModContainer file, Set<FileVerifier.VerifiableFile> verifiableFiles) {
        Optional<FileVerifier.VerifiableFile> verifiableFile = verifiableFiles.stream().filter(vf -> Objects.equals(vf.name, file.getMetadata().getId())).findFirst();
        if (verifiableFile.isPresent()) {
            Optional<FileVerifier.VerifiableFile.Hash> versionHash = verifiableFile.get().getVersionHash(file.getMetadata().getVersion().getFriendlyString());
            if (versionHash.isPresent()) {
                String hashValue = versionHash.get().value;
                return this.fileToHash(file, versionHash.get().algorithm).map(s -> s.equals(hashValue)).orElse(false) != false ? Optional.empty() : Optional.of(FileVerifier.RejectionReason.HASH);
            }
            return Optional.of(FileVerifier.RejectionReason.VERSION);
        }
        return Optional.of(FileVerifier.RejectionReason.ID);
    }

    @Override
    public Optional<String> fileToHash(ModContainer file, String algorithm) {
        try {
            return ModVerifier.digestFileStream(Files.newInputStream((Path)file.getOrigin().getPaths().get(0), new OpenOption[0]), algorithm);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

