/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay;

import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.file.ReplayManager;
import com.mcsrranked.client.anticheat.replay.render.ReplayBoatEntity;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerEntity;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.PersonalPlayerTracker;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.socket.SocketInstance;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.SecretKey;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.apache.commons.io.FileUtils;

public class Replay {
    public static final class_1299<ReplayPlayerEntity> REPLAY_PLAYER_ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)new class_2960("mcsrranked", "replay_player"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, ReplayPlayerEntity::new).disableSaving().fireImmune().disableSummon().spawnableFarFromPlayer().dimensions(class_4048.method_18384((float)0.6f, (float)1.8f)).build());
    public static final class_1299<ReplayBoatEntity> REPLAY_BOAT_ENTITY_TYPE = (class_1299)class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)new class_2960("mcsrranked", "replay_boat"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, ReplayBoatEntity::new).disableSaving().fireImmune().disableSummon().spawnableFarFromPlayer().dimensions(class_4048.method_18384((float)1.375f, (float)0.5625f)).build());
    private final PersonalPlayerTracker personalPlayerTracker;
    private final ReplayProcessor replayProcessor = new ReplayProcessor();
    private final SecretKey symmetricKey;
    private final byte[] signedSymmetricKeyArray;

    public static void onInitializeClient() {
        EntityRendererRegistry.INSTANCE.register(REPLAY_PLAYER_ENTITY_TYPE, (manager, context) -> new ReplayPlayerEntity.Renderer(manager));
        FabricDefaultAttributeRegistry.register(REPLAY_PLAYER_ENTITY_TYPE, (class_5132.class_5133)ReplayPlayerEntity.method_26827().method_26867(class_5134.field_23717).method_26868(class_5134.field_23716, 65535.0));
        EntityRendererRegistry.INSTANCE.register(REPLAY_BOAT_ENTITY_TYPE, (manager, context) -> new ReplayBoatEntity.Renderer(manager));
        FabricDefaultAttributeRegistry.register(REPLAY_BOAT_ENTITY_TYPE, (class_5132.class_5133)ReplayBoatEntity.method_26827().method_26867(class_5134.field_23717).method_26868(class_5134.field_23716, 65535.0));
    }

    public String getSymmetricKey() {
        return Base64.getEncoder().encodeToString(this.signedSymmetricKeyArray);
    }

    public Replay(String signedSymmetricKey) {
        byte[] signedSymmetricKeyArray1;
        this.personalPlayerTracker = new PersonalPlayerTracker();
        try {
            if (signedSymmetricKey.isEmpty()) {
                throw new IllegalArgumentException();
            }
            signedSymmetricKeyArray1 = Base64.getDecoder().decode(signedSymmetricKey);
        }
        catch (IllegalArgumentException e) {
            this.signedSymmetricKeyArray = null;
            this.symmetricKey = null;
            return;
        }
        this.signedSymmetricKeyArray = signedSymmetricKeyArray1;
        try {
            this.symmetricKey = ReplayManager.generateSecretKey(this.signedSymmetricKeyArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SocketInstance.on("m$replay_tracking", payload -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            try {
                onlineMatch.updateReplay(payload.getNextBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
        SocketInstance.on("m$replay_meta", data -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> onlineMatch.closeReplayStream().thenRun(() -> {
            try {
                int bytesRead;
                int index = 0;
                Path path = ReplayManager.REPLAY_FILE_PATH.resolve(new SimpleDateFormat("yyMMdd-HHmmss").format(new Date()) + ".rrf");
                FileUtils.write((File)path.toFile(), (CharSequence)"", (Charset)StandardCharsets.UTF_8);
                ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(path, StandardOpenOption.APPEND));
                while (data.hasNext()) {
                    String property = data.getNextString();
                    if (index++ % 2 == 0) {
                        zipOutputStream.putNextEntry(new ZipEntry(property));
                        continue;
                    }
                    zipOutputStream.write(property.getBytes(StandardCharsets.UTF_8));
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.putNextEntry(new ZipEntry("replay.rpd"));
                InputStream inputStream = Files.newInputStream(MCSRRankedClient.TEMP_REPLAY_FILE.toPath(), new OpenOption[0]);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    zipOutputStream.write(buffer, 0, bytesRead);
                }
                inputStream.close();
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        })));
    }

    public Replay(Replay replay) {
        this(replay.getSymmetricKey());
        this.getPersonalPlayerTracker().copySettings(replay.getPersonalPlayerTracker());
        for (BasePlayer player : replay.getReplayProcessor().getPlayers()) {
            this.addOpponentPlayer(player);
        }
    }

    public Optional<OpponentPlayerTracker> getOpponentPlayerTracker(UUID uuid) {
        return this.getReplayProcessor().getTracker(uuid);
    }

    public void addOpponentPlayer(BasePlayer player) {
        this.getReplayProcessor().addNewTracker(player);
    }

    public void removeOpponentPlayer(BasePlayer player) {
        this.getReplayProcessor().removeTracker(player);
    }

    public PersonalPlayerTracker getPersonalPlayerTracker() {
        return this.personalPlayerTracker;
    }

    public ReplayProcessor getReplayProcessor() {
        return this.replayProcessor;
    }

    public SecretKey getSecretKey() {
        return this.symmetricKey;
    }

    public void reset() {
        this.getPersonalPlayerTracker().reset();
        this.getReplayProcessor().reset();
    }
}

