/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay;

import com.google.common.collect.Lists;
import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerEntity;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.ReplayPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1132;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;

public class ReplayEntityManager {
    public static final AtomicInteger ID_GENERATOR = new AtomicInteger(-200);
    private final OpponentPlayerTracker tracker;
    private final ReplayPlayerTracker replayPlayerTracker;
    private final Map<UUID, ReplayEntityTracker<?>> entityTrackers = new ConcurrentHashMap();
    private int followTask = 0;

    public ReplayEntityManager(OpponentPlayerTracker tracker, UUID targetUUID, String nickname) {
        this.tracker = tracker;
        this.replayPlayerTracker = new ReplayPlayerTracker(tracker, ID_GENERATOR.decrementAndGet(), targetUUID, nickname);
    }

    public <T extends class_1297> ReplayEntityTracker<?> spawnEntity(class_3218 world, T entity, class_243 spawnPos, float yaw, float pitch) {
        this.entityTrackers.putIfAbsent(entity.method_5667(), new ReplayEntityTracker<T>(this.tracker, ID_GENERATOR.decrementAndGet(), entity, WorldTypes.fromDimension(world.method_8597())));
        ReplayEntityTracker<?> entityTracker = this.entityTrackers.get(entity.method_5667());
        entityTracker.setDimension(WorldTypes.fromDimension(world.method_8597()));
        entityTracker.setSpawnPos(spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), yaw, pitch);
        entityTracker.setPos(spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), yaw, pitch);
        return entityTracker;
    }

    public ReplayEntityTracker<?> getEntityTracker(UUID uuid) {
        return this.entityTrackers.get(uuid);
    }

    public void moveEntity(class_3218 serverWorld, UUID uuid) {
        if (this.entityTrackers.containsKey(uuid)) {
            this.entityTrackers.get(uuid).backToSpawn();
        }
    }

    public void moveEntity(class_3218 serverWorld, UUID uuid, class_243 vec3d) {
        if (this.entityTrackers.containsKey(uuid)) {
            ReplayEntityTracker<?> entityTracker = this.entityTrackers.get(uuid);
            this.moveEntity(serverWorld, uuid, vec3d, entityTracker.getYaw(), entityTracker.getPitch());
        }
    }

    public void moveEntity(class_3218 serverWorld, UUID uuid, float yaw, float pitch) {
        if (this.entityTrackers.containsKey(uuid)) {
            ReplayEntityTracker<?> entityTracker = this.entityTrackers.get(uuid);
            this.moveEntity(serverWorld, uuid, entityTracker.getPos(), yaw, pitch);
        }
    }

    public void moveEntity(class_3218 world, UUID uuid, class_243 vec3d, float yaw, float pitch) {
        if (this.entityTrackers.containsKey(uuid)) {
            ReplayEntityTracker<?> entityTracker = this.entityTrackers.get(uuid);
            if (entityTracker.getDimension() != WorldTypes.fromDimension(world.method_8597())) {
                entityTracker.setDimension(WorldTypes.fromDimension(world.method_8597()));
            }
            entityTracker.setPos(vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), yaw, pitch);
        }
    }

    public ReplayPlayerTracker getPlayerTracker() {
        return this.replayPlayerTracker;
    }

    public Collection<ReplayEntityTracker<?>> getAllTrackers() {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.entityTrackers.values());
        list.add(this.getPlayerTracker().getEntityTracker());
        return list;
    }

    public void refreshPlayer() {
        Integer inventoryTick;
        if (!this.getPlayerTracker().getEntityTracker().isVisible()) {
            return;
        }
        ReplayPlayerEntity replayPlayer = this.getPlayerTracker().getEntityTracker().getTarget();
        replayPlayer.clearInventory();
        ArrayList inventoryTicks = Lists.newArrayList(this.tracker.playerInventoryCache.keySet());
        inventoryTicks.sort(Comparator.comparingInt(tick1 -> tick1));
        Iterator iterator = inventoryTicks.iterator();
        while (iterator.hasNext() && (inventoryTick = (Integer)iterator.next()) <= this.tracker.getCurrentTicks()) {
            for (Map.Entry<Byte, class_1799> entry : this.tracker.playerInventoryCache.get(inventoryTick).entrySet()) {
                replayPlayer.method_5673(class_1304.values()[entry.getKey()], entry.getValue());
            }
        }
    }

    private boolean shouldFollowPlayer(class_746 player) {
        return this.tracker.isFollowDimension() && !this.tracker.isGhostOnly() && !this.getPlayerTracker().getEntityTracker().isDead() && WorldTypes.fromDimension(player.field_6002.method_8597()) != this.getPlayerTracker().getEntityTracker().getDimension();
    }

    public void followPlayer(boolean force) {
        this.followTask = force ? 2 : 1;
    }

    public void followPlayer(class_310 client, ReplayProcessor processor, boolean forceFollow) {
        if (client.field_1724 != null && !forceFollow && !this.shouldFollowPlayer(client.field_1724)) {
            return;
        }
        if (processor.getFocusedTracker().map(tracker -> tracker.getEntityManager() != this).orElse(false).booleanValue()) {
            return;
        }
        if (!this.tracker.isActive() || processor.isLoading()) {
            return;
        }
        if (client.method_1576() != null && this.getPlayerTracker().getEntityTracker().isVisible()) {
            class_1132 server = client.method_1576();
            server.method_20493(() -> {
                for (class_3222 serverPlayerEntity : server.method_3760().method_14571()) {
                    int randomDistance = serverPlayerEntity.method_6051().nextInt(2) + 4;
                    float randomDirection = serverPlayerEntity.method_6051().nextFloat() * 360.0f;
                    class_243 newPos = this.getPlayerTracker().getEntityTracker().getPos().method_1031(0.0, 4.0, 0.0);
                    class_243 rotation = new class_243((double)randomDistance, 0.0, 0.0).method_1024(randomDirection);
                    newPos = newPos.method_1019(rotation);
                    class_243 subtractPos = this.getPlayerTracker().getEntityTracker().getPos().method_1020(newPos);
                    float angle = (float)(Math.atan2(-subtractPos.method_10216(), subtractPos.method_10215()) * 180.0 / Math.PI);
                    serverPlayerEntity.method_14251(this.getPlayerTracker().getEntityTracker().getDimension().toWorld((MinecraftServer)server), newPos.method_10216(), newPos.method_10214(), newPos.method_10215(), angle, (float)(40 - (randomDistance - 4) * 8));
                }
            });
            this.followTask = 0;
        }
        this.refreshPlayer();
    }

    public void tick(ReplayProcessor processor) {
        class_310 client = class_310.method_1551();
        if (!client.method_18854()) {
            throw new RuntimeException("wrong entity manager thread");
        }
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        for (ReplayEntityTracker<?> tracker : this.getAllTrackers()) {
            tracker.tick(client.field_1687);
        }
        if (!processor.isPaused() || this.followTask > 0) {
            this.followPlayer(client, processor, this.followTask > 1);
        }
    }

    public void clear() {
        this.entityTrackers.clear();
        this.getPlayerTracker().getEntityTracker().setVisible(false);
    }
}

