/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.file.ReplayManager;
import com.mcsrranked.client.anticheat.replay.file.ReplayRecordFile;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldPosIIdentifier;
import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.utils.TextureUtils;
import com.redlimerl.speedrunigt.timer.InGameTimer;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.SecretKey;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ReplayProcessor {
    private int curTrackerTick = 0;
    private int maxTrackerTick = 0;
    private final Map<UUID, OpponentPlayerTracker> trackerMap = new ConcurrentHashMap<UUID, OpponentPlayerTracker>();
    private final Map<Integer, List<MatchTimeline>> timelineMap = new ConcurrentHashMap<Integer, List<MatchTimeline>>();
    private final List<BasePlayer> players = new ArrayList<BasePlayer>();
    private boolean active = false;
    private boolean paused = false;
    private boolean ghostModeOnly = false;
    private boolean ghostMode = false;
    private boolean followDimension = true;
    private boolean displayNameTag = false;
    private int tickSpeed = 1;
    private final List<OpponentPlayerTracker> activeTrackers = new CopyOnWriteArrayList<OpponentPlayerTracker>();
    private OpponentPlayerTracker focusedTracker = null;
    private boolean live = false;
    private boolean moving = false;
    private boolean updating = false;
    private final boolean fromReplayFile;
    private final boolean enableCompress;
    private final Queue<UUID> lastCached = new ConcurrentLinkedQueue<UUID>();
    private final Map<WorldPosIIdentifier, OpponentPlayerTracker.UpdateState> updateBlockStateMap = new LinkedHashMap<WorldPosIIdentifier, OpponentPlayerTracker.UpdateState>();

    public ReplayProcessor(ReplayRecordFile recordFile) throws Exception {
        ZipFile zipFile = new ZipFile(recordFile.getFile());
        this.players.addAll(recordFile.getMeta().getPlayers());
        this.enableCompress = recordFile.getMeta().getVersion() >= 32;
        this.prepareReplayFile(recordFile, zipFile);
        for (BasePlayer player : this.getPlayers()) {
            TextureUtils.loadPlayerSkin(player.getUUID());
            this.activeTracker(player.getUUID(), null);
            ReplayManager.CURRENT_LOADING = (int)((double)this.players.size() * 1.0 / (double)recordFile.getMeta().getPlayers().size() * 5.0) + 95;
        }
        InputStream inputStream = zipFile.getInputStream(new ZipEntry("timelines.json"));
        JsonArray timelines = new JsonParser().parse((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8)).getAsJsonArray();
        inputStream.close();
        for (JsonElement jsonElement : timelines) {
            if (!(jsonElement instanceof JsonObject)) continue;
            MatchTimeline timeline = (MatchTimeline)MCSRRankedClient.GSON.fromJson(jsonElement, MatchTimeline.class);
            this.updateTimeline(timeline);
        }
        zipFile.close();
        ReplayManager.CURRENT_LOADING = 99;
        this.fromReplayFile = true;
    }

    private void prepareReplayFile(ReplayRecordFile recordFile, ZipFile zipFile) throws Exception {
        HashMap uuidToNickname = Maps.newHashMap();
        for (BasePlayer player : this.getPlayers()) {
            uuidToNickname.put(player.getUUID(), player.getNickname());
        }
        SecretKey symmetricKey = ReplayManager.generateSecretKey(Base64.getDecoder().decode(recordFile.getMeta().getSymmetricKey()));
        ZipEntry zipEntry = zipFile.getEntry("replay.rpd");
        InputStream zipIn = zipFile.getInputStream(zipEntry);
        long totalBytes = zipEntry.getSize();
        long readBytes = 0L;
        if (this.enableCompress) {
            DataInputStream dis = new DataInputStream(zipIn);
            try {
                while (true) {
                    int length = dis.readInt();
                    byte[] bytes = new byte[length];
                    dis.readFully(bytes);
                    this.loadReplayBytes(symmetricKey, bytes, uuidToNickname);
                    ReplayManager.CURRENT_LOADING = (int)((double)(readBytes += (long)(4 + bytes.length)) * 1.0 / (double)totalBytes * 95.0);
                }
            }
            catch (EOFException length) {}
        } else {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(zipIn, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                byte[] bytes = Base64.getDecoder().decode(line);
                this.loadReplayBytes(symmetricKey, bytes, uuidToNickname);
                ReplayManager.CURRENT_LOADING = (int)((double)(readBytes += (long)line.getBytes(StandardCharsets.UTF_8).length) * 1.0 / (double)totalBytes * 95.0);
            }
            reader.close();
        }
        for (UUID uuid : uuidToNickname.keySet()) {
            if (this.trackerMap.containsKey(uuid)) continue;
            OpponentPlayerTracker tracker = new OpponentPlayerTracker(uuid, (String)uuidToNickname.get(uuid));
            tracker.setCached(true);
            this.trackerMap.put(uuid, tracker);
        }
    }

    private void loadReplayBytes(SecretKey symmetricKey, byte[] bytes, Map<UUID, String> uuidToNickname) throws Exception {
        OpponentPlayerTracker tracker;
        ByteBuffer buffer = ReplayManager.decryptByteBuffer(symmetricKey, bytes, this.enableCompress);
        UUID uuid = new UUID(buffer.getLong(), buffer.getLong());
        if (this.trackerMap.containsKey(uuid)) {
            tracker = this.trackerMap.get(uuid);
        } else {
            tracker = new OpponentPlayerTracker(uuid, uuidToNickname.get(uuid));
            tracker.setCached(this.trackerMap.size() < 2);
            this.trackerMap.put(uuid, tracker);
        }
        tracker.receiveOpponentTimeLine(buffer);
    }

    public ReplayProcessor() {
        this.enableCompress = true;
        this.live = true;
        this.fromReplayFile = false;
    }

    public Map<UUID, OpponentPlayerTracker> getTrackerMap() {
        return this.trackerMap;
    }

    public int getMaxTrackerTick() {
        return this.maxTrackerTick;
    }

    public List<OpponentPlayerTracker> getActiveTrackers() {
        return this.activeTrackers;
    }

    public Optional<OpponentPlayerTracker> getFocusedTracker() {
        return Optional.ofNullable(this.focusedTracker);
    }

    public void setFocusedTracker(UUID uuid, MinecraftServer server) {
        this.updating = true;
        if (server != null && Thread.currentThread() != server.method_3777()) {
            server.execute(() -> this.setFocusedTracker(uuid, server));
            return;
        }
        if (!this.isGhostMode()) {
            this.activeTracker(uuid, server);
        } else {
            Optional.ofNullable(this.getTrackerMap().get(uuid)).ifPresent(tracker -> {
                this.focusedTracker = tracker;
            });
        }
        Optional.ofNullable(this.getTrackerMap().get(uuid)).ifPresent(tracker -> tracker.getEntityManager().followPlayer(false));
        this.updating = false;
    }

    public Optional<OpponentPlayerTracker> getTracker(UUID uuid) {
        if (uuid == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getTrackerMap().get(uuid));
    }

    public void addNewTracker(BasePlayer player) {
        OpponentPlayerTracker tracker = new OpponentPlayerTracker(player.getUUID(), player.getNickname());
        tracker.setCached(this.players.size() < 2);
        this.players.add(player);
        this.getTrackerMap().put(player.getUUID(), tracker);
        if (this.getActiveTrackers().isEmpty()) {
            this.activeTracker(player.getUUID(), null);
        }
    }

    public void removeTracker(BasePlayer player) {
        this.players.remove(player);
        this.getTrackerMap().remove(player.getUUID());
        this.inactiveTracker(player.getUUID(), null);
    }

    public void activeTracker(UUID uuid, MinecraftServer server) {
        OpponentPlayerTracker tracker;
        if (server != null && Thread.currentThread() != server.method_3777()) {
            server.execute(() -> this.activeTracker(uuid, server));
            return;
        }
        if (!this.isGhostMode() && this.getFocusedTracker().isPresent()) {
            this.inactiveTracker(this.getFocusedTracker().get().getUuid(), server);
        }
        if ((tracker = this.getTrackerMap().get(uuid)) == null) {
            return;
        }
        this.getActiveTrackers().add(tracker);
        this.focusedTracker = tracker;
        this.maxTrackerTick = tracker.getLastTicks();
        tracker.setActive(true);
        tracker.updateBlockStateMap.putAll(this.updateBlockStateMap);
        this.updateBlockStateMap.clear();
        if (!this.isGhostMode()) {
            tracker.setCached(true);
            if (server != null) {
                this.moveToTick(server, this.curTrackerTick);
            }
        }
        if (!this.lastCached.contains(uuid) && !this.isGhostMode()) {
            this.lastCached.add(uuid);
            if (this.lastCached.size() > 2) {
                UUID cacheUuid = this.lastCached.poll();
                this.getTracker(cacheUuid).ifPresent(t2 -> t2.setCached(false));
            }
        }
    }

    public void inactiveTracker(UUID uuid, MinecraftServer server) {
        if (server != null && Thread.currentThread() != server.method_3777()) {
            server.execute(() -> this.inactiveTracker(uuid, server));
            return;
        }
        for (OpponentPlayerTracker tracker : this.getActiveTrackers()) {
            if (!tracker.getUuid().equals(uuid)) continue;
            this.curTrackerTick = tracker.getCurrentTicks();
            tracker.setActive(false);
            tracker.updateBlockStateMap.clear();
            if (server != null) {
                tracker.rollbackAllActions(server);
                class_310.method_1551().execute(() -> tracker.getEntityManager().tick(this));
            }
            this.updateBlockStateMap.putAll(tracker.updateBlockStateMap);
            this.getActiveTrackers().remove(tracker);
            if (this.focusedTracker != tracker) break;
            this.focusedTracker = this.getActiveTrackers().isEmpty() ? null : this.getActiveTrackers().get(0);
            break;
        }
    }

    public void tickTracker(@NotNull MinecraftServer server) {
        if (Thread.currentThread() != server.method_3777()) {
            server.execute(() -> this.tickTracker(server));
            return;
        }
        if (this.curTrackerTick == 0) {
            for (class_3218 world : server.method_3738()) {
                if (world.method_27983() != class_1937.field_25181) continue;
                class_3218.method_29200((class_3218)world);
            }
        }
        if (!this.isPaused() && !this.moving) {
            this.getActiveTrackers().forEach(tracker -> tracker.tickTracker(server, this.isLive(), false));
            this.getFocusedTracker().ifPresent(tracker -> {
                this.curTrackerTick = tracker.getCurrentTicks();
                if (!this.isLive() && this.getTimelineMap().containsKey(this.getCurrentTicks())) {
                    for (MatchTimeline timeline : this.getTimelineMap().get(this.getCurrentTicks())) {
                        String nickname = this.getPlayers().stream().filter(player -> player.getUUID().equals(timeline.getUUID())).findFirst().map(BasePlayer::getNickname).orElse("Unknown");
                        server.method_3760().method_14616((class_2561)timeline.getText(nickname), class_2556.field_11735, timeline.getUUID());
                    }
                }
                for (class_3218 world : server.method_3738()) {
                    world.method_29199((long)(this.curTrackerTick - (this.isGhostMode() ? 0 : tracker.getLastResetTickFrom(this.curTrackerTick))));
                }
            });
        }
        this.getActiveTrackers().forEach(tracker -> {
            tracker.tickBlockStateUpdate(server);
            class_310.method_1551().execute(() -> tracker.getEntityManager().tick(this));
        });
        InGameTimer.getInstance().setRTAMode(true);
    }

    public void moveToTick(@NotNull MinecraftServer server, int tick) {
        this.moveToTick(server, tick, null);
    }

    public void moveToTick(@NotNull MinecraftServer server, int tick, Runnable after) {
        if (Thread.currentThread() != server.method_3777()) {
            server.execute(() -> this.moveToTick(server, tick, after));
            return;
        }
        if (this.moving) {
            return;
        }
        this.moving = true;
        for (OpponentPlayerTracker tracker : this.getActiveTrackers()) {
            try {
                tracker.moveToTick(tick, server);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.curTrackerTick = tracker.getCurrentTicks();
            for (class_3218 world : server.method_3738()) {
                world.method_29199((long)(this.curTrackerTick - tracker.getLastResetTickFrom(this.curTrackerTick)));
            }
        }
        if (after != null) {
            after.run();
        }
        this.moving = false;
    }

    public boolean isFromReplayFile() {
        return this.fromReplayFile;
    }

    public boolean isLive() {
        return this.live;
    }

    public int getTickSpeed() {
        return this.tickSpeed;
    }

    public void setTickSpeed(int tickSpeed) {
        this.tickSpeed = class_3532.method_15340((int)tickSpeed, (int)1, (int)5);
    }

    public boolean isLoading() {
        return this.moving || this.updating;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public boolean isPaused() {
        return this.paused || this.getActiveTrackers().isEmpty();
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isGhostMode() {
        return this.ghostMode;
    }

    public void enableGhostOnly() {
        this.setGhostMode(true, null);
        this.ghostModeOnly = true;
        for (OpponentPlayerTracker tracker : this.trackerMap.values()) {
            tracker.enableGhostOnly();
        }
    }

    public boolean isGhostModeOnly() {
        return this.ghostModeOnly;
    }

    public void setGhostMode(boolean ghostMode, MinecraftServer server) {
        if (server != null && Thread.currentThread() != server.method_3777()) {
            server.execute(() -> this.setGhostMode(ghostMode, server));
            return;
        }
        if (this.updating) {
            return;
        }
        this.ghostMode = ghostMode;
        this.updating = true;
        int ticks = this.getCurrentTicks();
        OpponentPlayerTracker focused = this.focusedTracker;
        for (OpponentPlayerTracker tracker : Lists.newArrayList(this.getActiveTrackers())) {
            this.inactiveTracker(tracker.getUuid(), server);
        }
        if (ghostMode) {
            for (OpponentPlayerTracker tracker : this.trackerMap.values()) {
                tracker.setGhostMode(true);
                this.activeTracker(tracker.getUuid(), server);
            }
            this.focusedTracker = focused;
        } else {
            for (OpponentPlayerTracker tracker : this.trackerMap.values()) {
                tracker.setGhostMode(false);
                if (focused != tracker) continue;
                this.activeTracker(tracker.getUuid(), server);
            }
        }
        if (server != null) {
            this.moveToTick(server, ticks);
        }
        this.updating = false;
    }

    public boolean shouldStopTick() {
        return this.isActive() && !this.ghostModeOnly;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setFollowDimension(boolean followDimension) {
        this.followDimension = followDimension;
        for (OpponentPlayerTracker activeTracker : this.getActiveTrackers()) {
            activeTracker.setFollowDimension(followDimension);
        }
    }

    public boolean isFollowDimension() {
        return this.followDimension;
    }

    public void setDisplayNameTag(boolean displayNameTag) {
        this.displayNameTag = displayNameTag;
        for (OpponentPlayerTracker tracker : this.getTrackerMap().values()) {
            tracker.setDisplayNameTag(this.displayNameTag);
        }
    }

    public boolean shouldDisplayNameTag() {
        return this.displayNameTag;
    }

    public Map<Integer, List<MatchTimeline>> getTimelineMap() {
        return this.timelineMap;
    }

    public Collection<MatchTimeline> getTimelines() {
        ArrayList<MatchTimeline> allTimelines = new ArrayList<MatchTimeline>();
        for (List<MatchTimeline> value : this.getTimelineMap().values()) {
            allTimelines.addAll(value);
        }
        allTimelines.sort(Comparator.comparingLong(MatchTimeline::getTime));
        return allTimelines;
    }

    public void updateTimeline(MatchTimeline timeline) {
        if (timeline.isReset() && !timeline.isAdvancementRoot()) {
            this.timelineMap.putIfAbsent(timeline.getTick(), new ArrayList());
            this.timelineMap.get(timeline.getTick()).add(timeline);
        }
        if (timeline.isReset()) {
            this.getTrackerMap().get(timeline.getUUID()).addResetWorldTimeline(timeline.getTick());
        }
        if (timeline.isComplete()) {
            this.timelineMap.putIfAbsent(timeline.getTick(), new ArrayList());
            this.timelineMap.get(timeline.getTick()).add(timeline);
        }
        this.getTrackerMap().get(timeline.getUUID()).onUpdateMatchTimeline(timeline);
    }

    public List<BasePlayer> getPlayers() {
        return this.players;
    }

    public int getCurrentTicks() {
        return this.curTrackerTick;
    }

    public void setCurrentTicks(int currentTicks) {
        this.curTrackerTick = class_3532.method_15340((int)currentTicks, (int)0, (int)this.getMaxTrackerTick());
    }

    public void reset() {
        class_1132 server = class_310.method_1551().field_1766;
        for (OpponentPlayerTracker tracker : this.trackerMap.values()) {
            if (server == null) {
                tracker.reset();
            }
            tracker.rollbackAllActions((MinecraftServer)server);
        }
        this.setCurrentTicks(0);
    }
}

