/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.file;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.AntiCheatConfig;
import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.file.ReplayMeta;
import com.mcsrranked.client.anticheat.replay.file.ReplayRecordFile;
import com.mcsrranked.client.anticheat.replay.file.migrate.ReplayMetaUnder30;
import com.mcsrranked.client.gui.screen.MessageScreen;
import com.mcsrranked.client.gui.screen.match.replay.ReplayLoadingScreen;
import com.mcsrranked.client.info.race.WeeklyRace;
import com.mcsrranked.client.info.race.WeeklyRaceRecord;
import com.mcsrranked.client.world.WorldCreatorBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.commons.io.FileUtils;
import org.xerial.snappy.Snappy;

public class ReplayManager {
    public static class_437 LAST_REPLAY_SCREEN = null;
    public static int CURRENT_LOADING = 0;
    public static Thread REPLAY_LOAD_THREAD = null;
    public static final Path REPLAY_FILE_PATH = MCSRRankedClient.GLOBAL_PATH.resolve("replay");
    public static final Path TEMP_REPLAY_FILE_PATH = MCSRRankedClient.GLOBAL_PATH.resolve("temp-replay");

    public static SecretKey generateSecretKey(byte[] keyArray) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, AntiCheatConfig.REPLAY_PUBLIC_KEY);
        return new SecretKeySpec(cipher.doFinal(keyArray), "AES");
    }

    public static ByteBuffer decryptByteBuffer(SecretKey secretKey, byte[] byteData, boolean decompress) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, secretKey);
        byte[] bytes = cipher.doFinal(byteData);
        return ByteBuffer.wrap(decompress ? Snappy.uncompress(bytes) : bytes);
    }

    public static void deleteOldestFile() {
        File[] files = TEMP_REPLAY_FILE_PATH.toFile().listFiles();
        if (files == null) {
            return;
        }
        List fileList = Arrays.stream(files).filter(file -> file.getName().endsWith(".rrf")).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
        int fileCount = fileList.size();
        while (fileCount-- >= 5) {
            try {
                FileUtils.forceDelete((File)((File)fileList.get(0)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                fileList.remove(0);
            }
        }
    }

    public static void getAllReplayFiles(Consumer<ReplayRecordFile> provider) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file2 : Objects.requireNonNull(REPLAY_FILE_PATH.toFile().listFiles())) {
            if (!file2.getName().endsWith(".rrf")) continue;
            fileList.add(file2);
        }
        fileList.sort(Comparator.comparingLong(file -> System.currentTimeMillis() - file.lastModified()));
        for (File file3 : fileList) {
            try {
                provider.accept(ReplayManager.convertReplayFile(file3));
            }
            catch (Exception e) {
                e.printStackTrace();
                MCSRRankedClient.LOGGER.error("Failed to load replay file: \"{}\" - {}", (Object)file3.getPath(), (Object)e.getMessage());
            }
        }
    }

    public static ReplayRecordFile convertReplayFile(File file) throws Exception {
        ZipFile zipFile = new ZipFile(file);
        InputStream inputStream = zipFile.getInputStream(new ZipEntry("meta.json"));
        JsonElement metaJson = new JsonParser().parse((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        ReplayMeta replayMeta = (ReplayMeta)MCSRRankedClient.GSON.fromJson(metaJson, ReplayMeta.class);
        if (replayMeta.getVersion() < 30) {
            replayMeta = ReplayMetaUnder30.migrate(metaJson.getAsJsonObject());
        }
        inputStream.close();
        zipFile.close();
        return new ReplayRecordFile(file, replayMeta);
    }

    public static void playReplayProcessor(class_437 parent, ReplayRecordFile recordFile) {
        LAST_REPLAY_SCREEN = parent;
        CURRENT_LOADING = 0;
        if (MCSRRankedClient.getOnlineMatch().map(match -> match.getStatus().isQueued()).orElse(false).booleanValue()) {
            class_310.method_1551().method_1507((class_437)new MessageScreen(parent, (class_2561)new class_2588("projectelo.text.replay_load_fail_match")));
            return;
        }
        ReplayLoadingScreen replayLoadingScreen = new ReplayLoadingScreen(parent);
        class_310.method_1551().method_1507((class_437)replayLoadingScreen);
        REPLAY_LOAD_THREAD = new Thread(() -> {
            ReplayProcessor processor = null;
            try {
                processor = recordFile.getProcessor();
            }
            catch (Exception e) {
                e.printStackTrace();
                replayLoadingScreen.onFail();
            }
            if (processor != null) {
                ReplayProcessor finalProcessor = processor;
                class_310.method_1551().execute(() -> {
                    if (REPLAY_LOAD_THREAD != null) {
                        MCSRRankedClient.CURRENT_REPLAY = finalProcessor;
                        finalProcessor.setActive(true);
                        new WorldCreatorBuilder(recordFile.getMeta().getOverworldSeed(), recordFile.getMeta().getNetherSeed()).setTheEndSeed(recordFile.getMeta().getTheEndSeed()).spectate().build().start();
                    }
                });
            }
        });
        REPLAY_LOAD_THREAD.start();
    }

    public static boolean isValidReplayName(String name) {
        if (name.trim().isEmpty()) {
            return false;
        }
        name = name.endsWith(".rrf") ? name : name + ".rrf";
        try {
            new File(name).getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        for (File file : Objects.requireNonNull(REPLAY_FILE_PATH.toFile().listFiles())) {
            if (!file.getName().equals(name + ".rrf") && !file.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public static File downloadReplayFile(int matchID, String name, boolean temp) {
        CURRENT_LOADING = 0;
        name = name.endsWith(".rrf") ? name : name + ".rrf";
        File result = (temp ? TEMP_REPLAY_FILE_PATH : REPLAY_FILE_PATH).resolve(name).toFile();
        if (!temp && !ReplayManager.isValidReplayName(name)) {
            return null;
        }
        File tempFile = TEMP_REPLAY_FILE_PATH.resolve(matchID + ".rrf").toFile();
        if (tempFile.exists()) {
            if (!temp) {
                tempFile.renameTo(result);
            }
            return result;
        }
        return ReplayManager.downloadReplayFile(result, String.valueOf(matchID));
    }

    public static File downloadReplayFile(WeeklyRace race, WeeklyRaceRecord record) {
        CURRENT_LOADING = 0;
        String name = String.format("%s-%s-%s.rrf", race.getID(), record.getTime(), record.getPlayer().getUUIDString());
        File result = TEMP_REPLAY_FILE_PATH.resolve("race").resolve(name).toFile();
        TEMP_REPLAY_FILE_PATH.resolve("race").toFile().mkdirs();
        result.deleteOnExit();
        if (result.exists()) {
            return result;
        }
        return ReplayManager.downloadReplayFile(result, String.format("/weekly-race/%s/%s?t=%s", race.getID(), record.getPlayer().getUUIDString(), record.getTime()));
    }

    private static File downloadReplayFile(File file, String target) {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            URL url = new URL(MCSRRankedClient.REPLAY_CDN_URL + target);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "MCSR-Ranked/" + MCSRRankedClient.MOD_CONTAINER.getMetadata().getVersion() + " (mcsrranked.com)");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(60000);
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                int bytesRead;
                is = conn.getInputStream();
                os = new FileOutputStream(file);
                int BUFFER_SIZE = 4096;
                byte[] buffer = new byte[4096];
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            } else {
                MCSRRankedClient.LOGGER.info("No replay to download. Server replied HTTP code: {}", (Object)responseCode);
                return null;
            }
            os.close();
            is.close();
            ReplayManager.deleteOldestFile();
            MCSRRankedClient.LOGGER.info("Replay downloaded");
            conn.disconnect();
            return file;
        }
        catch (Exception e) {
            MCSRRankedClient.LOGGER.error("An error occurred while trying to download a replay.");
            e.printStackTrace();
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return null;
        }
    }

    static {
        try {
            FileUtils.forceMkdir((File)REPLAY_FILE_PATH.toFile());
            FileUtils.forceMkdir((File)TEMP_REPLAY_FILE_PATH.toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

