/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking;

import com.mcsrranked.client.anticheat.replay.Replay;
import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerEntity;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerState;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.class_2561;

public class ReplayPlayerTracker {
    private final TreeMap<Integer, ReplayPlayerState> stateMap = new TreeMap();
    private final ReplayEntityTracker<ReplayPlayerEntity> entityTracker;
    private final OpponentPlayerTracker tracker;

    public ReplayPlayerTracker(OpponentPlayerTracker tracker, int entityId, UUID targetUUID, String nickname) {
        this.tracker = tracker;
        ReplayPlayerEntity replayPlayer = (ReplayPlayerEntity)Replay.REPLAY_PLAYER_ENTITY_TYPE.method_5883(null);
        assert (replayPlayer != null);
        replayPlayer.method_5665(class_2561.method_30163((String)nickname));
        replayPlayer.setTargetSkinUuid(targetUUID);
        replayPlayer.setGhostMode(tracker.isGhostMode());
        this.entityTracker = new ReplayEntityTracker<ReplayPlayerEntity>(tracker, entityId, replayPlayer, WorldTypes.OVERWORLD);
    }

    public ReplayPlayerState getStateTree(int tick) {
        Integer floorKey = this.stateMap.floorKey(tick);
        ReplayPlayerState target = floorKey != null ? this.stateMap.get(floorKey).duplicate() : new ReplayPlayerState();
        this.stateMap.put(tick, target);
        return target;
    }

    public void tick(int tick) {
        this.getEntityTracker().getTarget().method_5880(this.tracker.shouldDisplayNameTag());
        ReplayPlayerState state = this.stateMap.get(tick);
        if (state == null) {
            return;
        }
        state.apply(this.getEntityTracker());
    }

    public ReplayEntityTracker<ReplayPlayerEntity> getEntityTracker() {
        return this.entityTracker;
    }
}

