/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.block;

import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerEntity;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionITimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldPosIIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BlockProgressTimeLine
extends PositionITimeLine<WorldPosIIdentifier> {
    private final byte progress;

    protected BlockProgressTimeLine(WorldTypes world, long position, byte progress) {
        super(TimeLineType.BLOCK_PROGRESS, world, position);
        this.progress = progress;
    }

    @Override
    public WorldPosIIdentifier getIdentifier() {
        return new WorldPosIIdentifier(this.getWorld(), (class_2382)this.getBlockPos());
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        ReplayEntityTracker<ReplayPlayerEntity> playerTracker;
        if (!silence && (playerTracker = tracker.getReplayPlayerTracker().getEntityTracker()).isVisible()) {
            playerTracker.getTarget().method_6104(playerTracker.getTarget().method_6058());
            for (class_3222 serverPlayerEntity : this.getWorld().toWorld(server).method_18456()) {
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2620(serverPlayerEntity.method_5628(), this.getBlockPos(), this.getProgress()));
            }
        }
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.remaining() + 1).put(superBuffer).put(this.progress);
    }

    public static class BlockProgressTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private long position;
        private byte progress;

        public BlockProgressTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public BlockProgressTimeLineBuilder setPosition(class_2338 position) {
            this.position = position.method_10063();
            return this;
        }

        public BlockProgressTimeLineBuilder setProgress(byte progress) {
            this.progress = progress;
            return this;
        }

        public BlockProgressTimeLine build() {
            return new BlockProgressTimeLine(this.world, this.position, this.progress);
        }
    }

    public static class BlockProgressTimeLineFactory
    implements TimeLineFactorySingleton<WorldPosIIdentifier> {
        public static final BlockProgressTimeLineFactory INSTANCE = new BlockProgressTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.BLOCK_PROGRESS};
        }

        @Override
        public BlockProgressTimeLineBuilder getBuilder() {
            return new BlockProgressTimeLineBuilder();
        }

        public BlockProgressTimeLine getFromBytes(ByteBuffer buffer) {
            return new BlockProgressTimeLine(WorldTypes.values()[buffer.get()], buffer.getLong(), buffer.get());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldPosIIdentifier param) {
        }
    }
}

