/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.block;

import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionITimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldPosIIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.server.MinecraftServer;

public class BlockRemoveTimeLine
extends PositionITimeLine<WorldPosIIdentifier> {
    protected BlockRemoveTimeLine(WorldTypes world, long position) {
        super(TimeLineType.BLOCK_REMOVE, world, position);
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        tracker.updateBlockState(server, this.getIdentifier(), class_2246.field_10124.method_9564());
    }

    @Override
    public WorldPosIIdentifier getIdentifier() {
        return new WorldPosIIdentifier(this.getWorld(), (class_2382)this.getBlockPos());
    }

    @Override
    public ByteBuffer toBytes() {
        return super.toBytes();
    }

    public static class BlockRemoveTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private long position;

        public BlockRemoveTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public BlockRemoveTimeLineBuilder setPosition(class_2338 position) {
            this.position = position.method_10063();
            return this;
        }

        public BlockRemoveTimeLine build() {
            return new BlockRemoveTimeLine(this.world, this.position);
        }
    }

    public static class BlockRemoveTimeLineFactory
    implements TimeLineFactorySingleton<WorldPosIIdentifier> {
        public static final BlockRemoveTimeLineFactory INSTANCE = new BlockRemoveTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.BLOCK_UPDATE_V1, TimeLineType.BLOCK_UPDATE_V2, TimeLineType.BLOCK_BREAK, TimeLineType.BLOCK_REMOVE};
        }

        @Override
        public BlockRemoveTimeLineBuilder getBuilder() {
            return new BlockRemoveTimeLineBuilder();
        }

        public BlockRemoveTimeLine getFromBytes(ByteBuffer buffer) {
            return new BlockRemoveTimeLine(WorldTypes.values()[buffer.get()], buffer.getLong());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldPosIIdentifier param) {
            if (tracker.blockStateCache.containsKey(param)) {
                tracker.updateBlockState(server, param, tracker.blockStateCache.get(param), false);
            }
        }
    }
}

