/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.block;

import com.mcsrranked.client.anticheat.replay.render.ChestAnimationModifier;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionITimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldPosIIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class ChestAnimationTimeLine
extends PositionITimeLine<WorldPosIIdentifier> {
    private final boolean open;

    protected ChestAnimationTimeLine(WorldTypes world, long position, boolean open) {
        super(TimeLineType.CHEST_ANIMATION, world, position);
        this.open = open;
    }

    @Override
    public WorldPosIIdentifier getIdentifier() {
        return new WorldPosIIdentifier(this.getWorld(), (class_2382)this.getBlockPos());
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        class_2586 blockEntity;
        class_3218 world;
        if (!silence && (world = this.getWorld().toWorld(server)).method_22340(this.getBlockPos()) && (blockEntity = world.method_8321(this.getBlockPos())) instanceof class_2595) {
            ((ChestAnimationModifier)blockEntity).ranked$setOpen(this.open);
        }
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.remaining() + 1).put(superBuffer).put((byte)(this.open ? 1 : 0));
    }

    public static class ChestAnimationTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private long position;
        private boolean open;

        public ChestAnimationTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public ChestAnimationTimeLineBuilder setPosition(class_2338 position) {
            this.position = position.method_10063();
            return this;
        }

        public ChestAnimationTimeLineBuilder setOpen(boolean open) {
            this.open = open;
            return this;
        }

        public ChestAnimationTimeLine build() {
            return new ChestAnimationTimeLine(this.world, this.position, this.open);
        }
    }

    public static class ChestAnimationTimeLineFactory
    implements TimeLineFactorySingleton<WorldPosIIdentifier> {
        public static final ChestAnimationTimeLineFactory INSTANCE = new ChestAnimationTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.BLOCK_UPDATE_V1, TimeLineType.BLOCK_UPDATE_V2, TimeLineType.BLOCK_BREAK, TimeLineType.BLOCK_REMOVE};
        }

        @Override
        public ChestAnimationTimeLineBuilder getBuilder() {
            return new ChestAnimationTimeLineBuilder();
        }

        public ChestAnimationTimeLine getFromBytes(ByteBuffer buffer) {
            return new ChestAnimationTimeLine(WorldTypes.values()[buffer.get()], buffer.getLong(), buffer.get() != 0);
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldPosIIdentifier param) {
            class_2586 blockEntity;
            class_3218 world = param.getWorld().toWorld(server);
            if (world.method_22340(new class_2338(param.getPos())) && (blockEntity = world.method_8321(new class_2338(param.getPos()))) instanceof class_2595) {
                ((ChestAnimationModifier)blockEntity).ranked$setOpen(false);
            }
        }
    }
}

