/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.block;

import com.google.common.collect.Lists;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionFTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.EmptyIdentifier;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2664;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ExplosionEffectTimeline
extends PositionFTimeLine<EmptyIdentifier> {
    private static final EmptyIdentifier EMPTY = new EmptyIdentifier();
    private final float radius;

    protected ExplosionEffectTimeline(WorldTypes world, class_1160 position, float radius) {
        super(TimeLineType.EXPLOSION_EFFECT, world, position);
        this.radius = radius;
    }

    @Override
    public EmptyIdentifier getIdentifier() {
        return EMPTY;
    }

    public float getRadius() {
        return this.radius;
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        if (silence) {
            return;
        }
        for (class_3222 player : this.getWorld().toWorld(server).method_18456()) {
            player.field_13987.method_14364((class_2596)new class_2664((double)this.getX(), (double)this.getY(), (double)this.getZ(), this.getRadius(), (List)Lists.newArrayList(), class_243.field_1353));
        }
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.remaining() + 4).put(superBuffer).putFloat(this.radius);
    }

    public static class ExplosionEffectTimelineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private class_1160 position;
        private float radius;

        public ExplosionEffectTimelineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public ExplosionEffectTimelineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public ExplosionEffectTimelineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public ExplosionEffectTimelineBuilder setRadius(float radius) {
            this.radius = radius;
            return this;
        }

        public ExplosionEffectTimeline build() {
            return new ExplosionEffectTimeline(this.world, this.position, this.radius);
        }
    }

    public static class ExplosionEffectTimelineFactory
    implements TimeLineFactorySingleton<EmptyIdentifier> {
        public static final ExplosionEffectTimelineFactory INSTANCE = new ExplosionEffectTimelineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.EXPLOSION_EFFECT};
        }

        @Override
        public ExplosionEffectTimelineBuilder getBuilder() {
            return new ExplosionEffectTimelineBuilder();
        }

        public ExplosionEffectTimeline getFromBytes(ByteBuffer buffer) {
            return new ExplosionEffectTimeline(WorldTypes.values()[buffer.get()], new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()), buffer.getFloat());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, EmptyIdentifier param) {
        }
    }
}

