/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.entity;

import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionFTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.entity.EntityTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldUUIDIdentifier;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.class_1160;
import net.minecraft.server.MinecraftServer;

public class EntityMovePosTimeLine
extends PositionFTimeLine<WorldUUIDIdentifier> {
    private final int entityId;

    protected EntityMovePosTimeLine(WorldTypes world, class_1160 position, int entityId) {
        super(TimeLineType.ENTITY_MOVE_POS, world, position);
        this.entityId = entityId;
    }

    @Override
    public WorldUUIDIdentifier getIdentifier() {
        return new WorldUUIDIdentifier(this.getWorld(), this.getEntityUUID());
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        tracker.getEntityManager().moveEntity(this.getWorld().toWorld(server), this.getEntityUUID(), this.getPosition());
    }

    public UUID getEntityUUID() {
        return EntityTimeLine.getEntityUUIDById(this.entityId);
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.remaining() + 4).put(superBuffer).putInt(this.entityId);
    }

    public static class EntityMovePosTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private class_1160 position;
        private int entityId;

        public EntityMovePosTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public EntityMovePosTimeLineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public EntityMovePosTimeLineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public EntityMovePosTimeLineBuilder setEntityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        public EntityMovePosTimeLine build() {
            return new EntityMovePosTimeLine(this.world, this.position, this.entityId);
        }
    }

    public static class EntityMovePosTimeLineFactory
    implements TimeLineFactorySingleton<WorldUUIDIdentifier> {
        public static final EntityMovePosTimeLineFactory INSTANCE = new EntityMovePosTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.ENTITY_MOVE_POS};
        }

        @Override
        public EntityMovePosTimeLineBuilder getBuilder() {
            return new EntityMovePosTimeLineBuilder();
        }

        public EntityMovePosTimeLine getFromBytes(ByteBuffer buffer) {
            return new EntityMovePosTimeLine(WorldTypes.values()[buffer.get()], new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()), buffer.getInt());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldUUIDIdentifier param) {
            tracker.getEntityManager().moveEntity(param.getWorld().toWorld(server), param.getUUID());
        }
    }
}

