/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.item.projectile;

import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.item.projectile.ProjectileTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldUUIDIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_1160;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.server.MinecraftServer;

public class ItemEntityTimeLine
extends ProjectileTimeLine<WorldUUIDIdentifier> {
    private final class_1792 item;

    protected ItemEntityTimeLine(WorldTypes world, class_1160 pos, short yaw, short pitch, int entityId, class_243 velocity, class_1792 item) {
        super(TimeLineType.ITEM_ENTITY, world, pos, yaw, pitch, entityId, velocity);
        this.item = item;
    }

    protected ItemEntityTimeLine(WorldTypes world, class_1160 pos, float yaw, float pitch, int entityId, class_243 velocity, class_1792 item) {
        super(TimeLineType.ITEM_ENTITY, world, pos, yaw, pitch, entityId, velocity);
        this.item = item;
    }

    public class_1792 getItem() {
        return this.item;
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.remaining() + 4).put(superBuffer).putInt(class_1792.method_7880((class_1792)this.item));
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        class_1542 itemEntity = new class_1542((class_1937)this.getWorld().toWorld(server), (double)this.getX(), (double)this.getY(), (double)this.getZ(), new class_1799((class_1935)this.getItem()));
        itemEntity.method_18799(this.getVelocity());
        itemEntity.method_5826(this.getEntityUUID());
        itemEntity.method_6989();
        ReplayEntityTracker<?> entityTracker = tracker.getEntityManager().spawnEntity(this.getWorld().toWorld(server), itemEntity, this.getPosition(), this.getYaw(), this.getPitch());
        entityTracker.disableFollowPos();
    }

    @Override
    public WorldUUIDIdentifier getIdentifier() {
        return new WorldUUIDIdentifier(this.getWorld(), this.getEntityUUID());
    }

    public static class ItemEntityTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private class_1160 position;
        private float yaw;
        private float pitch;
        private class_243 velocity;
        private class_1792 item;
        private int entityId;

        public ItemEntityTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public ItemEntityTimeLineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public ItemEntityTimeLineBuilder setYaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public ItemEntityTimeLineBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public ItemEntityTimeLineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public ItemEntityTimeLineBuilder setVelocity(class_243 velocity) {
            this.velocity = velocity;
            return this;
        }

        public ItemEntityTimeLineBuilder setItem(class_1792 item) {
            this.item = item;
            return this;
        }

        public ItemEntityTimeLineBuilder setEntityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        public ItemEntityTimeLine build() {
            return new ItemEntityTimeLine(this.world, this.position, this.yaw, this.pitch, this.entityId, this.velocity, this.item);
        }
    }

    public static class ItemEntityTimeLineFactory
    implements TimeLineFactorySingleton<WorldUUIDIdentifier> {
        public static final ItemEntityTimeLineFactory INSTANCE = new ItemEntityTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.ITEM_ENTITY};
        }

        @Override
        public ItemEntityTimeLineBuilder getBuilder() {
            return new ItemEntityTimeLineBuilder();
        }

        public ItemEntityTimeLine getFromBytes(ByteBuffer buffer) {
            return new ItemEntityTimeLine(WorldTypes.values()[buffer.get()], new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()), buffer.getShort(), buffer.getShort(), buffer.getInt(), new class_243(buffer.getDouble(), buffer.getDouble(), buffer.getDouble()), class_1792.method_7875((int)buffer.getInt()));
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldUUIDIdentifier param) {
            ReplayEntityTracker<?> entityTracker = tracker.getEntityManager().getEntityTracker(param.getUUID());
            if (entityTracker != null) {
                entityTracker.setVisible(false);
            }
        }
    }
}

