/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.item.projectile;

import com.mcsrranked.client.anticheat.replay.ReplayEntityTracker;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.item.projectile.ProjectileTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.WorldUUIDIdentifier;
import com.mcsrranked.client.utils.ClientUtils;
import java.nio.ByteBuffer;
import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1668;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class ProjectileEntityTimeLine
extends ProjectileTimeLine<WorldUUIDIdentifier> {
    private final int entityTypeId;
    private final SoundPlayType soundPlayType;

    protected ProjectileEntityTimeLine(WorldTypes world, class_1160 pos, short yaw, short pitch, int entityId, class_243 velocity, int entityTypeId, SoundPlayType soundPlayType) {
        super(TimeLineType.PROJECTILE_ENTITY, world, pos, yaw, pitch, entityId, velocity);
        this.entityTypeId = entityTypeId;
        this.soundPlayType = soundPlayType;
    }

    protected ProjectileEntityTimeLine(WorldTypes world, class_1160 pos, float yaw, float pitch, int entityId, class_243 velocity, int entityTypeId, SoundPlayType soundPlayType) {
        super(TimeLineType.PROJECTILE_ENTITY, world, pos, yaw, pitch, entityId, velocity);
        this.entityTypeId = entityTypeId;
        this.soundPlayType = soundPlayType;
    }

    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    public SoundPlayType getSoundPlayType() {
        return this.soundPlayType;
    }

    @Override
    public ByteBuffer toBytes() {
        ByteBuffer superBuffer = (ByteBuffer)super.toBytes().rewind();
        return ByteBuffer.allocate(superBuffer.remaining() + 5).put(superBuffer).putInt(this.entityTypeId).put((byte)this.getSoundPlayType().ordinal());
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
        if (silence) {
            return;
        }
        class_1297 entity = ((class_1299)class_2378.field_11145.method_10200(this.getEntityTypeId())).method_5883((class_1937)this.getWorld().toWorld(server));
        if (entity != null) {
            entity.method_5826(this.getEntityUUID());
            if (entity instanceof class_1668) {
                ((class_1668)entity).field_7601 = this.getVelocity().field_1352;
                ((class_1668)entity).field_7600 = this.getVelocity().field_1351;
                ((class_1668)entity).field_7599 = this.getVelocity().field_1350;
            } else {
                entity.method_18799(this.getVelocity());
            }
            class_3218 world = this.getWorld().toWorld(server);
            ReplayEntityTracker<?> entityTracker = tracker.getEntityManager().spawnEntity(world, entity, this.getPosition(), this.getYaw(), this.getPitch());
            entityTracker.disableFollowPos();
            entityTracker.disableRespawn();
            entityTracker.setVisible(true);
            this.getSoundPlayType().soundPlayer.play(world, this.getPosition(), new Random());
        }
    }

    @Override
    public WorldUUIDIdentifier getIdentifier() {
        return new WorldUUIDIdentifier(this.getWorld(), this.getEntityUUID());
    }

    public static enum SoundPlayType {
        EMPTY((world, pos, random) -> {}),
        GHAST_FIREBALL((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_15231, class_3419.field_15251, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f)),
        BLAZE_FIREBALL((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14970, class_3419.field_15251, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f)),
        ENTITY_TRIDENT((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14753, class_3419.field_15251, 1.0f, 1.0f / (random.nextFloat() * 0.4f + 0.8f))),
        SHULKER_BULLET((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_15000, class_3419.field_15251, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f)),
        DRAGON_FIREBALL((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14934, class_3419.field_15251, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f)),
        WITHER_SKULL((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14588, class_3419.field_15251, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f)),
        ENTITY_SHOT_CROSSBOW((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_15187, class_3419.field_15251, 1.0f, 1.0f)),
        SHOOT_SNOWBALL((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14745, class_3419.field_15254, 1.0f, 0.4f / (random.nextFloat() * 0.4f + 0.8f))),
        FIREWORK_FIRE((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14712, class_3419.field_15254, 1.0f, 1.2f)),
        PLAYER_PEARL_THROW((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14757, class_3419.field_15248, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f))),
        ENTITY_POTION_THROW((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14910, class_3419.field_15254, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f))),
        SHOOT_ARROW((world, pos, random) -> world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), class_3417.field_14600, class_3419.field_15251, 1.0f, 1.0f / (random.nextFloat() * 0.4f + 0.8f)));

        private final SoundPlayer soundPlayer;

        private SoundPlayType(SoundPlayer soundPlayer) {
            this.soundPlayer = soundPlayer;
        }
    }

    private static interface SoundPlayer {
        public void play(class_3218 var1, class_243 var2, Random var3);
    }

    public static class ProjectileEntityTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world;
        private class_1160 position;
        private float yaw;
        private float pitch;
        private class_243 velocity;
        private int entityTypeId;
        private int entityId;
        private SoundPlayType soundPlayType;

        public ProjectileEntityTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public ProjectileEntityTimeLineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public ProjectileEntityTimeLineBuilder setYaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public ProjectileEntityTimeLineBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public ProjectileEntityTimeLineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public ProjectileEntityTimeLineBuilder setVelocity(class_243 velocity) {
            this.velocity = velocity;
            return this;
        }

        public ProjectileEntityTimeLineBuilder setVelocity(double x, double y, double z) {
            this.velocity = new class_243(x, y, z);
            return this;
        }

        public ProjectileEntityTimeLineBuilder setEntityTypeId(int entityTypeId) {
            this.entityTypeId = entityTypeId;
            return this;
        }

        public ProjectileEntityTimeLineBuilder setEntityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        public ProjectileEntityTimeLineBuilder setSoundType(SoundPlayType soundPlayType) {
            this.soundPlayType = soundPlayType;
            return this;
        }

        public ProjectileEntityTimeLine build() {
            return new ProjectileEntityTimeLine(this.world, this.position, this.yaw, this.pitch, this.entityId, this.velocity, this.entityTypeId, this.soundPlayType);
        }
    }

    public static class ProjectileEntityTimeLineFactory
    implements TimeLineFactorySingleton<WorldUUIDIdentifier> {
        public static final ProjectileEntityTimeLineFactory INSTANCE = new ProjectileEntityTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.PROJECTILE_ENTITY};
        }

        @Override
        public ProjectileEntityTimeLineBuilder getBuilder() {
            return new ProjectileEntityTimeLineBuilder();
        }

        public ProjectileEntityTimeLineBuilder getFromEntity(class_1297 entity, SoundPlayType soundPlayType) {
            return INSTANCE.getBuilder().setWorld(WorldTypes.fromDimension(entity.field_6002.method_8597())).setPosition(ClientUtils.vec3dToVector3f(entity.method_19538())).setYaw(entity.field_6031).setPitch(entity.field_5965).setVelocity(entity.method_18798()).setEntityId(entity.method_5628()).setEntityTypeId(class_2378.field_11145.method_10249((Object)entity.method_5864())).setSoundType(soundPlayType);
        }

        public ProjectileEntityTimeLine getFromBytes(ByteBuffer buffer) {
            return new ProjectileEntityTimeLine(WorldTypes.values()[buffer.get()], new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()), buffer.getShort(), buffer.getShort(), buffer.getInt(), new class_243(buffer.getDouble(), buffer.getDouble(), buffer.getDouble()), buffer.getInt(), SoundPlayType.values()[buffer.get()]);
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, WorldUUIDIdentifier param) {
            ReplayEntityTracker<?> entityTracker = tracker.getEntityManager().getEntityTracker(param.getUUID());
            if (entityTracker != null) {
                entityTracker.setVisible(false);
            }
        }
    }
}

