/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.player;

import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerState;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.RotationTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.EmptyIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.server.MinecraftServer;

public class PlayerPositionLookTimeLine
extends RotationTimeLine<EmptyIdentifier> {
    private static final EmptyIdentifier EMPTY = new EmptyIdentifier();

    public PlayerPositionLookTimeLine(WorldTypes world, short yaw, short pitch) {
        super(TimeLineType.PLAYER_POSITION_LOOK, world, yaw, pitch);
    }

    protected PlayerPositionLookTimeLine(WorldTypes world, float yaw, float pitch) {
        super(TimeLineType.PLAYER_POSITION_LOOK, world, yaw, pitch);
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
    }

    @Override
    public EmptyIdentifier getIdentifier() {
        return EMPTY;
    }

    @Override
    public boolean isPlayerMovementTimeline() {
        return true;
    }

    @Override
    public void onPlayerStateUpdate(ReplayPlayerState state) {
        state.setWorldType(this.getWorld());
        state.setPitch(this.getPitch());
        state.setYaw(this.getYaw());
    }

    @Override
    public ByteBuffer toBytes() {
        return super.toBytes();
    }

    public static class PlayerPositionLookTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world = WorldTypes.OVERWORLD;
        private float yaw = 0.0f;
        private float pitch = 0.0f;

        public PlayerPositionLookTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public PlayerPositionLookTimeLineBuilder setYaw(float yaw) {
            this.yaw = yaw;
            return this;
        }

        public PlayerPositionLookTimeLineBuilder setPitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public PlayerPositionLookTimeLine build() {
            return new PlayerPositionLookTimeLine(this.world, this.yaw, this.pitch);
        }
    }

    public static class PlayerPositionLookTimeLineFactory
    implements TimeLineFactorySingleton<EmptyIdentifier> {
        public static final PlayerPositionLookTimeLineFactory INSTANCE = new PlayerPositionLookTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.PLAYER_POSITION_LOOK};
        }

        @Override
        public PlayerPositionLookTimeLineBuilder getBuilder() {
            return new PlayerPositionLookTimeLineBuilder();
        }

        public PlayerPositionLookTimeLine getFromBytes(ByteBuffer buffer) {
            return new PlayerPositionLookTimeLine(WorldTypes.values()[buffer.get()], buffer.getShort(), buffer.getShort());
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, EmptyIdentifier param) {
        }
    }
}

