/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.anticheat.replay.tracking.timelines.types.player;

import com.mcsrranked.client.anticheat.replay.render.ReplayPlayerState;
import com.mcsrranked.client.anticheat.replay.tracking.OpponentPlayerTracker;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineBuilder;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineFactorySingleton;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.TimeLineType;
import com.mcsrranked.client.anticheat.replay.tracking.timelines.types.PositionFTimeLine;
import com.mcsrranked.client.anticheat.replay.tracking.util.WorldTypes;
import com.mcsrranked.client.anticheat.replay.tracking.util.identifier.EmptyIdentifier;
import java.nio.ByteBuffer;
import net.minecraft.class_1160;
import net.minecraft.server.MinecraftServer;

public class PlayerPositionPosTimeLine
extends PositionFTimeLine<EmptyIdentifier> {
    private static final EmptyIdentifier EMPTY = new EmptyIdentifier();

    protected PlayerPositionPosTimeLine(WorldTypes world, class_1160 position) {
        super(TimeLineType.PLAYER_POSITION_POS, world, position);
    }

    @Override
    public void runTimeLine(OpponentPlayerTracker tracker, MinecraftServer server, boolean silence) {
    }

    @Override
    public EmptyIdentifier getIdentifier() {
        return EMPTY;
    }

    @Override
    public boolean isPlayerMovementTimeline() {
        return true;
    }

    @Override
    public void onPlayerStateUpdate(ReplayPlayerState state) {
        state.setWorldType(this.getWorld());
        state.setPos(this.getPosition());
    }

    @Override
    public ByteBuffer toBytes() {
        return super.toBytes();
    }

    public static class PlayerPositionPosTimeLineBuilder
    implements TimeLineBuilder {
        private WorldTypes world = WorldTypes.OVERWORLD;
        private class_1160 position = new class_1160(0.0f, 0.0f, 0.0f);

        public PlayerPositionPosTimeLineBuilder setWorld(WorldTypes world) {
            this.world = world;
            return this;
        }

        public PlayerPositionPosTimeLineBuilder setPosition(class_1160 position) {
            this.position = position;
            return this;
        }

        public PlayerPositionPosTimeLineBuilder setPosition(float x, float y, float z) {
            this.position = new class_1160(x, y, z);
            return this;
        }

        public PlayerPositionPosTimeLine build() {
            return new PlayerPositionPosTimeLine(this.world, this.position);
        }
    }

    public static class PlayerPositionPosTimeLineFactory
    implements TimeLineFactorySingleton<EmptyIdentifier> {
        public static final PlayerPositionPosTimeLineFactory INSTANCE = new PlayerPositionPosTimeLineFactory();

        @Override
        public TimeLineType[] getInvertedTypes() {
            return new TimeLineType[]{TimeLineType.PLAYER_POSITION_POS};
        }

        @Override
        public PlayerPositionPosTimeLineBuilder getBuilder() {
            return new PlayerPositionPosTimeLineBuilder();
        }

        public PlayerPositionPosTimeLine getFromBytes(ByteBuffer buffer) {
            return new PlayerPositionPosTimeLine(WorldTypes.values()[buffer.get()], new class_1160(buffer.getFloat(), buffer.getFloat(), buffer.getFloat()));
        }

        @Override
        public void defaultExecute(OpponentPlayerTracker tracker, MinecraftServer server, EmptyIdentifier param) {
        }
    }
}

