/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.auth;

import com.google.gson.JsonParser;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.auth.PlayerKeyPair;
import com.mcsrranked.client.utils.UUIDUtils;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_155;
import net.minecraft.class_310;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientAuth {
    static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    static final String DIGEST_ALGORITHM = "SHA-256";
    static final String CERTIFICATE_URL = "https://api.minecraftservices.com/player/certificates";
    static final Logger LOGGER = LogManager.getLogger();
    String accessToken = class_310.method_1551().method_1548().method_1674();
    public UUID uuid = class_310.method_1551().method_1548().method_1677().getId();
    Proxy proxy = ((YggdrasilMinecraftSessionService)class_310.method_1551().method_1495()).getAuthenticationService().getProxy();
    PlayerKeyPair pair = PlayerKeyPair.fetchKeyPair(this.readInputStream(this.postInternal(ClientAuth.constantURL(), new byte[0])));
    public static CompletableFuture<ClientAuth> clientAuthCompletableFuture;
    private static ClientAuth instance;

    public static ClientAuth getInstance() {
        if (instance == null) {
            if (clientAuthCompletableFuture != null) {
                try {
                    instance = clientAuthCompletableFuture.get();
                    return instance;
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
            instance = ClientAuth.createClientAuth();
        }
        return instance;
    }

    ClientAuth() throws IOException {
    }

    public static ClientAuth createClientAuth() {
        try {
            return new ClientAuth();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failed to create Authentication: ");
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, String> createMessageJson(String ... payload) {
        try {
            long randomLong = new SecureRandom().nextLong();
            byte[] data = this.sign(this.uuid, randomLong, payload);
            LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
            output.put("elo-auth-uuid", this.uuid.getMostSignificantBits() + "/" + this.uuid.getLeastSignificantBits());
            output.put("elo-auth-randomlong", String.valueOf(randomLong));
            output.put("elo-auth-publickey", Base64.getEncoder().encodeToString(this.pair.playerPublicKey.publicKey.getEncoded()));
            output.put("elo-auth-instant", String.valueOf(this.pair.playerPublicKey.expirationDate.toEpochMilli()));
            output.put("elo-auth-signaturebytes", Base64.getEncoder().encodeToString(this.pair.playerPublicKey.signatureBytes));
            output.put("elo-auth-data", Base64.getEncoder().encodeToString(data));
            output.put("elo-nickname", class_310.method_1551().method_1548().method_1676());
            output.put("elo-mcversion", String.valueOf(class_155.method_16673().getWorldVersion()));
            output.put("elo-version", MCSRRankedClient.MOD_CONTAINER.getMetadata().getVersion().getFriendlyString());
            output.put("elo-player-identifier", UUIDUtils.toString(Objects.requireNonNull(UUIDUtils.getHardwareUUID())));
            return output;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failed to sign authentication message JSON: ");
            e.printStackTrace();
            return null;
        }
    }

    static URL constantURL() {
        try {
            return new URL(CERTIFICATE_URL);
        }
        catch (MalformedURLException ex) {
            throw new Error("Couldn't create constant for https://api.minecraftservices.com/player/certificates", ex);
        }
    }

    byte[] sign(UUID sender, long randomLong, String ... payload) throws GeneralSecurityException {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(this.pair.privateKey);
        signature.update((sender.getMostSignificantBits() + "/" + sender.getLeastSignificantBits()).getBytes(StandardCharsets.UTF_8));
        signature.update(Base64.getEncoder().encode(ClientAuth.digest(randomLong)));
        signature.update("70".getBytes(StandardCharsets.UTF_8));
        for (String data : payload) {
            signature.update(data.getBytes(StandardCharsets.UTF_8));
        }
        return signature.sign();
    }

    static byte[] digest(long randomLong) {
        try {
            MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            digest.update(String.valueOf(randomLong).getBytes(StandardCharsets.UTF_8));
            digest.update("70".getBytes(StandardCharsets.UTF_8));
            return digest.digest();
        }
        catch (NoSuchAlgorithmException ignored) {
            return null;
        }
    }

    PlayerKeyPair.KeyPairResponse readInputStream(HttpURLConnection connection) throws IOException {
        int status;
        block3: {
            PlayerKeyPair.KeyPairResponse keyPairResponse;
            InputStream inputStream = null;
            try {
                status = connection.getResponseCode();
                if (status >= 400) break block3;
                inputStream = connection.getInputStream();
                String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                keyPairResponse = PlayerKeyPair.KeyPairResponse.fromJson(new JsonParser().parse(result).getAsJsonObject());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return keyPairResponse;
        }
        throw new IOException(String.valueOf(status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpURLConnection postInternal(URL url, byte[] postAsBytes) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.proxy);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.setUseCaches(false);
        OutputStream outputStream = null;
        try {
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.setRequestProperty("Content-Length", String.valueOf(postAsBytes.length));
            connection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            outputStream = connection.getOutputStream();
            IOUtils.write((byte[])postAsBytes, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return connection;
    }
}

