/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.LiveMatchHud;
import com.mcsrranked.client.info.match.MatchSplit;
import com.mcsrranked.client.info.match.online.MatchFlag;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.match.online.gamemode.MostPercentGameMode;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.info.player.PlayerStatus;
import com.mcsrranked.client.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class LiveMatchPlayerListHud
extends class_332 {
    private static final class_2561 HEADER_TEXT = new class_2585("\n      MCSR Ranked v" + MCSRRankedClient.MOD_CONTAINER.getMetadata().getVersion().getFriendlyString() + "      \n").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
    private static final Function<OnlineMatch, class_2561> FOOTER_TEXT = onlineMatch -> new class_2585("\n").method_10852((class_2561)new class_2588("projectelo.text.match.current_match").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})).method_27693("\n").method_10852(onlineMatch.getDisplayName()).method_27693("\n");

    public static List<OnlinePlayer> getSortedPlayers(OnlineMatch onlineMatch, boolean excludeSpectator) {
        Ordering ordering;
        if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
            boolean skipSplitSort = !((MostPercentGameMode)onlineMatch.getOption().getGameMode()).isEnableDisplayScore();
            ordering = Ordering.from((p1, p2) -> ComparisonChain.start().compareFalseFirst(p1.isSpectator(), p2.isSpectator()).compareFalseFirst(p1.getStatus().isSpectate(), p2.getStatus().isSpectate()).compare((Object)(skipSplitSort ? 0 : onlineMatch.getPlayLog((OnlinePlayer)p1).getScore()), (Object)(skipSplitSort ? 0 : onlineMatch.getPlayLog((OnlinePlayer)p2).getScore()), (Comparator)Ordering.natural().reverse()).compare((Object)(p1.getEloRate() == null ? -1 : p1.getEloRate()), (Object)(p2.getEloRate() == null ? -1 : p2.getEloRate()), (Comparator)Ordering.natural().reverse()).result());
        } else {
            boolean skipSplitSort = !onlineMatch.getOption().getFlag().isEnableFlag(MatchFlag.Type.SHOW_ADVANCEMENT) || (Boolean)SpeedRunOption.getOption(RankedOptions.HIDE_OPPONENT_ADVANCEMENT) != false;
            ordering = Ordering.from((p1, p2) -> ComparisonChain.start().compareFalseFirst(p1.isSpectator(), p2.isSpectator()).compareFalseFirst(p1.getStatus().isSpectate(), p2.getStatus().isSpectate()).compareTrueFirst(p1.getStatus() == PlayerStatus.COMPLETED, p2.getStatus() == PlayerStatus.COMPLETED).compare((Comparable)(skipSplitSort ? Integer.valueOf(0) : onlineMatch.getPlayLog((OnlinePlayer)p1).getLastSplitData()), (Comparable)(skipSplitSort ? Integer.valueOf(0) : onlineMatch.getPlayLog((OnlinePlayer)p2).getLastSplitData())).compare((Object)(p1.getEloRate() == null ? -1 : p1.getEloRate()), (Object)(p2.getEloRate() == null ? -1 : p2.getEloRate()), (Comparator)Ordering.natural().reverse()).result());
        }
        return ordering.sortedCopy(excludeSpectator ? onlineMatch.getPlayersExcludeSpectator() : onlineMatch.getPlayers());
    }

    public void render(class_4587 matrixStack, int scaledWidth, OnlineMatch onlineMatch) {
        int w;
        int t;
        int listSize;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        List<OnlinePlayer> playerList = LiveMatchPlayerListHud.getSortedPlayers(onlineMatch, false);
        HashMap playerScore = Maps.newHashMap();
        int nicknameWidth = 0;
        int scoreWidth = 0;
        for (OnlinePlayer player : playerList) {
            int width = BasePlayer.getNicknameWidth(player);
            nicknameWidth = Math.max(nicknameWidth, width);
            if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
                if (!((MostPercentGameMode)onlineMatch.getOption().getGameMode()).isEnableDisplayScore()) continue;
                long score = onlineMatch.getPlayLog(player).getScore();
                playerScore.put(player, new class_2585(" " + score).method_27692(class_124.field_1054));
                width = client.field_1772.method_27525((class_5348)playerScore.get(player));
                scoreWidth = Math.max(scoreWidth, width);
                continue;
            }
            long completion = onlineMatch.getPlayLog(player).getCompletion();
            if (completion != 0L) {
                playerScore.put(player, new class_2585(" " + InGameTimerUtils.timeToStringFormat((long)completion)).method_27692(class_124.field_1075));
                width = client.field_1772.method_27525((class_5348)playerScore.get(player));
                scoreWidth = Math.max(scoreWidth, width);
                continue;
            }
            if (player.getEloRate() == null || player.isSpectator()) continue;
            playerScore.put(player, new class_2585(" " + player.getEloRate()).method_27692(class_124.field_1054));
            width = client.field_1772.method_27525((class_5348)playerScore.get(player));
            scoreWidth = Math.max(scoreWidth, width);
        }
        playerList = playerList.subList(0, Math.min(playerList.size(), 80));
        int sizeCount = listSize = playerList.size();
        int indexCount = 1;
        while (sizeCount > 20) {
            sizeCount = (listSize + ++indexCount - 1) / indexCount;
        }
        int p = Math.min(indexCount * (nicknameWidth + scoreWidth + 31), scaledWidth - 50) / indexCount;
        int q = scaledWidth / 2 - (p * indexCount + (indexCount - 1) * 5) / 2;
        int r = 10;
        int s = p * indexCount + (indexCount - 1) * 5;
        List headerTexts = client.field_1772.method_1728((class_5348)HEADER_TEXT, scaledWidth - 50);
        for (Object headerText : headerTexts) {
            s = Math.max(s, client.field_1772.method_27525((class_5348)headerText));
        }
        List footerTexts = client.field_1772.method_1728((class_5348)FOOTER_TEXT.apply(onlineMatch), scaledWidth - 50);
        for (class_5348 footerText : footerTexts) {
            s = Math.max(s, client.field_1772.method_27525(footerText));
        }
        LiveMatchPlayerListHud.method_25294((class_4587)matrixStack, (int)(scaledWidth / 2 - s / 2 - 1), (int)(r - 1), (int)(scaledWidth / 2 + s / 2 + 1), (int)(r + headerTexts.size() * 9), (int)Integer.MIN_VALUE);
        for (class_5348 headerText : headerTexts) {
            t = client.field_1772.method_27525(headerText);
            client.field_1772.method_27517(matrixStack, headerText, (float)(scaledWidth / 2 - t / 2), (float)r, -1);
            r += 9;
        }
        LiveMatchPlayerListHud.method_25294((class_4587)matrixStack, (int)(scaledWidth / 2 - s / 2 - 1), (int)(++r - 1), (int)(scaledWidth / 2 + s / 2 + 1), (int)(r + sizeCount * 9), (int)Integer.MIN_VALUE);
        int backgroundColor = client.field_1690.method_19344(0x20FFFFFF);
        for (int v = 0; v < listSize; ++v) {
            class_2561 scoreText;
            int ad;
            int ae;
            t = v / sizeCount;
            w = v % sizeCount;
            int x = q + t * p + t * 5;
            int y = r + w * 9;
            LiveMatchPlayerListHud.method_25294((class_4587)matrixStack, (int)x, (int)y, (int)(x + p), (int)(y + 8), (int)backgroundColor);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (v >= playerList.size()) continue;
            OnlinePlayer player = playerList.get(v);
            MatchSplit split = onlineMatch.getPlayLog(player).getLastSplit();
            if (!player.isSpectator() && !((Boolean)SpeedRunOption.getOption(RankedOptions.HIDE_OPPONENT_ADVANCEMENT)).booleanValue() && onlineMatch.getOption().getFlag().isEnableFlag(MatchFlag.Type.SHOW_ADVANCEMENT) && split.getU() > -1) {
                client.method_1531().method_22813(LiveMatchHud.STRUCTURE_ICONS);
                class_332.method_25293((class_4587)matrixStack, (int)x, (int)y, (int)8, (int)8, (float)split.getU(), (float)split.getV(), (int)16, (int)16, (int)64, (int)64);
            }
            RenderUtils.renderPlayerHead(player.getDisplayUUID(), matrixStack, x += 9, y, 8, 8);
            BasePlayer.renderNickname(matrixStack, x += 9, y, player, player.isSpectator() || player.getStatus().isSpectate() ? -1862270977 : -1);
            if (!player.isSpectator() && (ae = (ad = x + nicknameWidth + 1) + scoreWidth) - ad > 5 && (scoreText = (class_2561)playerScore.get(player)) != null) {
                client.field_1772.method_27517(matrixStack, (class_5348)scoreText, (float)(ae - client.field_1772.method_27525((class_5348)scoreText)), (float)y, 0xFFFFFF);
            }
            this.renderLatencyIcon(matrixStack, p, x - 18, y, player);
        }
        LiveMatchPlayerListHud.method_25294((class_4587)matrixStack, (int)(scaledWidth / 2 - s / 2 - 1), (int)((r += sizeCount * 9 + 1) - 1), (int)(scaledWidth / 2 + s / 2 + 1), (int)(r + footerTexts.size() * 9), (int)Integer.MIN_VALUE);
        for (class_5348 footerText : footerTexts) {
            w = client.field_1772.method_27525(footerText);
            client.field_1772.method_27517(matrixStack, footerText, (float)(scaledWidth / 2 - w / 2), (float)r, -1);
            r += 9;
        }
    }

    private void renderLatencyIcon(class_4587 matrixStack, int i, int j, int k, OnlinePlayer player) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_310.method_1551().method_1531().method_22813(field_22737);
        int m = player.getStatus().isOnline() ? 0 : 5;
        this.method_25304(this.method_25305() + 100);
        this.method_25302(matrixStack, j + i - 11, k, 0, 176 + m * 8, 10, 8);
        this.method_25304(this.method_25305() - 100);
    }
}

