/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.info;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.file.ReplayManager;
import com.mcsrranked.client.anticheat.replay.file.ReplayRecordFile;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.info.UserProfileScreen;
import com.mcsrranked.client.gui.screen.info.UserReplayDownloadScreen;
import com.mcsrranked.client.gui.screen.match.MatchTimelineScreen;
import com.mcsrranked.client.gui.screen.match.NoticeMessageScreen;
import com.mcsrranked.client.gui.screen.match.replay.ReplayLoadingScreen;
import com.mcsrranked.client.gui.widget.FreeSizeButtonWidget;
import com.mcsrranked.client.gui.widget.MatchPlayerListSelectWidget;
import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.info.match.OverworldSeedType;
import com.mcsrranked.client.info.match.server.DetailedMatchData;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import com.redlimerl.speedrunigt.timer.category.RunCategories;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class UserMatchInfoScreen
extends RankedScreen {
    private boolean initialized = false;
    private DetailedMatchData matchData = null;
    private final List<MatchTimeline> matchTimelines = Lists.newCopyOnWriteArrayList();
    private class_4185 p1ProfileButton;
    private class_4185 p2ProfileButton;
    private class_4185 p1SwitchButton;
    private class_4185 p2SwitchButton;
    private MatchPlayerListSelectWidget<BasePlayer> playerListWidget;
    private Pair<BasePlayer, BasePlayer> playerPair = new Pair(null, null);
    private final long openTime = System.currentTimeMillis();
    private Boolean dragonDeathToggle = null;
    private class_238 dragonDeathTextBox = class_238.method_30048((double)0.0, (double)0.0, (double)0.0);
    private boolean leftIndex = true;

    public UserMatchInfoScreen(class_437 parent, int matchID) {
        super(parent, (class_2561)new class_2588("projectelo.title.match_info"));
        MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
            JsonElement jsonData = ClientUtils.getApiResponse("matches/" + matchID);
            if (jsonData == null) {
                return;
            }
            this.matchData = (DetailedMatchData)MCSRRankedClient.GSON.fromJson(jsonData, DetailedMatchData.class);
            if (this.matchData.getTimelines() != null) {
                this.matchTimelines.addAll(this.matchData.getTimelines());
                this.matchTimelines.sort(Comparator.comparingLong(MatchTimeline::getTime));
            }
        });
    }

    private void onSelectedPlayer(BasePlayer player) {
        this.playerListWidget.setVisible(false);
        this.playerPair = new Pair((Object)(this.leftIndex ? player : (BasePlayer)this.playerPair.getFirst()), (Object)(!this.leftIndex ? player : (BasePlayer)this.playerPair.getSecond()));
        for (class_339 button : this.field_22791) {
            button.field_22764 = true;
        }
    }

    private void startSelectPlayer(boolean left) {
        this.leftIndex = left;
        this.method_25429((class_364)this.playerListWidget);
        this.playerListWidget.selectPreviousEntry(left ? (BasePlayer)this.playerPair.getFirst() : (BasePlayer)this.playerPair.getSecond());
        this.playerListWidget.setVisible(true);
        for (class_339 button : this.field_22791) {
            button.field_22764 = false;
        }
    }

    protected void method_25426() {
        this.initialized = false;
        this.p1ProfileButton = (class_4185)this.method_25411((class_339)new FreeSizeButtonWidget(0, 0, 12, 12, (class_2561)new class_2585("i").method_27692(class_124.field_1067), button -> {
            if (this.field_22787 != null && this.playerPair.getFirst() != null) {
                this.field_22787.method_1507((class_437)new UserProfileScreen(((BasePlayer)this.playerPair.getFirst()).getNickname(), this));
            }
        }));
        this.p1SwitchButton = (class_4185)this.method_25411((class_339)new FreeSizeButtonWidget(0, 0, 12, 12, (class_2561)new class_2585("?").method_27692(class_124.field_1067), button -> this.startSelectPlayer(true)));
        this.p2ProfileButton = (class_4185)this.method_25411((class_339)new FreeSizeButtonWidget(0, 0, 12, 12, (class_2561)new class_2585("i").method_27692(class_124.field_1067), button -> {
            if (this.field_22787 != null && this.playerPair.getSecond() != null) {
                this.field_22787.method_1507((class_437)new UserProfileScreen(((BasePlayer)this.playerPair.getSecond()).getNickname(), this));
            }
        }));
        this.p2SwitchButton = (class_4185)this.method_25411((class_339)new FreeSizeButtonWidget(0, 0, 12, 12, (class_2561)new class_2585("?").method_27692(class_124.field_1067), button -> this.startSelectPlayer(false)));
        this.p2SwitchButton.field_22764 = false;
        this.p1SwitchButton.field_22764 = false;
        this.p2ProfileButton.field_22764 = false;
        this.p1ProfileButton.field_22764 = false;
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 30, 200, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.method_25419()));
    }

    @Override
    public void method_25393() {
        if (this.matchData != null && !this.initialized) {
            if (this.playerPair.getFirst() == null && this.playerPair.getSecond() == null) {
                this.playerPair = new Pair((Object)this.matchData.getPlayers().get(0), this.matchData.getPlayers().size() > 1 ? this.matchData.getPlayers().get(1) : null);
            }
            ((class_4185)this.method_25411((class_339)new class_4185((int)(this.field_22789 / 2 - 152), (int)(this.field_22790 - 54), (int)100, (int)20, (class_2561)new class_2588((String)"projectelo.button.show_all_timelines"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$tick$6(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((UserMatchInfoScreen)this)))).field_22763 = !this.matchTimelines.isEmpty();
            ((class_4185)this.method_25411((class_339)new class_4185((int)(this.field_22789 / 2 - 50), (int)(this.field_22790 - 54), (int)100, (int)20, (class_2561)new class_2588((String)"projectelo.button.watch_replay"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$tick$9(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((UserMatchInfoScreen)this)))).field_22763 = this.matchData.isReplayExist();
            ((class_4185)this.method_25411((class_339)new class_4185((int)(this.field_22789 / 2 + 52), (int)(this.field_22790 - 54), (int)100, (int)20, (class_2561)new class_2588((String)"projectelo.button.download_replay"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$tick$10(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((UserMatchInfoScreen)this)))).field_22763 = this.matchData.isReplayExist();
            this.initialized = true;
        }
        super.method_25393();
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (!this.initialized) {
            this.renderLoadingText(matrices, this.field_22789 / 2, this.field_22790 / 2 - 10);
            this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.loading_server"), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
        } else if (this.matchData != null) {
            if (this.playerListWidget == null) {
                this.playerListWidget = new MatchPlayerListSelectWidget<BasePlayer>(this.field_22787, this.field_22789, this.field_22790, this.matchData.getPlayers(), this::onSelectedPlayer, false);
                this.playerListWidget.setVisible(false);
            }
            if (this.playerListWidget.isVisible()) {
                this.playerListWidget.method_25394(matrices, mouseX, mouseY, delta);
                return;
            }
            this.field_22786.remove(this.playerListWidget);
            class_332.method_25294((class_4587)matrices, (int)0, (int)22, (int)this.field_22789, (int)72, (int)0x55000000);
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            class_5250 winnerText = new class_2588("projectelo.text.match.winner").method_27693(":");
            this.method_27535(matrices, this.field_22793, (class_5348)winnerText, 6, 14, 0xFFFFFF);
            if (this.matchData.getResult().getWinner() != null) {
                RenderUtils.renderPlayerHead(this.matchData.getResult().getWinner(), matrices, 8 + this.field_22793.method_27525((class_5348)winnerText), 14, 8, 8);
                BasePlayer.renderNickname(matrices, 18 + this.field_22793.method_27525((class_5348)winnerText), 14, Objects.requireNonNull(this.matchData.getResult().getWinner(this.matchData)), this, mouseX / 2, mouseY / 2);
            } else {
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.match.draw"), 8 + this.field_22793.method_27525((class_5348)winnerText), 14, 0xFFFFFF);
            }
            RenderSystem.popMatrix();
            this.method_27535(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.match.final_time").method_27693(": " + InGameTimerUtils.timeToStringFormat((long)this.matchData.getResult().getTime())), 12, 48, 0xFFFFFF);
            this.method_27535(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.match.forfeited").method_27693(": ").method_10852((class_2561)(this.matchData.isForfeited() ? RankedScreenTexts.YES.text() : RankedScreenTexts.NO.text())), 12, 58, 0xFFFFFF);
            OverworldSeedType overworldType = this.matchData.getSeedType();
            if (overworldType != OverworldSeedType.UNKNOWN) {
                class_5250 seedTypeText = new class_2588("projectelo.text.seed_type").method_27693(": ").method_10852((class_2561)new class_2588("projectelo.seed_structure_type." + overworldType.name().toLowerCase(Locale.ROOT)));
                this.method_27535(matrices, this.field_22793, (class_5348)seedTypeText, this.field_22789 - 12 - this.field_22793.method_27525((class_5348)seedTypeText) - 12, 48, 0xFFFFFF);
                overworldType.renderIcon(matrices, this.field_22789 - 21, 48, 8, 8);
            }
            class_5250 matchDateText = new class_2588("projectelo.text.match_date").method_27693(": ").method_27693(ClientUtils.timeToDurationFormat(this.matchData.getDate().getTime()) + " ").method_10852((class_2561)new class_2585("(Season " + this.matchData.getSeason() + " / #" + this.matchData.getID() + ")").method_27692(class_124.field_1080));
            this.method_27535(matrices, this.field_22793, (class_5348)matchDateText, this.field_22789 - 12 - this.field_22793.method_27525((class_5348)matchDateText), 58, 0xFFFFFF);
            int rowCount = 7;
            int margin = 20;
            int maxRowCount = 0;
            if (!this.matchData.getPlayers().isEmpty()) {
                BasePlayer firstPlayer = (BasePlayer)this.playerPair.getFirst();
                BasePlayer secondPlayer = (BasePlayer)this.playerPair.getSecond();
                int nicknameX = this.field_22789 / 4 - (12 + this.p1ProfileButton.method_25368() + (firstPlayer == null ? this.field_22793.method_1727("-") : BasePlayer.getNicknameWidth(firstPlayer))) / 2;
                int v = (int)((double)maxRowCount - Math.ceil(3.5)) * 16;
                if (firstPlayer != null) {
                    RenderUtils.renderPlayerHead(firstPlayer.getUUID(), matrices, nicknameX, this.field_22790 / 2 + 20 + v, 8, 8);
                    BasePlayer.renderNickname(matrices, nicknameX + 10, this.field_22790 / 2 + 20 + v, firstPlayer, this, mouseX, mouseY);
                } else {
                    this.method_27535(matrices, this.field_22793, (class_5348)class_2561.method_30163((String)"-"), nicknameX + 10, this.field_22790 / 2 + 20 + v, 0xFFFFFF);
                }
                this.p1ProfileButton.field_22760 = this.field_22789 / 4 + (this.field_22789 / 4 - nicknameX) - this.p1ProfileButton.method_25368();
                this.p1ProfileButton.field_22761 = this.field_22790 / 2 + 20 + v - 2;
                this.p1ProfileButton.field_22764 = this.playerPair.getFirst() != null;
                this.p1SwitchButton.field_22760 = this.p1ProfileButton.field_22760 + 14;
                this.p1SwitchButton.field_22761 = this.p1ProfileButton.field_22761;
                nicknameX = this.field_22789 / 4 * 3 - (12 + this.p2ProfileButton.method_25368() + (secondPlayer == null ? this.field_22793.method_1727("-") : BasePlayer.getNicknameWidth(secondPlayer))) / 2;
                if (secondPlayer != null) {
                    RenderUtils.renderPlayerHead(secondPlayer.getUUID(), matrices, nicknameX, this.field_22790 / 2 + 20 + v, 8, 8);
                    BasePlayer.renderNickname(matrices, nicknameX + 10, this.field_22790 / 2 + 20 + v, secondPlayer, this, mouseX, mouseY);
                } else {
                    this.method_27535(matrices, this.field_22793, (class_5348)class_2561.method_30163((String)"-"), nicknameX + 10, this.field_22790 / 2 + 20 + v, 0xFFFFFF);
                }
                this.p2ProfileButton.field_22760 = this.field_22789 / 4 * 3 + (this.field_22789 / 4 * 3 - nicknameX) - this.p2ProfileButton.method_25368();
                this.p2ProfileButton.field_22761 = this.field_22790 / 2 + 20 + v - 2;
                this.p2ProfileButton.field_22764 = this.playerPair.getSecond() != null;
                this.p2SwitchButton.field_22760 = this.p2ProfileButton.field_22760 + 14;
                this.p2SwitchButton.field_22761 = this.p2ProfileButton.field_22761;
                ++maxRowCount;
                this.p2SwitchButton.field_22764 = this.matchData.getPlayers().size() > 2;
                this.p1SwitchButton.field_22764 = this.p2SwitchButton.field_22764;
            }
            if (!this.matchTimelines.isEmpty() && !this.matchData.isDecayed() && maxRowCount == 1 && this.matchData.getCategory() == RunCategories.ANY) {
                int rowYSize = (int)Math.ceil(3.5);
                this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.enter_nether"), "story.enter_the_nether", this.field_22790 / 2 + 20 + (maxRowCount++ - rowYSize) * 16);
                this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.enter_bastion"), "nether.find_bastion", this.field_22790 / 2 + 20 + (maxRowCount++ - rowYSize) * 16);
                this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.enter_fortress"), "nether.find_fortress", this.field_22790 / 2 + 20 + (maxRowCount++ - rowYSize) * 16);
                this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.blinded"), "projectelo.timeline.blind_travel", this.field_22790 / 2 + 20 + (maxRowCount++ - rowYSize) * 16);
                this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.eye_spy"), "story.follow_ender_eye", this.field_22790 / 2 + 20 + (maxRowCount++ - rowYSize) * 16);
                this.renderEndSplitTexts(matrices, this.field_22790 / 2 + 20 + (maxRowCount - rowYSize) * 16);
                if (this.dragonDeathTextBox.method_1008((double)mouseX, (double)mouseY, 0.0)) {
                    this.setTooltip(new class_2588("projectelo.tooltip.click_to_change_split"));
                }
            } else if (this.matchData.getCategory() != RunCategories.ANY) {
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("speedrunigt.option.timer_category").method_27693(": ").method_10852((class_2561)this.matchData.getCategory().getText().method_27692(class_124.field_1054)), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            } else {
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.failed_load_timeline"), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            }
        }
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
    }

    private boolean shouldRenderEnterEndTime() {
        return (System.currentTimeMillis() - this.openTime) / 2500L % 2L == 0L;
    }

    private void renderEndSplitTexts(class_4587 matrices, int y) {
        BasePlayer firstPlayer = (BasePlayer)this.playerPair.getFirst();
        BasePlayer secondPlayer = (BasePlayer)this.playerPair.getSecond();
        Long firstTime = null;
        Long secondTime = null;
        boolean shouldEnterEnd = this.shouldRenderEnterEndTime();
        for (MatchTimeline timeline : this.matchTimelines) {
            if (firstPlayer != null && timeline.getUUID().equals(firstPlayer.getUUID()) && Objects.equals(timeline.getType(), "projectelo.timeline.dragon_death")) {
                firstTime = timeline.getTime();
            }
            if (secondPlayer != null && timeline.getUUID().equals(secondPlayer.getUUID()) && Objects.equals(timeline.getType(), "projectelo.timeline.dragon_death")) {
                secondTime = timeline.getTime();
            }
            if (firstTime == null || secondTime == null) continue;
            break;
        }
        shouldEnterEnd |= firstTime == null || secondTime == null;
        if (this.dragonDeathToggle != null) {
            boolean bl = shouldEnterEnd = this.dragonDeathToggle == false;
        }
        if (shouldEnterEnd) {
            this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.enter_end"), "story.enter_the_end", y, firstTime != null && secondTime != null);
        } else {
            this.renderSplitTexts(matrices, (class_5250)new class_2588("projectelo.player.status.dragon_death"), "projectelo.timeline.dragon_death", y, true);
        }
    }

    private void renderSplitTexts(class_4587 matrices, class_5250 display, String advancementID, int y) {
        this.renderSplitTexts(matrices, display, advancementID, y, false);
    }

    private void renderSplitTexts(class_4587 matrices, class_5250 display, String advancementID, int y, boolean underline) {
        BasePlayer firstPlayer = (BasePlayer)this.playerPair.getFirst();
        BasePlayer secondPlayer = (BasePlayer)this.playerPair.getSecond();
        Long firstTime = null;
        Long secondTime = null;
        display = display.method_27692(class_124.field_1075);
        if (underline) {
            display = display.method_27692(class_124.field_1073);
            int displayTextWidth = this.field_22793.method_27525((class_5348)display);
            double d = (float)(this.field_22789 - displayTextWidth) / 2.0f - 2.0f;
            double d2 = y - 2;
            double d3 = (float)(this.field_22789 + displayTextWidth) / 2.0f + 2.0f;
            Objects.requireNonNull(this.field_22793);
            this.dragonDeathTextBox = new class_238(d, d2, 0.0, d3, (double)(y + 9 + 2), 1.0);
        }
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)display, this.field_22789 / 2, y, 0xFFFFFF);
        for (MatchTimeline timeline : this.matchTimelines) {
            if (firstPlayer != null && timeline.getUUID().equals(firstPlayer.getUUID()) && Objects.equals(timeline.getType(), advancementID) && firstTime == null) {
                firstTime = timeline.getTime();
            }
            if (secondPlayer != null && timeline.getUUID().equals(secondPlayer.getUUID()) && Objects.equals(timeline.getType(), advancementID) && secondTime == null) {
                secondTime = timeline.getTime();
            }
            if (firstTime == null || secondTime == null) continue;
            break;
        }
        if (firstTime != null) {
            long differentTime = secondTime == null ? -1L : firstTime - secondTime;
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(InGameTimerUtils.timeToStringFormat((long)firstTime)).method_10852((class_2561)(secondTime == null ? class_2585.field_24366 : new class_2585(" (" + (differentTime < 0L ? "-" : "+") + InGameTimerUtils.timeToStringFormat((long)Math.abs(differentTime)) + ")").method_27692(differentTime < 0L ? class_124.field_1060 : (differentTime > 0L ? class_124.field_1061 : class_124.field_1054)))), this.field_22789 / 4, y, 0xFFFFFF);
        }
        if (secondTime != null) {
            long differentTime = firstTime == null ? -1L : secondTime - firstTime;
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2585(InGameTimerUtils.timeToStringFormat((long)secondTime)).method_10852((class_2561)(firstTime == null ? class_2585.field_24366 : new class_2585(" (" + (differentTime < 0L ? "-" : "+") + InGameTimerUtils.timeToStringFormat((long)Math.abs(differentTime)) + ")").method_27692(differentTime < 0L ? class_124.field_1060 : (differentTime > 0L ? class_124.field_1061 : class_124.field_1054)))), this.field_22789 / 4 * 3, y, 0xFFFFFF);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.dragonDeathTextBox.method_1008(mouseX, mouseY, 0.0)) {
            this.dragonDeathToggle = this.dragonDeathToggle == null ? Boolean.valueOf(this.shouldRenderEnterEndTime()) : Boolean.valueOf(this.dragonDeathToggle == false);
            if (this.field_22787 != null) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private /* synthetic */ void lambda$tick$10(class_4185 button) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new UserReplayDownloadScreen((class_437)this, this.matchData.getID()));
        }
    }

    private /* synthetic */ void lambda$tick$9(class_4185 button) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new ReplayLoadingScreen(this));
            new Thread(() -> {
                File replayFile = ReplayManager.downloadReplayFile(this.matchData.getID(), String.valueOf(this.matchData.getID()), true);
                if (replayFile != null) {
                    try {
                        ReplayRecordFile replay = ReplayManager.convertReplayFile(replayFile);
                        ReplayManager.playReplayProcessor(this, replay);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new NoticeMessageScreen(this, "projectelo.text.downloading_replay_failed", new Object[0])));
            }).start();
        }
    }

    private /* synthetic */ void lambda$tick$6(class_4185 button) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(new MatchTimelineScreen<BasePlayer>(this, this.matchTimelines, this.matchData.getPlayers()));
        }
    }
}

