/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.keybinding;

import com.google.common.collect.Lists;
import com.mcsrranked.client.config.keybinding.MultiKeyBinding;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.keybinding.KeyBindingScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class KeyBindingListWidget
extends class_4265<Entry> {
    private final KeyBindingScreen parent;

    public KeyBindingListWidget(KeyBindingScreen parent, class_310 client) {
        super(client, parent.field_22789, parent.field_22790, 24, parent.field_22790 - 32, 20);
        this.parent = parent;
        LinkedHashMap<String, List> categoryToKeyEntryMap = new LinkedHashMap<String, List>();
        for (MultiKeyBinding keyBinding : parent.keyBindings) {
            categoryToKeyEntryMap.computeIfAbsent(keyBinding.getCategory(), category -> Lists.newArrayList()).add(new KeyEntry(keyBinding));
        }
        for (Map.Entry entry : categoryToKeyEntryMap.entrySet()) {
            this.method_25321((class_350.class_351)new CategoryEntry((class_2561)new class_2588((String)entry.getKey())));
            for (KeyEntry keyEntry : (List)entry.getValue()) {
                this.method_25321((class_350.class_351)keyEntry);
            }
        }
    }

    public int method_25322() {
        return this.field_22742;
    }

    protected int method_25329() {
        return this.field_22742 - 16;
    }

    public class KeyEntry
    extends Entry {
        private final MultiKeyBinding binding;
        private final class_2561 name;
        private final List<class_364> children = new ArrayList<class_364>();
        private final List<class_4185> keyBindingButtons = new ArrayList<class_4185>();
        private final class_4185 addKeyButton;
        private int focusedKey = 0;

        private KeyEntry(MultiKeyBinding keyBinding) {
            this.binding = keyBinding;
            this.name = new class_2588(keyBinding.getTranslationKey());
            for (int i = 0; i < this.binding.getKeys().size(); ++i) {
                this.keyBindingButtons.add(this.createKeyBindingButton());
            }
            this.addKeyButton = new class_4185(0, 0, 20, 20, (class_2561)new class_2585("+"), button -> {
                class_4185 newButton = this.createKeyBindingButton();
                this.keyBindingButtons.add(newButton);
                this.children.add((class_364)newButton);
                this.binding.addKey(class_3675.field_16237);
                ((KeyBindingListWidget)KeyBindingListWidget.this).parent.focusedBinding = this;
                this.focusedKey = this.keyBindingButtons.size() - 1;
            });
            this.children.add((class_364)this.addKeyButton);
            this.children.addAll(this.keyBindingButtons);
        }

        private class_4185 createKeyBindingButton() {
            return new class_4185(0, 0, 75, 20, class_2585.field_24366, button -> {
                ((KeyBindingListWidget)KeyBindingListWidget.this).parent.focusedBinding = this;
                this.focusedKey = this.keyBindingButtons.indexOf(button);
            }){

                protected class_5250 method_25360() {
                    class_3675.class_306 key = KeyEntry.this.binding.getKey(KeyEntry.this.keyBindingButtons.indexOf((Object)this));
                    if (key.equals((Object)class_3675.field_16237)) {
                        return new class_2588("narrator.controls.unbound", new Object[]{KeyEntry.this.name});
                    }
                    return new class_2588("narrator.controls.bound", new Object[]{KeyEntry.this.name, key.method_27445()});
                }
            };
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int padding = 40;
            class_327 class_3272 = ((KeyBindingListWidget)KeyBindingListWidget.this).field_22740.field_1772;
            float f = x + padding;
            int n = y + entryHeight / 2;
            Objects.requireNonNull(((KeyBindingListWidget)KeyBindingListWidget.this).field_22740.field_1772);
            class_3272.method_27528(matrices, (class_5348)this.name, f, (float)(n - 9 / 2), 0xFFFFFF);
            int xOffset = 10;
            int rightX = x + entryWidth - padding;
            this.addKeyButton.field_22760 = rightX -= this.addKeyButton.method_25368();
            this.addKeyButton.field_22761 = y;
            this.addKeyButton.method_25394(matrices, mouseX, mouseY, tickDelta);
            int keySize = this.keyBindingButtons.size();
            for (class_4185 keyBindingButton : this.keyBindingButtons) {
                this.renderKeyBindingButton(keyBindingButton, this.binding.getKey(this.keyBindingButtons.indexOf(keyBindingButton)), rightX - keySize-- * (xOffset + keyBindingButton.method_25368()), y, matrices, mouseX, mouseY, tickDelta);
            }
        }

        private void renderKeyBindingButton(class_4185 button, class_3675.class_306 key, int x, int y, class_4587 matrices, int mouseX, int mouseY, float tickDelta) {
            button.field_22760 = x;
            button.field_22761 = y;
            if (key.method_27445().getString().isEmpty()) {
                button.method_25355((class_2561)RankedScreenTexts.KEY_NOT_BOUND.text());
                this.addKeyButton.field_22763 = false;
            } else {
                button.method_25355(key.method_27445());
                this.addKeyButton.field_22763 = true;
            }
            if (((KeyBindingListWidget)KeyBindingListWidget.this).parent.focusedBinding == this && this.focusedKey == this.keyBindingButtons.indexOf(button)) {
                button.method_25355((class_2561)new class_2585("> ").method_10852((class_2561)button.method_25369().method_27661()).method_27693(" <").method_27692(class_124.field_1054));
            }
            button.method_25394(matrices, mouseX, mouseY, tickDelta);
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (((KeyBindingListWidget)KeyBindingListWidget.this).parent.focusedBinding == this) {
                class_3675.class_306 key = class_3675.method_15985((int)keyCode, (int)scanCode);
                if (key.method_1442() == class_3675.class_307.field_1672) {
                    return false;
                }
                if (keyCode != 256) {
                    this.binding.setKey(this.focusedKey, key);
                } else if (this.binding.removeKey(this.focusedKey)) {
                    class_4185 class_41852 = this.keyBindingButtons.remove(this.focusedKey);
                    this.children.remove(class_41852);
                }
                this.focusedKey = 0;
                return true;
            }
            for (class_364 class_3642 : this.method_25396()) {
                if (!class_3642.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            return false;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (((KeyBindingListWidget)KeyBindingListWidget.this).parent.focusedBinding == this) {
                ((KeyBindingListWidget)KeyBindingListWidget.this).parent.focusedBinding = null;
                this.focusedKey = 0;
                return true;
            }
            for (class_364 class_3642 : this.method_25396()) {
                if (!class_3642.method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            for (class_364 class_3642 : this.method_25396()) {
                if (!class_3642.method_25406(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }

    public class CategoryEntry
    extends Entry {
        private final class_2561 text;
        private final int textWidth;

        public CategoryEntry(class_2561 text) {
            this.text = text;
            this.textWidth = ((KeyBindingListWidget)KeyBindingListWidget.this).field_22740.field_1772.method_27525((class_5348)this.text);
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 class_3272 = ((KeyBindingListWidget)KeyBindingListWidget.this).field_22740.field_1772;
            float f = (float)(((KeyBindingListWidget)KeyBindingListWidget.this).parent.field_22789 - this.textWidth) / 2.0f;
            Objects.requireNonNull(((KeyBindingListWidget)KeyBindingListWidget.this).field_22740.field_1772);
            class_3272.method_27528(matrices, (class_5348)this.text, f, (float)(y + entryHeight - 9 - 1), 0xFFFFFF);
        }

        public boolean method_25407(boolean lookForwards) {
            return false;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
    }
}

