/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.match;

import com.google.common.collect.Lists;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.QueueInfoHud;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.MatchMenuScreen;
import com.mcsrranked.client.gui.screen.RankedMainScreen;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.info.UserMatchInfoScreen;
import com.mcsrranked.client.gui.screen.match.MatchPrivateRoomScreen;
import com.mcsrranked.client.gui.widget.MatchChatWidget;
import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.online.OnlineEloChange;
import com.mcsrranked.client.info.match.online.OnlineMatchResult;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.utils.RenderUtils;
import com.mcsrranked.client.utils.TextureUtils;
import com.mcsrranked.client.world.WorldCreator;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.class_1074;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Triple;

public class MatchBattleScreen
extends RankedScreen {
    private static boolean TRY_CANCEL_QUEUE = false;
    private static final class_2960 DEFAULT_USER_BACKGROUND = new class_2960("mcsrranked", "textures/gui/user_background/default.png");
    private boolean initWidget = false;
    private boolean initOpponent = false;
    private boolean enableFade = false;
    private final MatchType matchType;
    private final OnlineMatchResult result;
    private MatchChatWidget matchChatWidget;
    private final long[] enterAnimateTime = new long[]{0L, 0L};
    private long startTime;
    private Triple<Float, Integer, Integer> winnerTextInfo = null;

    public static void cancelQueue() {
        TRY_CANCEL_QUEUE = true;
        SocketInstance.getInstance().emit("p$queue_cancel", new Object[0]);
    }

    public MatchBattleScreen(class_437 parent, MatchType matchType) {
        this(parent, matchType, null);
    }

    public MatchBattleScreen(class_437 parent, MatchType matchType, OnlineMatchResult result) {
        super(parent, (class_2561)new class_2588("projectelo.text.match_room", new Object[]{class_1074.method_4662((String)matchType.getKey(), (Object[])new Object[0])}));
        this.matchType = matchType;
        this.result = result;
        this.reset(this.result != null);
        if (!MCSRRankedClient.getCurrentQueue().isPresent() && result == null) {
            SocketInstance.getInstance().emit("p$queue", matchType.getID(), "", RankedOptions.getQueueFlag().getFlagValue());
            TRY_CANCEL_QUEUE = false;
        }
        SocketInstance.on("p$queue", payload -> {
            MCSRRankedClient.setCurrentQueue(MatchType.byID(payload.getNextInteger()));
            OnlinePlayer.of(payload.getNextString());
        });
        SocketInstance.on("p$queue_cancel", payload -> {
            MCSRRankedClient.setCurrentQueue(null);
            QueueInfoHud.getInstance().onUpdate();
        });
    }

    protected void method_25426() {
        this.initWidget = false;
        this.initOpponent = false;
        if (this.field_22787 != null) {
            this.field_22787.field_1774.method_1462(true);
            this.field_22787.field_1690.field_1880 = false;
        }
    }

    public void reset(boolean enableFade) {
        this.enableFade = enableFade;
        this.startTime = System.currentTimeMillis();
    }

    public boolean method_25422() {
        return false;
    }

    public boolean method_25421() {
        return !this.enableFade || (Boolean)SpeedRunOption.getOption(RankedOptions.SPECTATE_AT_ENDS) == false || System.currentTimeMillis() - this.startTime > 2000L;
    }

    @Override
    public void method_25419() {
        super.method_25419();
        QueueInfoHud.getInstance().onExitRoom();
        if (this.result != null) {
            if (this.result.getChanges() != null) {
                for (OnlineEloChange change : this.result.getChanges()) {
                    if (MCSRRankedClient.LOCAL_PLAYER.getEloRate() == null || !MCSRRankedClient.LOCAL_PLAYER.getUUID().equals(change.getUUID())) continue;
                    MCSRRankedClient.LOCAL_PLAYER.setEloRate(MCSRRankedClient.LOCAL_PLAYER.getEloRate() + change.getChange());
                }
            }
            MCSRRankedClient.setCurrentQueue(null);
        }
    }

    @Override
    public void method_25393() {
        if (TRY_CANCEL_QUEUE && !MCSRRankedClient.getCurrentQueue().isPresent() && this.result == null) {
            this.method_25419();
            return;
        }
        if (!(this.initWidget || !MCSRRankedClient.getCurrentQueue().isPresent() || this.enableFade && System.currentTimeMillis() - this.startTime < 2000L)) {
            this.initWidget = true;
            if (this.result == null) {
                this.method_25411((class_339)new class_4185(this.field_22789 - 160, this.field_22790 - 52, 150, 20, (class_2561)new class_2588("projectelo.button.queue_in_background"), button -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507((class_437)RankedMainScreen.create());
                        QueueInfoHud.getInstance().onExitRoom();
                    }
                }));
                this.method_25411((class_339)new class_4185(this.field_22789 - 160, this.field_22790 - 30, 150, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> {
                    this.field_22791.forEach(b -> {
                        b.field_22763 = false;
                    });
                    MatchBattleScreen.cancelQueue();
                }));
            } else {
                this.method_25411((class_339)new class_4185(this.field_22789 - 210, this.field_22790 - 30, 200, 20, (class_2561)RankedScreenTexts.DONE.text(), button -> this.exitMatch(() -> {
                    WorldCreator.getInstance().stopWorld();
                    assert (this.field_22787 != null);
                    this.field_22787.method_1507((class_437)RankedMainScreen.create());
                })));
                this.method_25411((class_339)new class_4185(this.field_22789 - 210, this.field_22790 - 52, 98, 20, (class_2561)new class_2588((Boolean)SpeedRunOption.getOption(RankedOptions.SPECTATE_AT_ENDS) != false ? "projectelo.button.spectate_world" : "projectelo.button.continue_world"), button -> this.exitMatch(() -> {
                    class_1132 server;
                    if (this.field_22787 != null && (server = this.field_22787.method_1576()) != null) {
                        server.method_3760().method_14607(true);
                        if (this.field_22787.field_1724 != null) {
                            this.field_22787.field_1724.method_3147(server.method_3835(this.field_22787.field_1724.method_7334()));
                        }
                        for (class_3222 serverPlayerEntity : server.method_3760().method_14571()) {
                            server.method_3734().method_9241(serverPlayerEntity);
                        }
                        if (!((Boolean)SpeedRunOption.getOption(RankedOptions.SPECTATE_AT_ENDS)).booleanValue()) {
                            this.field_22787.field_1705.method_1743().method_1812((class_2561)new class_2588("projectelo.text.warning_continue_world"));
                        }
                    }
                })));
                this.method_25411((class_339)new class_4185(this.field_22789 - 108, this.field_22790 - 52, 98, 20, (class_2561)new class_2588("projectelo.button.find_new_match"), button -> this.exitMatch(() -> {
                    WorldCreator.getInstance().stopWorld();
                    assert (this.field_22787 != null);
                    this.field_22787.method_1507((class_437)new MatchBattleScreen((class_437)new MatchMenuScreen(RankedMainScreen.create()), this.matchType));
                })));
                ArrayList seedVoteButtons = Lists.newArrayList();
                seedVoteButtons.add((class_4185)this.method_25411((class_339)new class_4185(this.field_22789 - 235, this.field_22790 - 52, 20, 20, (class_2561)new class_2585("\u25b2").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}), button -> {
                    seedVoteButtons.forEach(buttonWidget -> {
                        buttonWidget.field_22763 = false;
                    });
                    SocketInstance.getInstance().emit("p$seed_rate", 1);
                }, (buttonWidget, matrixStack, x, y) -> this.method_25424(matrixStack, (class_5348)new class_2588("projectelo.tooltip.seed_vote.like"), x, y))));
                seedVoteButtons.add((class_4185)this.method_25411((class_339)new class_4185(this.field_22789 - 235, this.field_22790 - 30, 20, 20, (class_2561)new class_2585("\u25bc").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), button -> {
                    seedVoteButtons.forEach(buttonWidget -> {
                        buttonWidget.field_22763 = false;
                    });
                    SocketInstance.getInstance().emit("p$seed_rate", 0);
                }, (buttonWidget, matrixStack, x, y) -> this.method_25424(matrixStack, (class_5348)new class_2588("projectelo.tooltip.seed_vote.dislike"), x, y))));
            }
        }
        if (!this.initOpponent && MCSRRankedClient.getOnlineMatch().map(match -> match.getPlayers().size() > 1 && match.getType() != MatchType.PRIVATE).orElse(false).booleanValue()) {
            this.initOpponent = true;
            if (this.result == null) {
                this.field_22791.forEach(button -> {
                    button.field_22764 = false;
                });
            }
            this.matchChatWidget = new MatchChatWidget(this.field_22793, 10, this.field_22790 - 27, (int)((double)((float)this.field_22789 / 2.0f) * 0.7), this);
            this.method_20085((class_364)this.matchChatWidget);
            this.method_25429((class_364)this.matchChatWidget);
        }
        if (this.matchChatWidget != null) {
            this.matchChatWidget.method_1865();
        }
        super.method_25393();
    }

    private void exitMatch(Runnable runnable) {
        this.field_22791.forEach(screenButton -> {
            screenButton.field_22763 = false;
        });
        SocketInstance.getInstance().emit("p$leave", new Object[0]);
        CompletableFuture.runAsync(() -> {
            while (MCSRRankedClient.getOnlineMatch().isPresent()) {
                Thread.yield();
                LockSupport.parkNanos("waiting for ready to requeue", 100000L);
            }
            if (this.field_22787 != null) {
                this.field_22787.execute(() -> {
                    this.method_25419();
                    runnable.run();
                });
            }
        });
    }

    private boolean isMouseOnInfoButton(double mouseX, double mouseY) {
        if (this.winnerTextInfo == null) {
            return false;
        }
        float targetX = (float)((Integer)this.winnerTextInfo.getMiddle()).intValue() * ((Float)this.winnerTextInfo.getLeft()).floatValue();
        float targetY = (float)((Integer)this.winnerTextInfo.getRight()).intValue() * ((Float)this.winnerTextInfo.getLeft()).floatValue();
        float width = 8.0f * ((Float)this.winnerTextInfo.getLeft()).floatValue();
        return mouseX >= (double)(targetX - 2.0f) && mouseX < (double)(targetX + width + 2.0f) && mouseY >= (double)(targetY - 2.0f) && mouseY < (double)(targetY + width + 2.0f);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_3545<Integer, OnlinePlayer> recentMatch;
        if (this.isMouseOnInfoButton(mouseX, mouseY) && (recentMatch = MCSRRankedClient.RECENT_MATCHES.peekLast()) != null) {
            this.exitMatch(() -> {
                WorldCreator.getInstance().stopWorld();
                ClientUtils.playSound(class_3417.field_15015, 1.0f, 0.25f);
                assert (this.field_22787 != null);
                this.field_22787.method_1507((class_437)new UserMatchInfoScreen((class_437)RankedMainScreen.create(), (Integer)recentMatch.method_15442()));
            });
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long duration = currentTime - this.startTime;
        if (this.enableFade && duration <= 2000L) {
            RenderSystem.pushMatrix();
            int alpha = (int)class_3532.method_16439((float)((float)duration / 2000.0f), (float)0.0f, (float)255.0f);
            int color = class_5253.class_5254.method_27764((int)alpha, (int)0, (int)0, (int)0);
            MatchBattleScreen.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)color);
            RenderSystem.popMatrix();
            if (this.matchChatWidget != null) {
                this.matchChatWidget.method_25394(matrices, mouseX, mouseY, delta);
            }
            return;
        }
        this.renderSpecialBackground(matrices);
        class_332.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)class_5253.class_5254.method_27764((int)120, (int)0, (int)0, (int)0));
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.method_27534(matrices, this.field_22793, (class_5348)this.field_22785, this.field_22789 / 2, 10, -1);
        if (!MCSRRankedClient.getCurrentQueue().isPresent()) {
            this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.roommessage.finding"), this.field_22789 / 2, this.field_22790 / 2 - 6, 0xFFFFFF);
            this.renderLoadingText(matrices, this.field_22789 / 2, this.field_22790 / 2 + 5);
        } else {
            OnlinePlayer localPlayer = MCSRRankedClient.LOCAL_PLAYER;
            OnlinePlayer opponent = Optional.ofNullable(MCSRRankedClient.getCurrentQueue().get().getOpponent()).orElse(OnlinePlayer.DUMMY_PLAYER);
            this.renderPlayers(matrices, localPlayer, opponent, currentTime, mouseX, mouseY);
        }
        if (this.enableFade && duration < 4000L) {
            RenderSystem.pushMatrix();
            int alpha = (int)(255.0f - class_3532.method_16439((float)((float)(duration - 2000L) / 2000.0f), (float)0.0f, (float)255.0f));
            int color = class_5253.class_5254.method_27764((int)alpha, (int)0, (int)0, (int)0);
            MatchBattleScreen.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)color);
            RenderSystem.popMatrix();
        }
        if (this.matchChatWidget != null) {
            this.matchChatWidget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    public void renderPlayers(class_4587 matrices, OnlinePlayer localPlayer, OnlinePlayer opponent, long currentTime, int mouseX, int mouseY) {
        int textWidth;
        int[] eloChanges = new int[]{0, 0};
        int[] totalChanges = new int[]{0, 0};
        long animateDuration = class_3532.method_24156((long)(currentTime - this.startTime - (long)(!this.enableFade ? 2500 : 4500)), (long)0L, (long)2500L);
        if (this.result != null && animateDuration > 0L && !((Boolean)SpeedRunOption.getOption(RankedOptions.HIDE_ELO_SCORE)).booleanValue() && this.result.getChanges() != null && !this.result.getChanges().isEmpty()) {
            for (OnlineEloChange change : this.result.getChanges()) {
                int index = change.getUUID().equals(localPlayer.getUUID()) ? 0 : 1;
                OnlinePlayer target = index == 0 ? localPlayer : opponent;
                if (target.getEloRate() == null || change.getChange() == 0) continue;
                totalChanges[index] = change.getChange();
                eloChanges[index] = (int)class_3532.method_15390((double)0.0, (double)change.getChange(), (double)Math.pow((double)animateDuration / 2500.0, 0.4));
            }
        }
        assert (this.field_22787 != null);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
        if (this.enterAnimateTime[0] == 0L) {
            this.enterAnimateTime[0] = currentTime;
        }
        if (opponent == OnlinePlayer.DUMMY_PLAYER) {
            this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.roommessage.idle_1v1"), this.field_22789 / 4, this.field_22790 / 4 - 14, 0xFFFFFF);
        } else if (this.result != null) {
            if (this.enterAnimateTime[1] == 0L) {
                this.enterAnimateTime[1] = currentTime;
            }
            class_5250 resultText = this.result.getWinner() != null ? new class_2588("projectelo.text.match.winner").method_27693(": ").method_10852((class_2561)new class_2585((localPlayer.getUUID().equals(this.result.getWinner()) ? localPlayer : opponent).getNickname()).method_27692(class_124.field_1054)).method_10852((class_2561)new class_2585(" (" + InGameTimerUtils.timeToStringFormat((long)this.result.getFinalTime()) + ")").method_27692(class_124.field_1075)) : new class_2588("projectelo.title.match_done.draw").method_10852((class_2561)new class_2585(" (" + InGameTimerUtils.timeToStringFormat((long)this.result.getFinalTime()) + ")").method_27692(class_124.field_1075));
            RenderSystem.pushMatrix();
            float scale = 2.0f;
            textWidth = this.field_22793.method_27525((class_5348)resultText);
            while ((double)textWidth >= (double)this.field_22789 * 0.85 / (double)scale) {
                scale -= 0.5f;
            }
            RenderSystem.scalef((float)(scale / 2.0f), (float)(scale / 2.0f), (float)1.0f);
            int resultX = (int)((float)((int)((float)this.field_22789 / (2.0f * scale))) - 10.0f / scale);
            int resultY = (int)((float)this.field_22790 / (2.0f * scale) - (14.0f - (scale - 2.0f) * 4.0f));
            this.method_27534(matrices, this.field_22793, (class_5348)resultText, resultX, resultY, 0xFFFFFF);
            this.winnerTextInfo = Triple.of((Object)Float.valueOf(scale), (Object)(resultX + textWidth / 2 + 2), (Object)resultY);
            this.field_22787.method_1531().method_22813(TextureUtils.DEFAULT_GUI_TEXTURE);
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            MatchBattleScreen.method_25293((class_4587)matrices, (int)((Integer)this.winnerTextInfo.getMiddle()), (int)((Integer)this.winnerTextInfo.getRight()), (int)8, (int)8, (float)80.0f, (float)0.0f, (int)16, (int)16, (int)128, (int)128);
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
            RenderSystem.popMatrix();
            if (this.isMouseOnInfoButton(mouseX, mouseY)) {
                this.setTooltip(new class_2588("projectelo.tooltip.click_to_open_match_info"));
            }
        } else {
            if (this.enterAnimateTime[1] == 0L) {
                this.enterAnimateTime[1] = currentTime;
            }
            RenderUtils.drawOutlineText(this.field_22793, matrices, (class_2561)new class_2585("VS").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), this.field_22789 / 4, this.field_22790 / 4 - 14);
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.roommessage.ready", new Object[]{MatchPrivateRoomScreen.getRemainStartTime()}), this.field_22789 / 2, this.field_22790 / 2 + 72, 0xFFFFFF);
            RenderSystem.popMatrix();
        }
        int xOffset = this.field_22789 / 12;
        int yOffset = this.field_22790 / 4 - 43;
        this.field_22787.method_1531().method_22813(DEFAULT_USER_BACKGROUND);
        RenderSystem.enableBlend();
        class_332.method_25293((class_4587)matrices, (int)0, (int)(yOffset - 4), (int)(this.field_22789 / 2), (int)28, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
        RenderSystem.disableBlend();
        RenderSystem.pushMatrix();
        if (this.enterAnimateTime[0] != 0L) {
            RenderSystem.translated((double)class_3532.method_16436((double)(Math.pow(class_3532.method_15363((float)((float)(currentTime - this.enterAnimateTime[0]) / 1000.0f), (float)0.0f, (float)1.0f) - 1.0f, 3.0) + 1.0), (double)((double)(-this.field_22789) / 2.0), (double)0.0), (double)0.0, (double)0.0);
        }
        RenderUtils.renderPlayerHead(localPlayer.getUUID(), matrices, xOffset, yOffset, 20, 20);
        BasePlayer.renderNickname(matrices, xOffset + 22, yOffset + 1, localPlayer, this, mouseX / 2, mouseY / 2);
        if (totalChanges[0] != 0) {
            textWidth = BasePlayer.renderEloText(matrices, xOffset + 22, yOffset + 11, (Integer)ObjectUtils.defaultIfNull((Object)localPlayer.getEloRate(), (Object)0) + eloChanges[0], localPlayer.getEloRank(), eloChanges[0] != 0 && animateDuration < 2500L);
            class_2561 change = this.getChangeText(totalChanges[0]);
            this.method_27535(matrices, this.field_22793, (class_5348)change, xOffset + 24 + textWidth, yOffset + 11, 0xFFFFFF);
        } else {
            BasePlayer.renderEloText(matrices, xOffset + 22, yOffset + 11, localPlayer.getEloRate(), localPlayer.getEloRank());
        }
        RenderSystem.popMatrix();
        xOffset = this.field_22789 / 12 * 5 + 2;
        yOffset = this.field_22790 / 4 + 4;
        this.field_22787.method_1531().method_22813(DEFAULT_USER_BACKGROUND);
        RenderSystem.enableBlend();
        class_332.method_25293((class_4587)matrices, (int)0, (int)(yOffset - 4), (int)(this.field_22789 / 2 + 1), (int)28, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)-128, (int)128);
        RenderSystem.disableBlend();
        RenderSystem.pushMatrix();
        if (this.enterAnimateTime[1] != 0L) {
            RenderSystem.translated((double)class_3532.method_16436((double)(Math.pow(class_3532.method_15363((float)((float)(currentTime - this.enterAnimateTime[1]) / 1000.0f), (float)0.0f, (float)1.0f) - 1.0f, 3.0) + 1.0), (double)((double)this.field_22789 / 2.0), (double)0.0), (double)0.0, (double)0.0);
        }
        RenderUtils.renderPlayerHead(opponent.getDisplayUUID(), matrices, xOffset - 19, yOffset, 20, 20);
        if (opponent == OnlinePlayer.DUMMY_PLAYER) {
            RenderSystem.enableBlend();
            class_332.method_25294((class_4587)matrices, (int)(xOffset - 19), (int)yOffset, (int)(xOffset + 1), (int)(yOffset + 20), (int)-2013265920);
            RenderSystem.disableBlend();
            class_5250 findingText = new class_2585("????").method_27692(class_124.field_1080);
            int findingWidth = this.field_22793.method_27525((class_5348)findingText);
            this.method_27535(matrices, this.field_22793, (class_5348)findingText, xOffset - 22 - findingWidth - 3, yOffset + 6, 0xFFFFFF);
        } else {
            int nicknameWidth = BasePlayer.getNicknameWidth(opponent);
            BasePlayer.renderNickname(matrices, xOffset - 22 - nicknameWidth, yOffset + 1, opponent, this, mouseX / 2, mouseY / 2);
            if (totalChanges[1] != 0) {
                class_2561 change = this.getChangeText(totalChanges[1]);
                int newEloRate = (Integer)ObjectUtils.defaultIfNull((Object)opponent.getEloRate(), (Object)0) + eloChanges[1];
                int eloTextWidth = BasePlayer.getEloTextWidth(newEloRate, opponent.getEloRank());
                int eloChangeWidth = this.field_22793.method_27525((class_5348)change);
                BasePlayer.renderEloText(matrices, xOffset - 24 - eloTextWidth - eloChangeWidth, yOffset + 11, newEloRate, opponent.getEloRank(), eloChanges[1] != 0 && animateDuration < 2500L);
                this.method_27535(matrices, this.field_22793, (class_5348)change, xOffset - 22 - eloChangeWidth, yOffset + 11, 0xFFFFFF);
            } else {
                int eloTextWidth = BasePlayer.getEloTextWidth(opponent.getEloRate(), opponent.getEloRank());
                BasePlayer.renderEloText(matrices, xOffset - 22 - eloTextWidth, yOffset + 11, opponent.getEloRate(), opponent.getEloRank());
            }
        }
        RenderSystem.popMatrix();
        RenderSystem.popMatrix();
    }

    private class_2561 getChangeText(int changeAmount) {
        return new class_2585("(" + (changeAmount < 0 ? "-" : (changeAmount > 0 ? "+" : "")) + Math.abs(changeAmount) + ")").method_27692(changeAmount < 0 ? class_124.field_1061 : class_124.field_1060);
    }

    @Override
    public boolean shouldRenderMatchHud() {
        return false;
    }
}

