/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.match;

import com.google.common.collect.Lists;
import com.mcsrranked.client.gui.MessageToast;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.match.TimelineUpdateListener;
import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.info.match.MatchSplit;
import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.utils.RenderUtils;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class MatchPlayersScreen
extends RankedScreen
implements TimelineUpdateListener {
    private final List<MatchTimeline> timelines = Lists.newCopyOnWriteArrayList();
    private final List<OnlinePlayer> players;
    protected SplitWidget splitWidget;

    public MatchPlayersScreen(class_437 parent, List<MatchTimeline> initTimelines, List<OnlinePlayer> players) {
        super(parent, (class_2561)new class_2588("projectelo.text.match.match_players"));
        this.timelines.addAll(initTimelines.stream().sorted(Comparator.comparingLong(MatchTimeline::getTime)).collect(Collectors.toList()));
        this.players = players;
    }

    protected void method_25426() {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        this.splitWidget = new SplitWidget(this.field_22787, this.field_22789, this.field_22790, 40, this.field_22790 - 40, 9 + 4);
        this.splitWidget.updateTimeline(this.timelines, this.players);
        this.method_25429((class_364)this.splitWidget);
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 30, 200, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.method_25419()));
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean shouldRenderMatchHud() {
        return false;
    }

    @Override
    public void onAddNewTimeline(MatchTimeline timeline) {
        this.timelines.add(timeline);
        OnlinePlayer targetPlayer = this.players.stream().filter(player -> player.getUUID().equals(timeline.getUUID())).findFirst().orElse(null);
        MatchSplit currentSplit = MatchSplit.getSplit(this.timelines, targetPlayer);
        for (SplitWidget.Entry child : this.splitWidget.method_25396()) {
            if (!child.player.equals(targetPlayer)) continue;
            if (child.currentSplit == currentSplit) {
                return;
            }
            child.currentSplit = currentSplit;
            child.time = timeline.getTime();
            return;
        }
        this.splitWidget.addEntry(new SplitWidget.Entry(targetPlayer, timeline.getTime(), currentSplit));
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.splitWidget.method_25396().sort((entry1, entry2) -> {
            if (((SplitWidget.Entry)entry1).currentSplit == ((SplitWidget.Entry)entry2).currentSplit) {
                return Math.toIntExact(((SplitWidget.Entry)entry1).time) - Math.toIntExact(((SplitWidget.Entry)entry2).time);
            }
            return ((SplitWidget.Entry)entry1).currentSplit.ordinal() - ((SplitWidget.Entry)entry2).currentSplit.ordinal();
        });
        this.splitWidget.method_25394(matrices, mouseX, mouseY, delta);
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)this.method_25440(), this.getTitleCenter(), 16, 0xFFFFFF);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public static class SplitWidget
    extends class_4265<Entry>
    implements RankedEntryListWidget {
        public SplitWidget(class_310 client, int width, int height, int top, int bottom, int itemHeight) {
            super(client, width, height, top, bottom, itemHeight);
        }

        public int addEntry(Entry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public int method_25322() {
            int maxNicknameWidth = 0;
            int maxTimelineWidth = 0;
            for (Entry child : this.method_25396()) {
                maxNicknameWidth = Math.max(maxNicknameWidth, this.field_22740.field_1772.method_1727(child.getPlayer().getNickname()));
                maxTimelineWidth = Math.max(maxTimelineWidth, this.field_22740.field_1772.method_27525((class_5348)child.getCurrentSplit().getText().method_27693("  " + InGameTimerUtils.timeToStringFormat((long)child.time))));
            }
            return 22 + maxNicknameWidth + maxTimelineWidth;
        }

        public void updateTimeline(List<MatchTimeline> timelines, List<OnlinePlayer> players) {
            this.method_25339();
            for (OnlinePlayer player : players) {
                MatchSplit currentSplit = MatchSplit.getSplit(timelines, player);
                MatchTimeline timeline = timelines.stream().filter(tl -> tl.getType().equals(currentSplit.getType()) && tl.getUUID().equals(player.getUUID())).reduce((first, second) -> second).orElse(null);
                this.addEntry(new Entry(player, timeline == null ? 0L : timeline.getTime(), currentSplit));
            }
        }

        public static class Entry
        extends class_4265.class_4266<Entry> {
            private final OnlinePlayer player;
            private long time;
            private MatchSplit currentSplit;
            private final List<class_4185> buttonWidgets = Lists.newArrayList();

            public Entry(OnlinePlayer player, long time, MatchSplit currentSplit) {
                this.player = player;
                this.time = time;
                this.currentSplit = currentSplit;
            }

            public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                if (this.getPlayer() == null) {
                    return;
                }
                RenderUtils.renderPlayerHead(this.getPlayer().getUUID(), matrices, x, y + 1, 8, 8);
                class_327 textRenderer = class_310.method_1551().field_1772;
                textRenderer.method_27517(matrices, (class_5348)new class_2585(this.getPlayer().getNickname()), (float)(x + 11), (float)(y + 1), 0xFFFFFF);
                class_5250 splitText = this.getCurrentSplit().getText().method_27692(class_124.field_1075).method_10852((class_2561)new class_2585("  " + InGameTimerUtils.timeToStringFormat((long)this.time)).method_27692(class_124.field_1054));
                textRenderer.method_27517(matrices, (class_5348)splitText, (float)(x + entryWidth - textRenderer.method_27525((class_5348)splitText)), (float)(y + 1), 0xFFFFFF);
                for (class_4185 buttonWidget : this.buttonWidgets) {
                    buttonWidget.method_25394(matrices, mouseX, mouseY, tickDelta);
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (button == 1) {
                    class_310.method_1551().field_1774.method_1455(this.player.getNickname() + (this.player.getTwitchId() != null ? ":" + this.player.getTwitchId() : ""));
                    class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.copied", (Object[])new Object[0])));
                }
                return super.method_25402(mouseX, mouseY, button);
            }

            public OnlinePlayer getPlayer() {
                return this.player;
            }

            public MatchSplit getCurrentSplit() {
                return this.currentSplit;
            }

            public List<class_4185> method_25396() {
                return this.buttonWidgets;
            }
        }
    }
}

