/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.match;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.MessageToast;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.WarningScreen;
import com.mcsrranked.client.gui.widget.FreeSizeButtonWidget;
import com.mcsrranked.client.gui.widget.FreeSizeTexturedButtonWidget;
import com.mcsrranked.client.gui.widget.MatchCategoryListWidget;
import com.mcsrranked.client.gui.widget.MatchChatWidget;
import com.mcsrranked.client.gui.widget.MatchJoinRequestListWidget;
import com.mcsrranked.client.gui.widget.MatchOptionListWidget;
import com.mcsrranked.client.gui.widget.MatchPresetListWidget;
import com.mcsrranked.client.gui.widget.MatchRoomMemberListWidget;
import com.mcsrranked.client.gui.widget.TimeFormatFieldWidget;
import com.mcsrranked.client.info.BotDifficulty;
import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.online.JoinRequestRemoval;
import com.mcsrranked.client.info.match.online.MatchFlag;
import com.mcsrranked.client.info.match.online.MatchOption;
import com.mcsrranked.client.info.match.online.MatchStatus;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.match.online.gamemode.GameMode;
import com.mcsrranked.client.info.match.online.gamemode.MostPercentGameMode;
import com.mcsrranked.client.info.match.online.gamemode.ScoutRouteGameMode;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.info.player.PlayerPermission;
import com.mcsrranked.client.socket.SocketEvent;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.utils.RenderUtils;
import com.mcsrranked.client.utils.TextureUtils;
import com.mcsrranked.client.utils.UUIDUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class MatchPrivateRoomScreen
extends RankedScreen {
    private static Status CURRENT_STATUS = Status.NONE;
    private final String targetMatchCode;
    private MatchRoomMemberListWidget memberListWidget;
    private final List<class_4185> tabButtons = Lists.newArrayList();
    private boolean matchCodeVisible = false;
    private int currentMemberCount = 0;
    private boolean tryLeaveRoom = false;
    private MatchJoinRequestListWidget matchRequestWidget;
    private FreeSizeButtonWidget requestModeToggleButton;
    private FreeSizeButtonWidget requestAcceptAllButton;
    private FreeSizeButtonWidget seedTabButton;
    private MatchPresetListWidget presetListWidget;
    private int lastToggleRequestMode = 1;
    private long lastPresetDeleteTime = 0L;

    public static void makeQueue(class_310 client, class_437 parent, String targetMatchCode) {
        if (MCSRRankedClient.LOCAL_PLAYER.isSpectator()) {
            boolean result = WarningScreen.check(() -> ClientUtils.getMaxMemoryMB() < 4096L, bl -> {
                if (bl.booleanValue()) {
                    client.method_1507((class_437)new MatchPrivateRoomScreen(parent, targetMatchCode, false));
                } else {
                    client.method_1507(parent);
                }
            }, (class_2561)new class_2588("projectelo.warning.not_enough_memory", new Object[]{4096}));
            if (!result) {
                client.method_1507((class_437)new MatchPrivateRoomScreen(parent, targetMatchCode, false));
            }
        } else {
            client.method_1507((class_437)new MatchPrivateRoomScreen(parent, targetMatchCode, false));
        }
    }

    public MatchPrivateRoomScreen(class_437 parent, String targetMatchCode, boolean rejoin) {
        super(parent, (class_2561)new class_2588("projectelo.title.match_room"));
        this.targetMatchCode = targetMatchCode;
        CURRENT_STATUS = rejoin ? Status.IDLE : Status.NONE;
        SocketInstance.on("m$update", payload -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> onlineMatch.setOption(new MatchOption((SocketEvent)payload))));
        SocketInstance.on("p$pending", payload -> {
            if (!MCSRRankedClient.getOnlineMatch().isPresent()) {
                CURRENT_STATUS = Status.WAITING;
            } else {
                MCSRRankedClient.LOGGER.warn("Received pending packet but client is already in a match. Ignoring.");
            }
        });
        SocketInstance.on("m$request", payload -> {
            OnlinePlayer player = OnlinePlayer.of(payload.getNextString());
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> onlineMatch.getPendingPlayers().add(player));
            class_310 mcClient = class_310.method_1551();
            if (mcClient.field_1755 instanceof MatchPrivateRoomScreen) {
                MatchJoinRequestListWidget reqListWidget = ((MatchPrivateRoomScreen)mcClient.field_1755).matchRequestWidget;
                reqListWidget.onReceivedRequest(player);
            }
        });
        SocketInstance.on("m$request_update", payload -> {
            UUID uuid = UUIDUtils.fromString(payload.getNextString());
            JoinRequestRemoval reason = JoinRequestRemoval.values()[payload.getNextInteger()];
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                for (OnlinePlayer pendingPlayer : onlineMatch.getPendingPlayers()) {
                    if (!pendingPlayer.getUUID().equals(uuid)) continue;
                    onlineMatch.getPendingPlayers().remove(pendingPlayer);
                    return;
                }
            });
            class_310 mcClient = class_310.method_1551();
            if (mcClient.field_1755 instanceof MatchPrivateRoomScreen) {
                MatchJoinRequestListWidget reqListWidget = ((MatchPrivateRoomScreen)mcClient.field_1755).matchRequestWidget;
                reqListWidget.onRemovedRequest(uuid, reason);
            }
        });
        SocketInstance.on("m$request_update_all", payload -> {
            ArrayList uuids = Lists.newArrayList();
            for (String s : payload.getNextString().split(";")) {
                uuids.add(UUIDUtils.fromString(s));
            }
            JoinRequestRemoval reason = JoinRequestRemoval.values()[payload.getNextInteger()];
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                for (UUID uuid : uuids) {
                    for (OnlinePlayer pendingPlayer : Lists.newArrayList(onlineMatch.getPendingPlayers())) {
                        if (!pendingPlayer.getUUID().equals(uuid)) continue;
                        onlineMatch.getPendingPlayers().remove(pendingPlayer);
                    }
                }
            });
            class_310 mcClient = class_310.method_1551();
            if (mcClient.field_1755 instanceof MatchPrivateRoomScreen) {
                MatchJoinRequestListWidget reqListWidget = ((MatchPrivateRoomScreen)mcClient.field_1755).matchRequestWidget;
                reqListWidget.onRemovedAllRequest(uuids, reason);
            }
        });
        SocketInstance.on("m$twitch_list", payload -> {
            JsonObject jsonObject = new JsonParser().parse(payload.getNextString()).getAsJsonObject();
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                for (OnlinePlayer player : onlineMatch.getPlayers()) {
                    if (!jsonObject.has(player.getNickname())) continue;
                    player.setTwitchId(jsonObject.get(player.getNickname()).getAsString());
                }
            });
        });
    }

    protected void method_25426() {
        if (this.field_22787 != null) {
            this.field_22787.field_1774.method_1462(true);
        }
        if (CURRENT_STATUS == Status.NONE) {
            CURRENT_STATUS = Status.FINDING;
            SocketInstance.getInstance().emit("p$queue", MatchType.PRIVATE.getID(), this.targetMatchCode, RankedOptions.getQueueFlag().getFlagValue());
        }
        this.getPagination().setAlwaysVisibleSelects(false);
        this.initLoadingPage();
        this.initTabButtons();
        this.initMemberListPage();
        this.initOptionsPage();
        this.initFlagsPage();
        this.initMiscPage();
        this.initCategoryPage();
        this.initJoinRequestPage();
        this.initSeedPage();
        this.initPresetPage();
        this.initGameModePage();
        this.initBotPage();
    }

    private void closeOption() {
        this.getPagination().setPage(1);
        MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            String overworldSeed = onlineMatch.getOption().getOverworldSeed();
            String netherSeed = onlineMatch.getOption().getNetherSeed();
            String theEndSeed = onlineMatch.getOption().getTheEndSeed();
            String rngSeed = onlineMatch.getOption().getRNGSeed();
            SocketInstance.getInstance().emit("p$edit_room", overworldSeed == null ? null : String.valueOf(ClientUtils.getSeedFromString(overworldSeed)), netherSeed == null ? null : String.valueOf(ClientUtils.getSeedFromString(netherSeed)), theEndSeed == null ? null : String.valueOf(ClientUtils.getSeedFromString(theEndSeed)), rngSeed == null ? null : String.valueOf(ClientUtils.getSeedFromString(rngSeed)), onlineMatch.getOption().getFlag().getFlagValue(), onlineMatch.getOption().getCategory().getID(), onlineMatch.getOption().getCommand(), onlineMatch.getOption().getRoomName(), onlineMatch.getOption().getWaitingImageUrl(), onlineMatch.getOption().getCompletions(), onlineMatch.getOption().getTimeLimit(), onlineMatch.getOption().getTimeAttack(), onlineMatch.getOption().getSeedType().getFlagValue(), String.format("%s:%s", onlineMatch.getOption().getGameMode().getType(), onlineMatch.getOption().getGameMode().toDataString()), onlineMatch.getOption().isAvailableFakePlayer() ? onlineMatch.getOption().getFakePlayerLevel() : -1);
        });
    }

    public boolean method_25422() {
        return false;
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (MCSRRankedClient.getOnlineMatch().isPresent() && this.getPagination().getCurrentPage() == 0) {
            this.getPagination().setPage(1);
        }
        if (MCSRRankedClient.getOnlineMatch().isPresent() && this.getPagination().getCurrentPage() != 7) {
            OnlineMatch match2 = MCSRRankedClient.getOnlineMatch().get();
            boolean bl = this.seedTabButton.field_22763 = !match2.getOption().isSetSeed() && match2.getOption().getFlag().isEnableFlag(MatchFlag.Type.FILTERED_SEED);
        }
        if (this.getPagination().getCurrentPage() > 1 && MCSRRankedClient.getOnlineMatch().map(match -> !match.canManage()).orElse(false).booleanValue()) {
            this.getPagination().setPage(0);
        }
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    @Override
    public void method_25393() {
        OnlineMatch match;
        List<OnlinePlayer> players;
        super.method_25393();
        if (!MCSRRankedClient.getOnlineMatch().isPresent()) {
            return;
        }
        if (this.memberListWidget != null && (this.currentMemberCount != (players = (match = MCSRRankedClient.getOnlineMatch().get()).getPlayers()).size() || players.size() != this.memberListWidget.getEntryCount() || match.markAsUpdate())) {
            this.currentMemberCount = players.size();
            this.memberListWidget.updatePlayerList(players);
            match.markAsUpdate(false);
            CURRENT_STATUS = Status.IDLE;
        }
        if (this.lastToggleRequestMode > 0) {
            --this.lastToggleRequestMode;
            if (this.lastToggleRequestMode == 0) {
                this.requestModeToggleButton.field_22763 = MCSRRankedClient.getOnlineMatch().get().checkPermission(PlayerPermission::isJoinRequest, false);
            }
        }
        this.requestAcceptAllButton.method_25355((class_2561)new class_2588("projectelo.button.accept_all_requests", new Object[]{this.matchRequestWidget.method_25396().size()}));
        this.requestAcceptAllButton.field_22763 = MCSRRankedClient.getOnlineMatch().get().checkPermission(PlayerPermission::isJoinRequest, false) != false && this.lastToggleRequestMode == 0 && !this.matchRequestWidget.method_25396().isEmpty();
    }

    public void drawTitleText(class_4587 matrices, int x) {
        this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.match_room", new Object[]{MCSRRankedClient.getOnlineMatch().map(onlineMatch -> onlineMatch.getDisplayName().getString()).orElse(class_1074.method_4662((String)MatchType.PRIVATE.getKey(), (Object[])new Object[0]))}), x, 8, 0xFFFFFF);
    }

    public void initLoadingPage() {
        class_4185 cancelButton = new class_4185(this.field_22789 / 2 - 75, this.field_22790 / 2 + 60, 150, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> {
            button.field_22763 = false;
            SocketInstance.getInstance().emit("p$req_cancel", new Object[0]);
        });
        cancelButton.field_22764 = false;
        this.getPagination().addElement(0, cancelButton);
        this.getPagination().setRenderPage(0, (matrices, mouseX, mouseY, delta) -> {
            this.method_27534(matrices, this.field_22793, (class_5348)this.getRoomMessage(), this.field_22789 / 2, this.field_22790 / 2 - 6, 0xFFFFFF);
            this.renderLoadingText(matrices, this.field_22789 / 2, this.field_22790 / 2 + 5);
            this.drawTitleText(matrices, this.field_22789 / 2);
            if (CURRENT_STATUS == Status.WAITING) {
                cancelButton.field_22764 = true;
            }
        });
    }

    private void initTabButtons() {
        this.tabButtons.clear();
        FreeSizeButtonWidget optionsButton = new FreeSizeButtonWidget(0, 0, 80, 26, (class_2561)new class_2588("projectelo.button.options"), button -> this.getPagination().setPage(2));
        this.tabButtons.add(optionsButton);
        this.getPagination().setPageSelectButton(2, optionsButton);
        FreeSizeButtonWidget rulesButton = new FreeSizeButtonWidget(0, 26, 80, 26, (class_2561)new class_2588("projectelo.button.rules"), button -> this.getPagination().setPage(3));
        this.tabButtons.add(rulesButton);
        this.getPagination().setPageSelectButton(3, rulesButton);
        FreeSizeButtonWidget miscButton = new FreeSizeButtonWidget(0, 52, 80, 26, (class_2561)RankedScreenTexts.MISC.text(), button -> this.getPagination().setPage(4));
        this.tabButtons.add(miscButton);
        this.getPagination().setPageSelectButton(4, miscButton);
        FreeSizeButtonWidget categoryButton = new FreeSizeButtonWidget(0, 78, 80, 26, (class_2561)new class_2588("projectelo.button.category"), button -> this.getPagination().setPage(5));
        this.tabButtons.add(categoryButton);
        this.getPagination().setPageSelectButton(5, categoryButton);
        this.seedTabButton = new FreeSizeButtonWidget(0, 104, 80, 26, (class_2561)new class_2588("projectelo.text.match.seed"), button -> this.getPagination().setPage(7));
        this.tabButtons.add(this.seedTabButton);
        this.getPagination().setPageSelectButton(7, this.seedTabButton);
        FreeSizeButtonWidget presetButton = new FreeSizeButtonWidget(0, 182, 80, 26, (class_2561)new class_2588("projectelo.button.preset"), button -> this.getPagination().setPage(8));
        this.tabButtons.add(presetButton);
        this.getPagination().setPageSelectButton(8, presetButton);
        this.getPagination().setPageSelectButton(9, presetButton);
        FreeSizeButtonWidget gameModeButton = new FreeSizeButtonWidget(0, 130, 80, 26, (class_2561)new class_2588("projectelo.button.gameMode"), button -> this.getPagination().setPage(10));
        this.tabButtons.add(gameModeButton);
        this.getPagination().setPageSelectButton(10, gameModeButton);
        FreeSizeButtonWidget botButton = new FreeSizeButtonWidget(0, 156, 80, 26, (class_2561)new class_2588("projectelo.button.bot"), button -> this.getPagination().setPage(11));
        this.tabButtons.add(botButton);
        this.getPagination().setPageSelectButton(11, botButton);
        FreeSizeButtonWidget closeButton = new FreeSizeButtonWidget(0, this.field_22790 - 26, 80, 26, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.closeOption());
        this.tabButtons.add(closeButton);
    }

    public void initMemberListPage() {
        this.memberListWidget = new MatchRoomMemberListWidget(this.field_22787, this, null);
        this.getPagination().addElement(1, this.memberListWidget);
        final FreeSizeButtonWidget chatDisableButton = new FreeSizeButtonWidget(9, this.field_22790 - 55, 20, 20, class_2585.field_24366, button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.setChatDisabled(!match.isChatDisabled())), (button, matrices, mouseX, mouseY) -> {
            if (!MCSRRankedClient.LOCAL_PLAYER.isChatDisabled()) {
                this.setTooltip(new class_2588("projectelo.text.chat_disabled_room").method_27693(": ").method_10852((class_2561)(MCSRRankedClient.getOnlineMatch().map(OnlineMatch::isChatDisabled).orElse(false) != false ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text())));
            }
        });
        this.getPagination().addElement(1, chatDisableButton);
        MatchChatWidget matchChatWidget = new MatchChatWidget(this.field_22793, 10, this.field_22790 - 27, (int)((double)this.field_22789 / 2.0 * 0.7), this){

            @Override
            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                boolean editable = MCSRRankedClient.getOnlineMatch().map(OnlineMatch::isChatDisabled).orElse(false) == false;
                this.method_1888(editable);
                if (!editable) {
                    this.method_1852("");
                }
                if (MCSRRankedClient.LOCAL_PLAYER.isChatDisabled()) {
                    chatDisableButton.field_22763 = false;
                }
                class_310.method_1551().method_1531().method_22813(TextureUtils.DEFAULT_GUI_TEXTURE);
                RenderSystem.pushMatrix();
                if (!chatDisableButton.field_22763) {
                    RenderSystem.color3f((float)0.5f, (float)0.5f, (float)0.5f);
                }
                1.method_25293((class_4587)matrices, (int)(chatDisableButton.field_22760 + 2), (int)(chatDisableButton.field_22761 + 2), (int)16, (int)16, (float)(editable ? 32.0f : 48.0f), (float)0.0f, (int)16, (int)16, (int)128, (int)128);
                RenderSystem.popMatrix();
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        };
        this.method_20085((class_364)matchChatWidget);
        this.getPagination().addElement(1, matchChatWidget);
        long leaveButtonCooldown = System.currentTimeMillis();
        class_4185 leaveButton = new class_4185(this.field_22789 - 130, this.field_22790 - 30, 120, 20, (class_2561)new class_2588("projectelo.button.leave_room"), button -> {
            if (System.currentTimeMillis() - leaveButtonCooldown < 500L) {
                return;
            }
            button.field_22763 = false;
            this.tryLeaveRoom = true;
            SocketInstance.getInstance().emit("p$leave", new Object[0]);
        });
        this.getPagination().addElement(1, leaveButton);
        class_4185 startButton = new class_4185(this.field_22789 - 130, this.field_22790 - 55, 58, 20, (class_2561)new class_2588("projectelo.button.start"), b -> {
            if (MCSRRankedClient.getOnlineMatch().map(OnlineMatch::canManage).orElse(false).booleanValue()) {
                this.field_22791.forEach(button -> {
                    button.field_22763 = false;
                });
                SocketInstance.getInstance().emit("p$start", new Object[0]);
            }
        });
        startButton.field_22763 = false;
        this.getPagination().addElement(1, startButton);
        class_4185 optionButton = new class_4185(this.field_22789 - 68, this.field_22790 - 55, 58, 20, (class_2561)new class_2588("projectelo.button.options"), b -> this.getPagination().setPage(2));
        optionButton.field_22763 = false;
        this.getPagination().addElement(1, optionButton);
        class_4185 copyMatchCodeButton = new class_4185(this.field_22789 / 2 - 42, 28, 40, 20, (class_2561)new class_2588("projectelo.button.copy"), button -> {
            String matchCode = MCSRRankedClient.getOnlineMatch().map(OnlineMatch::getCode).orElse(null);
            if (this.field_22787 != null && matchCode != null) {
                this.field_22787.field_1774.method_1455(matchCode);
                this.field_22787.method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.toast.copied_match_code", (Object[])new Object[0])));
            }
        }, (button, matrices, mouseX, mouseY) -> this.method_25424(matrices, (class_5348)new class_2588("projectelo.tooltip.copy_match_code"), mouseX, mouseY));
        this.getPagination().addElement(1, copyMatchCodeButton);
        class_4185 toggleMatchCodeButton = new class_4185(this.field_22789 / 2 + 2, 28, 40, 20, (class_2561)new class_2588("projectelo.button.toggle"), button -> {
            if (MCSRRankedClient.getOnlineMatch().isPresent()) {
                this.matchCodeVisible = !this.matchCodeVisible;
            }
        }, (button, matrices, mouseX, mouseY) -> this.method_25424(matrices, (class_5348)new class_2588("projectelo.tooltip.toggle_match_code_visibility"), mouseX, mouseY));
        this.getPagination().addElement(1, toggleMatchCodeButton);
        FreeSizeTexturedButtonWidget joinRequestButton = new FreeSizeTexturedButtonWidget(copyMatchCodeButton.field_22760 - 20, copyMatchCodeButton.field_22761 + 4, 15, 12, 182, 24, 15, 12, class_339.field_22757, 256, 256, button -> this.getPagination().setPage(6), (button, matrices, mouseX, mouseY) -> this.setTooltip(new class_2588("projectelo.title.pending_join_requests")));
        this.getPagination().addElement(1, joinRequestButton);
        joinRequestButton.setHoveredOffset(-16, 0);
        joinRequestButton.field_22764 = false;
        FreeSizeTexturedButtonWidget replayIndicator = new FreeSizeTexturedButtonWidget(toggleMatchCodeButton.field_22760 + toggleMatchCodeButton.method_25368() + 5, toggleMatchCodeButton.field_22761 + 3, 15, 15, 182, 24, 0, 0, class_339.field_22757, 256, 256, button -> class_156.method_668().method_670("https://mcsrranked.com/store"), (button, matrices, mouseX, mouseY) -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            int minReplayLimit = onlineMatch.checkPermission(PlayerPermission::getMinPrivateRoomReplayLimit, 2);
            int maxReplayLimit = onlineMatch.checkPermission(PlayerPermission::getMaxPrivateRoomReplayLimit, 0);
            int playerCount = onlineMatch.getPlayersExcludeSpectator().size();
            ArrayList list = Lists.newArrayList((Object[])new class_2561[]{new class_2588("projectelo.tooltip.private_room_replay"), new class_2585("- ").method_10852((class_2561)new class_2588("projectelo.tooltip.players_at_least", new Object[]{minReplayLimit, playerCount})).method_27692(playerCount >= minReplayLimit ? class_124.field_1060 : class_124.field_1061), new class_2585("- ").method_10852((class_2561)new class_2588("projectelo.tooltip.players_limit", new Object[]{maxReplayLimit, playerCount})).method_27692(maxReplayLimit >= playerCount ? class_124.field_1060 : class_124.field_1061), new class_2588("projectelo.tooltip.check_store_page").method_27692(class_124.field_1054)});
            this.setTooltip(list);
        }));
        this.getPagination().addElement(1, replayIndicator);
        this.getPagination().setRenderPage(1, (matrices, mouseX, mouseY, delta) -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            if (this.matchRequestWidget.hasNewRequest()) {
                RenderUtils.drawOutlineText(this.field_22793, matrices, (class_2561)new class_2585("!").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}), joinRequestButton.field_22760, joinRequestButton.field_22761);
            }
            if (onlineMatch.isHost()) {
                int playerCount;
                int minReplayLimit = onlineMatch.checkPermission(PlayerPermission::getMinPrivateRoomReplayLimit, 2);
                int maxReplayLimit = onlineMatch.checkPermission(PlayerPermission::getMaxPrivateRoomReplayLimit, 0);
                boolean isActivated = maxReplayLimit >= (playerCount = onlineMatch.getPlayersExcludeSpectator().size()) && playerCount >= minReplayLimit;
                this.getClient().method_1531().method_22813(class_339.field_22757);
                MatchPrivateRoomScreen.method_25290((class_4587)matrices, (int)replayIndicator.field_22760, (int)replayIndicator.field_22761, (float)(isActivated ? 192 : 224), (float)0.0f, (int)15, (int)15, (int)256, (int)256);
            }
            String matchCode = onlineMatch.getCode();
            class_5250 matchCodeText = new class_2585(this.matchCodeVisible ? matchCode : "<" + class_1074.method_4662((String)"projectelo.button.hidden", (Object[])new Object[0]) + ">").method_27692(class_124.field_1073);
            matchCodeText = new class_2588("projectelo.text.match_code").method_10852((class_2561)matchCodeText);
            this.method_27534(matrices, this.field_22793, (class_5348)matchCodeText, this.field_22789 / 2, 17, 0xFFFFFF);
            if (!onlineMatch.canManage() || onlineMatch.getStatus().isPreparing()) {
                this.renderLoadingText(matrices, this.field_22789 / 2, this.field_22790 - 40);
                this.method_27534(matrices, this.field_22793, (class_5348)this.getRoomMessage(), this.field_22789 / 2, this.field_22790 - 50, 0xFFFFFF);
            } else if (onlineMatch.canManage() || MCSRRankedClient.LOCAL_PLAYER.isSpectator()) {
                int spectators = onlineMatch.getSpectators().size();
                int matchPlayers = onlineMatch.getPlayersExcludeSpectator().size();
                this.renderLoadingText(matrices, this.field_22789 / 2, this.field_22790 - 40);
                this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.match.match_players").method_27693(": ").method_10852((class_2561)(spectators == 0 ? class_2585.field_24366 : new class_2585("").method_10852((class_2561)new class_2585(String.valueOf(spectators)).method_27692(class_124.field_1060)).method_27693("/"))).method_10852((class_2561)new class_2585(String.valueOf(matchPlayers)).method_27692(class_124.field_1054)).method_27693("/").method_10852((class_2561)new class_2585(String.valueOf(onlineMatch.getMaxPlayers())).method_27692(class_124.field_1075)), this.field_22789 / 2, this.field_22790 - 50, 0xFFFFFF);
            }
            this.drawTitleText(matrices, this.field_22789 / 2);
        }));
        this.getPagination().setPreRenderPage(1, (matrices, mouseX, mouseY, delta) -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            optionButton.field_22763 = false;
            startButton.field_22763 = false;
            if (onlineMatch.canManage()) {
                boolean bl = startButton.field_22763 = onlineMatch.isReadyToStart() && !onlineMatch.getStatus().isPreparing();
                if (startButton.field_22760 <= mouseX && startButton.field_22760 + startButton.method_25368() > mouseX && startButton.field_22761 <= mouseY && startButton.field_22761 + startButton.method_25364() > mouseY && onlineMatch.getStatus() == MatchStatus.IDLE && !onlineMatch.isReadyToStart() && onlineMatch.getPlayers().size() < 2 && !MCSRRankedClient.PLAYER_PERMISSION.canPrivateRoomSinglePlay()) {
                    this.setTooltipWithWrap(new class_2588("projectelo.text.available_tier.single_play").method_27692(class_124.field_1061), 200);
                }
                optionButton.field_22763 = !onlineMatch.getStatus().isPreparing();
            }
            leaveButton.field_22763 = MCSRRankedClient.getOnlineMatch().map(matchInfo -> matchInfo.getStatus().isPreparing()).orElse(false) == false && !this.tryLeaveRoom;
            joinRequestButton.field_22764 = onlineMatch.canManage() && !onlineMatch.getStatus().isPreparing();
        }));
    }

    public void initOptionsPage() {
        for (class_4185 tabButton : this.tabButtons) {
            this.getPagination().addElement(2, tabButton);
        }
        class_5250 completionsText = new class_2588("projectelo.text.completion_percentage").method_27693(": ").method_27692(class_124.field_1075);
        int completionsTextWidth = this.field_22793.method_27525((class_5348)completionsText);
        int n = (this.field_22789 + completionsTextWidth + 86 - 30) / 2;
        Objects.requireNonNull(this.field_22793);
        class_342 completionsField = new class_342(this.field_22793, n, 45, 30, 9 + 5, class_2585.field_24366){

            public int method_1859() {
                return this.method_25368() + 3;
            }
        };
        completionsField.method_1880(3);
        completionsField.method_1890(string -> {
            if (string.isEmpty()) {
                return true;
            }
            try {
                int i = Integer.parseInt(string);
                return i >= 0 && i <= 100;
            }
            catch (Throwable e) {
                return false;
            }
        });
        completionsField.method_1863(text -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            try {
                int i = Integer.parseInt(text);
                if (text.startsWith("0") && text.length() > 1) {
                    completionsField.method_1852(text.substring(1));
                }
                onlineMatch.getOption().setCompletions(i);
            }
            catch (Throwable ignored) {
                onlineMatch.getOption().setCompletions(0);
            }
        }));
        this.getPagination().addElement(2, completionsField);
        class_5250 overworldSeedText = new class_2588("projectelo.text.insert_seed").method_27693(" (" + class_1074.method_4662((String)"createWorld.customize.preset.overworld", (Object[])new Object[0]) + ")").method_27693(": ").method_27692(class_124.field_1075);
        int overworldSeedTextWidth = this.field_22793.method_27525((class_5348)overworldSeedText);
        class_5250 netherSeedText = new class_2588("projectelo.text.insert_seed").method_27693(" (" + class_1074.method_4662((String)"advancements.nether.root.title", (Object[])new Object[0]) + ")").method_27693(": ").method_27692(class_124.field_1075);
        int netherSeedTextWidth = this.field_22793.method_27525((class_5348)netherSeedText);
        class_5250 theEndSeedText = new class_2588("projectelo.text.insert_seed").method_27693(" (" + class_1074.method_4662((String)"biome.minecraft.the_end", (Object[])new Object[0]) + ")").method_27693(": ").method_27692(class_124.field_1075);
        int theEndSeedTextWidth = this.field_22793.method_27525((class_5348)theEndSeedText);
        class_5250 rngSeedText = new class_2585("RNG Seed: ").method_27692(class_124.field_1075);
        int rngSeedTextWidth = this.field_22793.method_27525((class_5348)rngSeedText);
        int seedFieldWidth = 140;
        int maxSeedTextWidth = Math.max(overworldSeedTextWidth, Math.max(netherSeedTextWidth, Math.max(theEndSeedTextWidth, rngSeedTextWidth)));
        int n2 = (this.field_22789 + maxSeedTextWidth + 86 - seedFieldWidth) / 2;
        Objects.requireNonNull(this.field_22793);
        class_342 overworldSeedField = new class_342(this.field_22793, n2, 119, seedFieldWidth, 9 + 5, class_2585.field_24366){

            public int method_1859() {
                return this.method_25368() + 3;
            }
        };
        overworldSeedField.method_1880(32);
        overworldSeedField.method_1863(text -> {
            overworldSeedField.method_1887(text.isEmpty() ? "..." : "");
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> onlineMatch.getOption().setOverworldSeed((String)text));
        });
        this.getPagination().addElement(2, overworldSeedField);
        int n3 = (this.field_22789 + maxSeedTextWidth + 86 - seedFieldWidth) / 2;
        Objects.requireNonNull(this.field_22793);
        class_342 netherSeedField = new class_342(this.field_22793, n3, 139, seedFieldWidth, 9 + 5, class_2585.field_24366){

            public int method_1859() {
                return this.method_25368() + 3;
            }
        };
        netherSeedField.method_1880(32);
        netherSeedField.method_1863(text -> {
            netherSeedField.method_1887(text.isEmpty() ? "..." : "");
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> onlineMatch.getOption().setNetherSeed((String)text));
        });
        this.getPagination().addElement(2, netherSeedField);
        int n4 = (this.field_22789 + maxSeedTextWidth + 86 - seedFieldWidth) / 2;
        Objects.requireNonNull(this.field_22793);
        class_342 theEndSeedField = new class_342(this.field_22793, n4, 159, seedFieldWidth, 9 + 5, class_2585.field_24366){

            public int method_1859() {
                return this.method_25368() + 3;
            }
        };
        theEndSeedField.method_1880(32);
        theEndSeedField.method_1863(text -> {
            theEndSeedField.method_1887(text.isEmpty() ? "..." : "");
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> onlineMatch.getOption().setTheEndSeed((String)text));
        });
        this.getPagination().addElement(2, theEndSeedField);
        int n5 = (this.field_22789 + maxSeedTextWidth + 86 - seedFieldWidth) / 2;
        Objects.requireNonNull(this.field_22793);
        class_342 rngSeedField = new class_342(this.field_22793, n5, 179, seedFieldWidth, 9 + 5, class_2585.field_24366){

            public int method_1859() {
                return this.method_25368() + 3;
            }
        };
        rngSeedField.method_1880(32);
        rngSeedField.method_1863(text -> {
            rngSeedField.method_1887(text.isEmpty() ? "..." : "");
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> onlineMatch.getOption().setRNGSeed((String)text));
        });
        this.getPagination().addElement(2, rngSeedField);
        class_4185 loadOptionsButton = new class_4185((this.field_22789 + 80) / 2 - 100, this.field_22790 - 30, 200, 20, (class_2561)new class_2588("projectelo.button.load_all_from_match"), button -> {
            if (MCSRRankedClient.getOnlineMatch().isPresent() && MCSRRankedClient.LAST_MATCH_OPTION != null) {
                MCSRRankedClient.getOnlineMatch().get().setOption(MCSRRankedClient.LAST_MATCH_OPTION);
            }
            button.field_22763 = false;
        });
        this.getPagination().addElement(2, loadOptionsButton);
        this.getPagination().setPageChangeListener(2, () -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            loadOptionsButton.field_22763 = MCSRRankedClient.LAST_MATCH_OPTION != null;
            completionsField.method_1852(String.valueOf(onlineMatch.getOption().getCompletions()));
            String overworldSeed = onlineMatch.getOption().getOverworldSeed();
            overworldSeedField.method_1852(overworldSeed == null ? "" : overworldSeed);
            String netherSeed = onlineMatch.getOption().getNetherSeed();
            netherSeedField.method_1852(netherSeed == null ? "" : netherSeed);
            String theEndSeed = onlineMatch.getOption().getTheEndSeed();
            theEndSeedField.method_1852(theEndSeed == null ? "" : theEndSeed);
            String rngSeed = onlineMatch.getOption().getRNGSeed();
            rngSeedField.method_1852(rngSeed == null ? "" : rngSeed);
        }));
        this.getPagination().setRenderPage(2, (arg_0, arg_1, arg_2, arg_3) -> this.lambda$initOptionsPage$63(completionsField, (class_2561)completionsText, completionsTextWidth, (class_2561)overworldSeedText, overworldSeedField, maxSeedTextWidth, (class_2561)netherSeedText, netherSeedField, (class_2561)theEndSeedText, theEndSeedField, (class_2561)rngSeedText, rngSeedField, arg_0, arg_1, arg_2, arg_3));
    }

    public void initFlagsPage() {
        MatchOptionListWidget matchFlagsWidget = new MatchOptionListWidget(this.field_22787, this, MCSRRankedClient.getOnlineMatch().orElse(null), true);
        this.getPagination().addElement(3, matchFlagsWidget);
        for (class_4185 tabButton : this.tabButtons) {
            this.getPagination().addElement(3, tabButton);
        }
        this.getPagination().setPageChangeListener(3, () -> {
            matchFlagsWidget.method_25307(0.0);
            matchFlagsWidget.updateEntries(MCSRRankedClient.getOnlineMatch().orElse(null));
        });
        this.getPagination().setRenderPage(3, (matrices, mouseX, mouseY, delta) -> {
            Optional<class_364> hoveredElement = matchFlagsWidget.method_19355(mouseX, mouseY);
            if (hoveredElement.isPresent() && hoveredElement.get() instanceof MatchOptionListWidget.ToolTipEntry) {
                List tooltips = this.field_22793.method_1728((class_5348)((MatchOptionListWidget.ToolTipEntry)hoveredElement.get()).getTooltip(), (int)((double)this.field_22789 * 0.8));
                this.setTooltip(tooltips, this.field_22789 / 10, this.field_22790 - tooltips.size() * 10);
            }
            this.drawTitleText(matrices, (this.field_22789 + 80) / 2);
        });
    }

    public void initMiscPage() {
        MatchOptionListWidget matchMiscOptionsWidget = new MatchOptionListWidget(this.field_22787, this, MCSRRankedClient.getOnlineMatch().orElse(null), false);
        this.getPagination().addElement(4, matchMiscOptionsWidget);
        for (class_4185 tabButton : this.tabButtons) {
            this.getPagination().addElement(4, tabButton);
        }
        this.getPagination().setPageChangeListener(4, () -> {
            matchMiscOptionsWidget.method_25307(0.0);
            matchMiscOptionsWidget.updateEntries(MCSRRankedClient.getOnlineMatch().orElse(null));
        });
        this.getPagination().setRenderPage(4, (matrices, mouseX, mouseY, delta) -> {
            Optional<class_364> hoveredElement = matchMiscOptionsWidget.method_19355(mouseX, mouseY);
            if (hoveredElement.isPresent() && hoveredElement.get() instanceof MatchOptionListWidget.ToolTipEntry) {
                List tooltips = this.field_22793.method_1728((class_5348)((MatchOptionListWidget.ToolTipEntry)hoveredElement.get()).getTooltip(), (int)((double)this.field_22789 * 0.8));
                this.setTooltip(tooltips, this.field_22789 / 10, this.field_22790 - tooltips.size() * 10);
            }
            this.drawTitleText(matrices, (this.field_22789 + 80) / 2);
        });
    }

    public void initCategoryPage() {
        MatchCategoryListWidget matchCategoryWidget = new MatchCategoryListWidget(this.field_22787, this, null);
        this.getPagination().addElement(5, matchCategoryWidget);
        for (class_4185 tabButton : this.tabButtons) {
            this.getPagination().addElement(5, tabButton);
        }
        this.getPagination().setPageChangeListener(5, () -> {
            matchCategoryWidget.method_25307(0.0);
            matchCategoryWidget.updateMatchInfo(MCSRRankedClient.getOnlineMatch().orElse(null));
        });
        this.getPagination().setRenderPage(5, (matrices, mouseX, mouseY, delta) -> this.drawTitleText(matrices, (this.field_22789 + 80) / 2));
    }

    public void initJoinRequestPage() {
        this.matchRequestWidget = new MatchJoinRequestListWidget(this.field_22787, this);
        this.getPagination().addElement(6, this.matchRequestWidget);
        this.getPagination().addElement(6, new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 25, 200, 20, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.getPagination().setPage(1)));
        Supplier<class_2561> requestModeText = () -> new class_2588("projectelo.button.join_request_mode").method_27693(": ").method_10852((class_2561)(MCSRRankedClient.getOnlineMatch().map(OnlineMatch::isJoinRequest).orElse(false) != false ? RankedScreenTexts.ON.text().method_27692(class_124.field_1060) : RankedScreenTexts.OFF.text().method_27692(class_124.field_1061)));
        this.requestModeToggleButton = new FreeSizeButtonWidget(this.field_22789 / 2 - 152, 26, 150, 20, requestModeText.get(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> this.lambda$initJoinRequestPage$72(button, (Supplier)requestModeText, arg_0)));
        this.getPagination().addElement(6, this.requestModeToggleButton);
        this.requestAcceptAllButton = new FreeSizeButtonWidget(this.field_22789 / 2 + 2, 26, 150, 20, class_2585.field_24366, button -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            button.field_22763 = false;
            this.requestModeToggleButton.field_22763 = false;
            this.matchRequestWidget.acceptAll();
            this.lastToggleRequestMode = 60;
        }));
        this.getPagination().addElement(6, this.requestAcceptAllButton);
        this.getPagination().setPreRenderPage(6, (matrices, mouseX, mouseY, delta) -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> {
            block0: for (OnlinePlayer pendingPlayer : match.getPendingPlayers()) {
                for (MatchJoinRequestListWidget.Entry child : this.matchRequestWidget.method_25396()) {
                    if (!child.onlinePlayer.equals(pendingPlayer)) continue;
                    continue block0;
                }
                this.matchRequestWidget.onReceivedRequest(pendingPlayer);
            }
        }));
        this.getPagination().setRenderPage(6, (matrices, mouseX, mouseY, delta) -> {
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.title.pending_join_requests"), this.field_22789 / 2, 12, 0xFFFFFF);
            if (!MCSRRankedClient.getOnlineMatch().map(match -> match.checkPermission(PlayerPermission::isJoinRequest, false)).orElse(false).booleanValue()) {
                this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.available_tier", new Object[]{"Diamond Pickaxe"}).method_27692(class_124.field_1061), this.field_22789 / 2, this.requestModeToggleButton.field_22761 + 34, 0xFFFFFF);
            }
        });
    }

    private void initSeedPage() {
        int centerX = (this.field_22789 + 80) / 2;
        for (class_4185 tabButton : this.tabButtons) {
            this.getPagination().addElement(7, tabButton);
        }
        FreeSizeButtonWidget buriedTreasure = this.getPagination().addElement(7, new FreeSizeButtonWidget(centerX - 75, 60, 150, 25, class_2585.field_24366, button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().getSeedType().updateValue(0, !match.getOption().getSeedType().includeValue(0)))));
        FreeSizeButtonWidget shipwreck = this.getPagination().addElement(7, new FreeSizeButtonWidget(centerX - 75, 85, 150, 25, class_2585.field_24366, button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().getSeedType().updateValue(1, !match.getOption().getSeedType().includeValue(1)))));
        FreeSizeButtonWidget village = this.getPagination().addElement(7, new FreeSizeButtonWidget(centerX - 75, 110, 150, 25, class_2585.field_24366, button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().getSeedType().updateValue(2, !match.getOption().getSeedType().includeValue(2)))));
        FreeSizeButtonWidget ruinedPortal = this.getPagination().addElement(7, new FreeSizeButtonWidget(centerX - 75, 135, 150, 25, class_2585.field_24366, button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().getSeedType().updateValue(3, !match.getOption().getSeedType().includeValue(3)))));
        FreeSizeButtonWidget desertTemple = this.getPagination().addElement(7, new FreeSizeButtonWidget(centerX - 75, 160, 150, 25, class_2585.field_24366, button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().getSeedType().updateValue(4, !match.getOption().getSeedType().includeValue(4)))));
        this.getPagination().setPreRenderPage(7, (matrices, mouseX, mouseY, delta) -> {
            buriedTreasure.method_25355((class_2561)new class_2588("projectelo.seed_structure_type.buried_treasure").method_27693(" : ").method_10852((class_2561)(MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getSeedType().includeValue(0)).orElse(false) != false ? new class_2585(class_1074.method_4662((String)"options.on", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}) : new class_2585(class_1074.method_4662((String)"options.off", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}))));
            shipwreck.method_25355((class_2561)new class_2588("projectelo.seed_structure_type.shipwreck").method_27693(" : ").method_10852((class_2561)(MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getSeedType().includeValue(1)).orElse(false) != false ? new class_2585(class_1074.method_4662((String)"options.on", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}) : new class_2585(class_1074.method_4662((String)"options.off", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}))));
            village.method_25355((class_2561)new class_2588("projectelo.seed_structure_type.village").method_27693(" : ").method_10852((class_2561)(MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getSeedType().includeValue(2)).orElse(false) != false ? new class_2585(class_1074.method_4662((String)"options.on", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}) : new class_2585(class_1074.method_4662((String)"options.off", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}))));
            ruinedPortal.method_25355((class_2561)new class_2588("projectelo.seed_structure_type.ruined_portal").method_27693(" : ").method_10852((class_2561)(MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getSeedType().includeValue(3)).orElse(false) != false ? new class_2585(class_1074.method_4662((String)"options.on", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}) : new class_2585(class_1074.method_4662((String)"options.off", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}))));
            desertTemple.method_25355((class_2561)new class_2588("projectelo.seed_structure_type.desert_temple").method_27693(" : ").method_10852((class_2561)(MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getSeedType().includeValue(4)).orElse(false) != false ? new class_2585(class_1074.method_4662((String)"options.on", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}) : new class_2585(class_1074.method_4662((String)"options.off", (Object[])new Object[0])).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}))));
            if (!MCSRRankedClient.getOnlineMatch().map(match -> match.checkPermission(PlayerPermission::isCustomSeedType, false)).orElse(false).booleanValue()) {
                desertTemple.field_22763 = false;
                ruinedPortal.field_22763 = false;
                village.field_22763 = false;
                shipwreck.field_22763 = false;
                buriedTreasure.field_22763 = false;
            }
        });
        this.getPagination().setRenderPage(7, (matrices, mouseX, mouseY, delta) -> {
            this.drawTitleText(matrices, centerX);
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.seed_type"), centerX, 48, 0xFFFFFF);
            if (MCSRRankedClient.getOnlineMatch().map(match -> match.checkPermission(PlayerPermission::isCustomSeedType, false) == false).orElse(false).booleanValue()) {
                List lines = this.field_22793.method_1728((class_5348)new class_2588("projectelo.text.available_tier", new Object[]{"Stone Pickaxe"}).method_27692(class_124.field_1061), (int)((float)this.field_22789 * 0.7f));
                for (int i = 0; i < lines.size(); ++i) {
                    this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)lines.get(i), centerX, 200 + i * 10, 0xFFFFFF);
                }
            }
        });
    }

    public void initPresetPage() {
        int centerX = (this.field_22789 + 80) / 2;
        for (class_4185 tabButton : this.tabButtons) {
            this.getPagination().addElement(8, tabButton);
            this.getPagination().addElement(9, tabButton);
        }
        this.presetListWidget = new MatchPresetListWidget(this.field_22787, this);
        this.getPagination().addElement(8, this.presetListWidget);
        this.getPagination().addElement(9, this.presetListWidget);
        this.getPagination().addElement(8, new FreeSizeButtonWidget(centerX - 125, this.field_22790 - 30, 60, 25, (class_2561)new class_2588("projectelo.button.import"), button -> this.presetListWidget.tryImport()));
        this.getPagination().addElement(8, new FreeSizeButtonWidget(centerX - 65, this.field_22790 - 30, 60, 25, (class_2561)new class_2588("projectelo.button.export"), button -> this.getPagination().setPage(9)));
        class_4185 deleteButton = this.getPagination().addElement(8, new FreeSizeButtonWidget(centerX + 5, this.field_22790 - 30, 60, 25, (class_2561)new class_2588("projectelo.button.delete"), button -> {
            if (System.currentTimeMillis() - this.lastPresetDeleteTime < 3000L) {
                this.presetListWidget.deleteFromPresets();
            }
            this.lastPresetDeleteTime = System.currentTimeMillis();
        }, (button, matrices, mouseX, mouseY) -> {
            if (System.currentTimeMillis() - this.lastPresetDeleteTime < 3000L) {
                this.setTooltip(new class_2588("projectelo.text.confirm_delete_click_twice"));
            }
        }));
        deleteButton.field_22763 = false;
        class_4185 applyButton = this.getPagination().addElement(8, new FreeSizeButtonWidget(centerX + 65, this.field_22790 - 30, 60, 25, (class_2561)new class_2588("projectelo.button.apply"), button -> this.presetListWidget.apply()));
        this.getPagination().addElement(9, new FreeSizeButtonWidget(centerX + 65, this.field_22790 - 30, 60, 25, (class_2561)RankedScreenTexts.CANCEL.text(), button -> this.getPagination().setPage(8)));
        class_342 presetNameField = this.getPagination().addElement(9, new class_342(this.field_22793, centerX - 125, this.field_22790 - 29, 120, 22, class_2585.field_24366));
        class_4185 saveButton = this.getPagination().addElement(9, new FreeSizeButtonWidget(centerX + 5, this.field_22790 - 30, 60, 25, (class_2561)new class_2588("projectelo.button.export"), button -> {
            this.presetListWidget.tryExport(presetNameField.method_1882());
            this.getPagination().setPage(8);
            presetNameField.method_1852("");
            button.field_22763 = false;
        }));
        saveButton.field_22763 = false;
        presetNameField.method_1887("My Preset Name...");
        presetNameField.method_1880(64);
        presetNameField.method_1863(text -> {
            saveButton.field_22763 = this.presetListWidget.checkName(text.trim()) != null;
            presetNameField.method_1887(text.isEmpty() ? "My Preset Name..." : "");
        });
        this.getPagination().setPreRenderPage(8, (matrices, mouseX, mouseY, delta) -> {
            MatchPresetListWidget.MatchPresetEntry selected = (MatchPresetListWidget.MatchPresetEntry)this.presetListWidget.method_25334();
            deleteButton.field_22763 = selected != null;
            applyButton.field_22763 = selected != null;
        });
        this.getPagination().setRenderPage(8, (matrices, mouseX, mouseY, delta) -> this.drawTitleText(matrices, centerX));
        this.getPagination().setRenderPage(9, (matrices, mouseX, mouseY, delta) -> this.drawTitleText(matrices, centerX));
    }

    public void initGameModePage() {
        int centerX = (this.field_22789 + 80) / 2;
        for (class_4185 tabButton : this.tabButtons) {
            this.getPagination().addElement(10, tabButton);
        }
        class_5250 freeScoutText = new class_2588("projectelo.text.free_toggle_scout").method_27693(": ");
        class_5250 scoutTimeText = new class_2588("projectelo.text.scouting_time_limit").method_27693(" (").method_10852((class_2561)new class_2588("projectelo.text.time_format")).method_27693("): ");
        class_5250 scoutCommandText = new class_2588("projectelo.text.enable_commands").method_27693(": ");
        class_5250 scoutSeedText = new class_2588("projectelo.text.enable_seed").method_27693(": ");
        class_5250 multipleCompletionText = new class_2588("projectelo.text.allow_multiple_completions").method_27693(": ");
        class_5250 resetTimerText = new class_2588("projectelo.text.reset_timer_on_world_reset").method_27693(": ");
        int scoutMaxTextWidth = Lists.newArrayList((Object[])new Integer[]{this.field_22793.method_27525((class_5348)freeScoutText), this.field_22793.method_27525((class_5348)scoutTimeText) + 12, this.field_22793.method_27525((class_5348)scoutCommandText), this.field_22793.method_27525((class_5348)scoutSeedText), this.field_22793.method_27525((class_5348)multipleCompletionText), this.field_22793.method_27525((class_5348)resetTimerText)}).stream().max(Integer::compareTo).orElse(100);
        int n = (this.field_22789 + scoutMaxTextWidth + 86 - 30) / 2 - 12;
        Objects.requireNonNull(this.field_22793);
        TimeFormatFieldWidget scoutTimeField = new TimeFormatFieldWidget(this.field_22793, n, 103, 42, 9 + 5, seconds -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            if (onlineMatch.getOption().getGameMode() instanceof ScoutRouteGameMode) {
                ((ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).setScoutTime(seconds != null ? seconds : 0);
            }
        })){

            public int method_1859() {
                return this.method_25368() + 3;
            }
        };
        this.getPagination().addElement(10, scoutTimeField);
        Supplier<class_2561> freeScoutButtonText = () -> MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getGameMode() instanceof ScoutRouteGameMode && ((ScoutRouteGameMode)match.getOption().getGameMode()).isEnableFreeScout()).orElse(false) != false ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text();
        FreeSizeButtonWidget freeScoutButton = this.getPagination().addElement(10, new FreeSizeButtonWidget((this.field_22789 + scoutMaxTextWidth + 86 - 30) / 2, 74, 30, 20, freeScoutButtonText.get(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> MatchPrivateRoomScreen.lambda$initGameModePage$114(scoutTimeField, button, (Supplier)freeScoutButtonText, arg_0))));
        Supplier<class_2561> scoutCommandButtonText = () -> MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getGameMode() instanceof ScoutRouteGameMode && ((ScoutRouteGameMode)match.getOption().getGameMode()).isEnableCheat()).orElse(false) != false ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text();
        FreeSizeButtonWidget scoutCommandButton = this.getPagination().addElement(10, new FreeSizeButtonWidget((this.field_22789 + scoutMaxTextWidth + 86 - 30) / 2, 126, 30, 20, scoutCommandButtonText.get(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> MatchPrivateRoomScreen.lambda$initGameModePage$118(button, (Supplier)scoutCommandButtonText, arg_0))));
        Supplier<class_2561> scoutSeedButtonText = () -> MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getGameMode() instanceof ScoutRouteGameMode && ((ScoutRouteGameMode)match.getOption().getGameMode()).isEnableSeed()).orElse(false) != false ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text();
        FreeSizeButtonWidget scoutSeedButton = this.getPagination().addElement(10, new FreeSizeButtonWidget((this.field_22789 + scoutMaxTextWidth + 86 - 30) / 2, 152, 30, 20, scoutSeedButtonText.get(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> MatchPrivateRoomScreen.lambda$initGameModePage$122(button, (Supplier)scoutSeedButtonText, arg_0))));
        Supplier<class_2561> resetTimerButtonText = () -> MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getGameMode() instanceof ScoutRouteGameMode && ((ScoutRouteGameMode)match.getOption().getGameMode()).shouldResetTimer()).orElse(false) != false ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text();
        FreeSizeButtonWidget resetTimerButton = this.getPagination().addElement(10, new FreeSizeButtonWidget((this.field_22789 + scoutMaxTextWidth + 86 - 30) / 2, 204, 30, 20, resetTimerButtonText.get(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> MatchPrivateRoomScreen.lambda$initGameModePage$126(button, (Supplier)resetTimerButtonText, arg_0))));
        Supplier<class_2561> multipleCompletionButtonText = () -> MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getGameMode() instanceof ScoutRouteGameMode && ((ScoutRouteGameMode)match.getOption().getGameMode()).isAllowMultipleCompletions()).orElse(false) != false ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text();
        FreeSizeButtonWidget multipleCompletionButton = this.getPagination().addElement(10, new FreeSizeButtonWidget((this.field_22789 + scoutMaxTextWidth + 86 - 30) / 2, 178, 30, 20, multipleCompletionButtonText.get(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> MatchPrivateRoomScreen.lambda$initGameModePage$130(resetTimerButton, button, (Supplier)multipleCompletionButtonText, arg_0)), (button, matrices, mouseX, mouseY) -> this.setTooltipWithWrap(new class_2588("projectelo.text.allow_multiple_completions.description"), 300)));
        class_5250 mostEliminateTimeText = new class_2588("projectelo.text.eliminate_time").method_27693(" (").method_10852((class_2561)new class_2588("projectelo.text.time_format")).method_27693("): ");
        class_5250 mostEliminatePlayersText = new class_2588("projectelo.text.eliminate_players").method_27693(": ");
        class_5250 mostResetScoreText = new class_2588("projectelo.text.reset_score").method_27693(": ");
        class_5250 mostDisplayScoreText = new class_2588("projectelo.text.display_score").method_27693(": ");
        int mostMaxTextWidth = Lists.newArrayList((Object[])new Integer[]{this.field_22793.method_27525((class_5348)mostEliminateTimeText) + 12, this.field_22793.method_27525((class_5348)mostEliminatePlayersText), this.field_22793.method_27525((class_5348)mostResetScoreText), this.field_22793.method_27525((class_5348)mostDisplayScoreText)}).stream().max(Integer::compareTo).orElse(100);
        int n2 = (this.field_22789 + mostMaxTextWidth + 86 - 30) / 2 - 12;
        Objects.requireNonNull(this.field_22793);
        TimeFormatFieldWidget mostEliminateTimeField = new TimeFormatFieldWidget(this.field_22793, n2, 77, 42, 9 + 5, second -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
                ((MostPercentGameMode)onlineMatch.getOption().getGameMode()).setEliminationTime(second != null ? second : 0);
            }
        })){

            public int method_1859() {
                return this.method_25368() + 3;
            }
        };
        this.getPagination().addElement(10, mostEliminateTimeField);
        class_342 mostEliminatePlayersField = this.createMostEliminatePlayersField(mostMaxTextWidth);
        this.getPagination().addElement(10, mostEliminatePlayersField);
        Supplier<class_2561> mostResetButtonText = () -> MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getGameMode() instanceof MostPercentGameMode && ((MostPercentGameMode)match.getOption().getGameMode()).isEnableResetScore()).orElse(false) != false ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text();
        FreeSizeButtonWidget mostResetButton = this.getPagination().addElement(10, new FreeSizeButtonWidget((this.field_22789 + mostMaxTextWidth + 86 - 30) / 2, 126, 30, 20, mostResetButtonText.get(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> MatchPrivateRoomScreen.lambda$initGameModePage$137(button, (Supplier)mostResetButtonText, arg_0))));
        Supplier<class_2561> mostDisplayButtonText = () -> MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().getGameMode() instanceof MostPercentGameMode && ((MostPercentGameMode)match.getOption().getGameMode()).isEnableDisplayScore()).orElse(false) != false ? RankedScreenTexts.ON.text() : RankedScreenTexts.OFF.text();
        FreeSizeButtonWidget mostDisplayButton = this.getPagination().addElement(10, new FreeSizeButtonWidget((this.field_22789 + mostMaxTextWidth + 86 - 30) / 2, 152, 30, 20, mostDisplayButtonText.get(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> MatchPrivateRoomScreen.lambda$initGameModePage$141(button, (Supplier)mostDisplayButtonText, arg_0))));
        Runnable refreshWidgets = () -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> MatchPrivateRoomScreen.lambda$initGameModePage$143(freeScoutButton, scoutTimeField, scoutCommandButton, scoutSeedButton, multipleCompletionButton, resetTimerButton, mostEliminateTimeField, mostEliminatePlayersField, mostResetButton, mostDisplayButton, (Supplier)freeScoutButtonText, (Supplier)scoutCommandButtonText, (Supplier)scoutSeedButtonText, (Supplier)multipleCompletionButtonText, (Supplier)resetTimerButtonText, (Supplier)mostResetButtonText, (Supplier)mostDisplayButtonText, arg_0));
        Supplier<class_2561> gameModeText = () -> new class_2588("projectelo.button.gameMode").method_27693(" : ").method_10852((class_2561)new class_2588(MCSRRankedClient.getOnlineMatch().map(match -> "projectelo.text.gamemode." + match.getOption().getGameMode().getType()).orElse("")).method_27692(class_124.field_1054));
        FreeSizeButtonWidget gameModeButton = this.getPagination().addElement(10, new FreeSizeButtonWidget(centerX - 100, 40, 200, 24, gameModeText.get(), button -> {
            MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().setGameMode(GameMode.nextGameMode(match.getOption().getGameMode())));
            button.method_25355((class_2561)gameModeText.get());
            refreshWidgets.run();
        }));
        this.getPagination().setPageChangeListener(10, () -> MCSRRankedClient.getOnlineMatch().ifPresent(arg_0 -> MatchPrivateRoomScreen.lambda$initGameModePage$149(refreshWidgets, gameModeButton, (Supplier)gameModeText, arg_0)));
        this.getPagination().setRenderPage(10, (matrices, mouseX, mouseY, delta) -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            this.drawTitleText(matrices, centerX);
            if (onlineMatch.getOption().getGameMode() instanceof ScoutRouteGameMode) {
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(freeScoutText.getString()).method_27692(class_124.field_1075), freeScoutButton.field_22760 - scoutMaxTextWidth - 8, freeScoutButton.field_22761 + 6, 0xFFFFFF);
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(scoutTimeText.getString()).method_27692(scoutTimeField.method_20316() ? class_124.field_1075 : class_124.field_1080), scoutTimeField.field_22760 + 12 - scoutMaxTextWidth - 8, scoutTimeField.field_22761 + 3, 0xFFFFFF);
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(scoutCommandText.getString()).method_27692(class_124.field_1075), scoutCommandButton.field_22760 - scoutMaxTextWidth - 8, scoutCommandButton.field_22761 + 6, 0xFFFFFF);
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(scoutSeedText.getString()).method_27692(class_124.field_1075), scoutSeedButton.field_22760 - scoutMaxTextWidth - 8, scoutSeedButton.field_22761 + 6, 0xFFFFFF);
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(multipleCompletionText.getString()).method_27692(class_124.field_1075), multipleCompletionButton.field_22760 - scoutMaxTextWidth - 8, multipleCompletionButton.field_22761 + 6, 0xFFFFFF);
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(resetTimerText.getString()).method_27692(resetTimerButton.field_22763 ? class_124.field_1075 : class_124.field_1080), multipleCompletionButton.field_22760 - scoutMaxTextWidth - 8, resetTimerButton.field_22761 + 6, 0xFFFFFF);
            }
            if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(mostEliminateTimeText.getString()).method_27692(class_124.field_1075), mostEliminateTimeField.field_22760 + 12 - mostMaxTextWidth - 8, mostEliminateTimeField.field_22761 + 3, 0xFFFFFF);
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(mostEliminatePlayersText.getString()).method_27692(class_124.field_1075), mostEliminatePlayersField.field_22760 - mostMaxTextWidth - 8, mostEliminatePlayersField.field_22761 + 3, 0xFFFFFF);
                if (mostEliminatePlayersField.method_25405((double)mouseX, (double)mouseY)) {
                    this.setTooltipWithWrap(new class_2588("projectelo.text.eliminate_players.description"), 300);
                }
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(mostResetScoreText.getString()).method_27692(class_124.field_1075), mostResetButton.field_22760 - mostMaxTextWidth - 8, mostResetButton.field_22761 + 6, 0xFFFFFF);
                this.method_27535(matrices, this.field_22793, (class_5348)new class_2585(mostDisplayScoreText.getString()).method_27692(class_124.field_1075), mostDisplayButton.field_22760 - mostMaxTextWidth - 8, mostDisplayButton.field_22761 + 6, 0xFFFFFF);
            }
        }));
    }

    @NotNull
    private class_342 createMostEliminatePlayersField(int mostMaxTextWidth) {
        int n = (this.field_22789 + mostMaxTextWidth + 86 - 30) / 2;
        Objects.requireNonNull(this.field_22793);
        class_342 textFieldWidget = new class_342(this.field_22793, n, 103, 30, 9 + 5, class_2585.field_24366){

            public int method_1859() {
                return this.method_25368() + 3;
            }
        };
        textFieldWidget.method_1880(3);
        textFieldWidget.method_1890(string -> {
            if (string.isEmpty()) {
                return true;
            }
            try {
                int i = Integer.parseInt(string);
                return i >= 1 && i <= 100;
            }
            catch (Throwable e) {
                return false;
            }
        });
        textFieldWidget.method_1863(text -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
                try {
                    int i = Integer.parseInt(text);
                    if (text.startsWith("0") && text.length() > 1) {
                        textFieldWidget.method_1852(text.substring(1));
                    }
                    ((MostPercentGameMode)onlineMatch.getOption().getGameMode()).setEliminationPlayers(i);
                }
                catch (Throwable ignored) {
                    ((MostPercentGameMode)onlineMatch.getOption().getGameMode()).setEliminationPlayers(15);
                }
            }
        }));
        return textFieldWidget;
    }

    public void initBotPage() {
        int centerX = (this.field_22789 + 80) / 2;
        for (class_4185 tabButton : this.tabButtons) {
            this.getPagination().addElement(11, tabButton);
        }
        Supplier<class_2561> botEnableText = () -> new class_2588("projectelo.option.ranked_bot").method_27693(": ").method_10852((class_2561)(MCSRRankedClient.getOnlineMatch().map(match -> match.getOption().isAvailableFakePlayer()).orElse(false) != false ? new class_2585(RankedScreenTexts.ON.text().getString()).method_27692(class_124.field_1060) : new class_2585(RankedScreenTexts.OFF.text().getString()).method_27692(class_124.field_1061)));
        FreeSizeButtonWidget botButton = this.getPagination().addElement(11, new FreeSizeButtonWidget(centerX - 100, 40, 200, 24, botEnableText.get(), button -> {
            MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().setAvailableFakePlayer(!match.getOption().isAvailableFakePlayer()));
            button.method_25355((class_2561)botEnableText.get());
        }));
        botButton.field_22763 = false;
        FreeSizeButtonWidget difficultyRandomButton = this.getPagination().addElement(11, new FreeSizeButtonWidget(centerX - 100, botButton.field_22761 + 50, 50, 20, (class_2561)BotDifficulty.RANDOM.getText(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().setFakePlayerLevel(BotDifficulty.RANDOM.getLevel()))));
        FreeSizeButtonWidget difficultyEasyButton = this.getPagination().addElement(11, new FreeSizeButtonWidget(centerX - 50, botButton.field_22761 + 50, 50, 20, (class_2561)BotDifficulty.EASY.getText(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().setFakePlayerLevel(BotDifficulty.EASY.getLevel()))));
        FreeSizeButtonWidget difficultyNormalButton = this.getPagination().addElement(11, new FreeSizeButtonWidget(centerX, botButton.field_22761 + 50, 50, 20, (class_2561)BotDifficulty.NORMAL.getText(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().setFakePlayerLevel(BotDifficulty.NORMAL.getLevel()))));
        FreeSizeButtonWidget difficultyHardButton = this.getPagination().addElement(11, new FreeSizeButtonWidget(centerX + 50, botButton.field_22761 + 50, 50, 20, (class_2561)BotDifficulty.HARD.getText(), button -> MCSRRankedClient.getOnlineMatch().ifPresent(match -> match.getOption().setFakePlayerLevel(BotDifficulty.HARD.getLevel()))));
        this.getPagination().setPreRenderPage(11, (matrices, mouseX, mouseY, delta) -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            botButton.field_22763 = MCSRRankedClient.PLAYER_PERMISSION.canActivePrivateRoomBot() && onlineMatch.getOption().canActiveFakePlayer();
            boolean activeBot = botButton.field_22763 && onlineMatch.getOption().isAvailableFakePlayer();
            difficultyRandomButton.field_22763 = activeBot && onlineMatch.getOption().getFakePlayerLevel() != 0;
            difficultyEasyButton.field_22763 = activeBot && onlineMatch.getOption().getFakePlayerLevel() != 1;
            difficultyNormalButton.field_22763 = activeBot && onlineMatch.getOption().getFakePlayerLevel() != 2;
            boolean bl = difficultyHardButton.field_22763 = activeBot && onlineMatch.getOption().getFakePlayerLevel() != 3;
            if (botButton.field_22760 <= mouseX && botButton.field_22761 <= mouseY && botButton.field_22760 + botButton.method_25368() > mouseX && botButton.field_22761 + botButton.method_25364() > mouseY) {
                this.setTooltipWithWrap(new class_2588("projectelo.option.ranked_bot.description"), 200);
            }
        }));
        this.getPagination().setRenderPage(11, (matrices, mouseX, mouseY, delta) -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            this.drawTitleText(matrices, centerX);
            if (MCSRRankedClient.PLAYER_PERMISSION.canActivePrivateRoomBot()) {
                this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.option.ranked_bot_difficulty"), centerX, botButton.field_22761 + 38, 0xFFFFFF);
            } else {
                this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.available_tier", new Object[]{"Iron Pickaxe"}).method_27692(class_124.field_1061), centerX, botButton.field_22761 + 40, 0xFFFFFF);
            }
        }));
    }

    private class_2561 getRoomMessage() {
        Long startTime = MCSRRankedClient.getOnlineMatch().map(onlineMatch -> onlineMatch.getEachTime(MatchStatus.START_GEN)).orElse(null);
        if (MCSRRankedClient.getOnlineMatch().map(match -> match.getStatus().isPreparing()).orElse(false).booleanValue() && startTime != null) {
            long second = MatchPrivateRoomScreen.getRemainStartTime();
            return new class_2588("projectelo.text.roommessage.ready", new Object[]{second});
        }
        return new class_2588("projectelo.text.roommessage." + CURRENT_STATUS.name().toLowerCase(Locale.ROOT));
    }

    public static long getRemainStartTime() {
        Long startTime = MCSRRankedClient.getOnlineMatch().map(onlineMatch -> onlineMatch.getEachTime(MatchStatus.START_GEN)).orElse(null);
        return startTime == null ? 0L : Math.max((startTime - System.currentTimeMillis()) / 1000L + 1L, 0L);
    }

    private static /* synthetic */ void lambda$initGameModePage$149(Runnable refreshWidgets, FreeSizeButtonWidget gameModeButton, Supplier gameModeText, OnlineMatch onlineMatch) {
        refreshWidgets.run();
        gameModeButton.method_25355((class_2561)gameModeText.get());
    }

    private static /* synthetic */ void lambda$initGameModePage$143(FreeSizeButtonWidget freeScoutButton, TimeFormatFieldWidget scoutTimeField, FreeSizeButtonWidget scoutCommandButton, FreeSizeButtonWidget scoutSeedButton, FreeSizeButtonWidget multipleCompletionButton, FreeSizeButtonWidget resetTimerButton, TimeFormatFieldWidget mostEliminateTimeField, class_342 mostEliminatePlayersField, FreeSizeButtonWidget mostResetButton, FreeSizeButtonWidget mostDisplayButton, Supplier freeScoutButtonText, Supplier scoutCommandButtonText, Supplier scoutSeedButtonText, Supplier multipleCompletionButtonText, Supplier resetTimerButtonText, Supplier mostResetButtonText, Supplier mostDisplayButtonText, OnlineMatch onlineMatch) {
        freeScoutButton.field_22764 = false;
        scoutTimeField.method_1862(false);
        scoutCommandButton.field_22764 = false;
        scoutSeedButton.field_22764 = false;
        multipleCompletionButton.field_22764 = false;
        resetTimerButton.field_22764 = false;
        mostEliminateTimeField.method_1862(false);
        mostEliminatePlayersField.method_1862(false);
        mostResetButton.field_22764 = false;
        mostDisplayButton.field_22764 = false;
        if (onlineMatch.getOption().getGameMode() instanceof ScoutRouteGameMode) {
            ScoutRouteGameMode gameMode = (ScoutRouteGameMode)onlineMatch.getOption().getGameMode();
            freeScoutButton.field_22764 = true;
            freeScoutButton.method_25355((class_2561)freeScoutButtonText.get());
            scoutTimeField.method_1862(true);
            scoutTimeField.setTime(gameMode.getScoutTime());
            scoutTimeField.method_1888(!gameMode.isEnableFreeScout());
            scoutCommandButton.field_22764 = true;
            scoutCommandButton.method_25355((class_2561)scoutCommandButtonText.get());
            scoutSeedButton.field_22764 = true;
            scoutSeedButton.method_25355((class_2561)scoutSeedButtonText.get());
            multipleCompletionButton.field_22764 = true;
            multipleCompletionButton.method_25355((class_2561)multipleCompletionButtonText.get());
            resetTimerButton.field_22764 = true;
            resetTimerButton.method_25355((class_2561)resetTimerButtonText.get());
            resetTimerButton.field_22763 = gameMode.isAllowMultipleCompletions();
        } else if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
            MostPercentGameMode gameMode = (MostPercentGameMode)onlineMatch.getOption().getGameMode();
            mostEliminateTimeField.method_1862(true);
            mostEliminateTimeField.setTime(gameMode.getEliminationTime());
            mostEliminatePlayersField.method_1862(true);
            mostEliminatePlayersField.method_1852(String.valueOf(gameMode.getEliminationPlayers()));
            mostResetButton.field_22764 = true;
            mostResetButton.method_25355((class_2561)mostResetButtonText.get());
            mostDisplayButton.field_22764 = true;
            mostDisplayButton.method_25355((class_2561)mostDisplayButtonText.get());
        }
    }

    private static /* synthetic */ void lambda$initGameModePage$141(class_4185 button, Supplier mostDisplayButtonText, OnlineMatch onlineMatch) {
        if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
            MostPercentGameMode gameMode;
            gameMode.setEnableDisplayScore(!(gameMode = (MostPercentGameMode)onlineMatch.getOption().getGameMode()).isEnableDisplayScore());
        }
        button.method_25355((class_2561)mostDisplayButtonText.get());
    }

    private static /* synthetic */ void lambda$initGameModePage$137(class_4185 button, Supplier mostResetButtonText, OnlineMatch onlineMatch) {
        if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
            MostPercentGameMode gameMode;
            gameMode.setEnableResetScore(!(gameMode = (MostPercentGameMode)onlineMatch.getOption().getGameMode()).isEnableResetScore());
        }
        button.method_25355((class_2561)mostResetButtonText.get());
    }

    private static /* synthetic */ void lambda$initGameModePage$130(FreeSizeButtonWidget resetTimerButton, class_4185 button, Supplier multipleCompletionButtonText, OnlineMatch onlineMatch) {
        if (onlineMatch.getOption().getGameMode() instanceof ScoutRouteGameMode) {
            ScoutRouteGameMode gameMode;
            gameMode.setAllowMultipleCompletions(!(gameMode = (ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).isAllowMultipleCompletions());
            resetTimerButton.field_22763 = gameMode.isAllowMultipleCompletions();
        }
        button.method_25355((class_2561)multipleCompletionButtonText.get());
    }

    private static /* synthetic */ void lambda$initGameModePage$126(class_4185 button, Supplier resetTimerButtonText, OnlineMatch onlineMatch) {
        if (onlineMatch.getOption().getGameMode() instanceof ScoutRouteGameMode) {
            ((ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).setResetTimer(!((ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).shouldResetTimer());
        }
        button.method_25355((class_2561)resetTimerButtonText.get());
    }

    private static /* synthetic */ void lambda$initGameModePage$122(class_4185 button, Supplier scoutSeedButtonText, OnlineMatch onlineMatch) {
        if (onlineMatch.getOption().getGameMode() instanceof ScoutRouteGameMode) {
            ((ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).setEnableSeed(!((ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).isEnableSeed());
        }
        button.method_25355((class_2561)scoutSeedButtonText.get());
    }

    private static /* synthetic */ void lambda$initGameModePage$118(class_4185 button, Supplier scoutCommandButtonText, OnlineMatch onlineMatch) {
        if (onlineMatch.getOption().getGameMode() instanceof ScoutRouteGameMode) {
            ((ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).setEnableCheat(!((ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).isEnableCheat());
        }
        button.method_25355((class_2561)scoutCommandButtonText.get());
    }

    private static /* synthetic */ void lambda$initGameModePage$114(TimeFormatFieldWidget scoutTimeField, class_4185 button, Supplier freeScoutButtonText, OnlineMatch onlineMatch) {
        if (onlineMatch.getOption().getGameMode() instanceof ScoutRouteGameMode) {
            boolean toChange = !((ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).isEnableFreeScout();
            ((ScoutRouteGameMode)onlineMatch.getOption().getGameMode()).setEnableFreeScout(toChange);
            scoutTimeField.method_1888(!toChange);
        }
        button.method_25355((class_2561)freeScoutButtonText.get());
    }

    private /* synthetic */ void lambda$initJoinRequestPage$72(class_4185 button, Supplier requestModeText, OnlineMatch onlineMatch) {
        onlineMatch.setJoinRequest(!onlineMatch.isJoinRequest());
        button.method_25355((class_2561)requestModeText.get());
        button.field_22763 = false;
        SocketInstance.getInstance().emit("p$req_toggle", onlineMatch.isJoinRequest() ? 1 : 0);
        this.lastToggleRequestMode = 60;
    }

    private /* synthetic */ void lambda$initOptionsPage$63(class_342 completionsField, class_2561 completionsText, int completionsTextWidth, class_2561 overworldSeedText, class_342 overworldSeedField, int maxSeedTextWidth, class_2561 netherSeedText, class_342 netherSeedField, class_2561 theEndSeedText, class_342 theEndSeedField, class_2561 rngSeedText, class_342 rngSeedField, class_4587 matrices, int mouseX, int mouseY, float delta) {
        int completions = MCSRRankedClient.getOnlineMatch().map(matchInfo -> matchInfo.getOption().getCompletions()).orElse(0);
        int descIndex = completions == 0 ? 1 : 2;
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.completion_percentage.description." + descIndex + ".1", new Object[]{completions}).method_27692(class_124.field_1060), (this.field_22789 + 80) / 2, completionsField.field_22761 + 20, 0xFFFFFF);
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.completion_percentage.description." + descIndex + ".2").method_27692(class_124.field_1054), (this.field_22789 + 80) / 2, completionsField.field_22761 + 30, 0xFFFFFF);
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.completion_percentage.description.0"), (this.field_22789 + 80) / 2, completionsField.field_22761 + 44, 0xFFFFFF);
        this.method_27535(matrices, this.field_22793, (class_5348)completionsText, completionsField.field_22760 - completionsTextWidth - 8, completionsField.field_22761 + 3, 0xFFFFFF);
        this.method_27535(matrices, this.field_22793, (class_5348)overworldSeedText, overworldSeedField.field_22760 - maxSeedTextWidth - 8, overworldSeedField.field_22761 + 3, 0xFFFFFF);
        this.method_27535(matrices, this.field_22793, (class_5348)netherSeedText, netherSeedField.field_22760 - maxSeedTextWidth - 8, netherSeedField.field_22761 + 3, 0xFFFFFF);
        this.method_27535(matrices, this.field_22793, (class_5348)theEndSeedText, theEndSeedField.field_22760 - maxSeedTextWidth - 8, theEndSeedField.field_22761 + 3, 0xFFFFFF);
        this.method_27535(matrices, this.field_22793, (class_5348)rngSeedText, rngSeedField.field_22760 - maxSeedTextWidth - 8, rngSeedField.field_22761 + 3, 0xFFFFFF);
        this.drawTitleText(matrices, (this.field_22789 + 80) / 2);
        if (overworldSeedField.method_25405((double)mouseX, (double)mouseY)) {
            this.setTooltipWithWrap(new class_2588("projectelo.text.insert_seed.description"), (int)((double)this.field_22789 * 0.8));
        }
        if (netherSeedField.method_25405((double)mouseX, (double)mouseY)) {
            this.setTooltipWithWrap(new class_2588("projectelo.text.insert_seed_nether.description"), (int)((double)this.field_22789 * 0.8));
        }
        if (theEndSeedField.method_25405((double)mouseX, (double)mouseY)) {
            this.setTooltipWithWrap(new class_2588("projectelo.text.insert_seed_nether.description"), (int)((double)this.field_22789 * 0.8));
        }
        if (rngSeedField.method_25405((double)mouseX, (double)mouseY)) {
            this.setTooltipWithWrap(new class_2588("projectelo.text.insert_seed_nether.description"), (int)((double)this.field_22789 * 0.8));
        }
    }

    private static enum Status {
        NONE,
        FINDING,
        WAITING,
        IDLE;

    }
}

