/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.match;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.ReplayProcessor;
import com.mcsrranked.client.anticheat.replay.tracking.PersonalPlayerTracker;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.gui.MessageToast;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.match.EmptyRankedScreen;
import com.mcsrranked.client.gui.screen.match.ForfeitMatchConfirmScreen;
import com.mcsrranked.client.gui.screen.match.MatchBattleScreen;
import com.mcsrranked.client.gui.screen.match.MatchPauseScreen;
import com.mcsrranked.client.gui.screen.match.MatchPrivateResultScreen;
import com.mcsrranked.client.gui.screen.match.MatchRankUpScreen;
import com.mcsrranked.client.gui.screen.match.TimelineUpdateListener;
import com.mcsrranked.client.gui.toast.PersonalBestToast;
import com.mcsrranked.client.gui.toast.ToastHud;
import com.mcsrranked.client.gui.widget.MatchChatWidget;
import com.mcsrranked.client.info.match.MatchSplit;
import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.online.MatchFlag;
import com.mcsrranked.client.info.match.online.MatchStatus;
import com.mcsrranked.client.info.match.online.OnlineEloChange;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.match.online.OnlineMatchResult;
import com.mcsrranked.client.info.match.online.PlayLog;
import com.mcsrranked.client.info.match.online.gamemode.MostPercentGameMode;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.info.player.PlayerStatus;
import com.mcsrranked.client.info.player.PlayerTier;
import com.mcsrranked.client.info.player.achievement.AchievementManager;
import com.mcsrranked.client.info.player.achievement.AchievementWorker;
import com.mcsrranked.client.info.player.achievement.PlayerAchievement;
import com.mcsrranked.client.socket.SocketEvent;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.utils.DiscordRPCUtils;
import com.mcsrranked.client.utils.RenderUtils;
import com.mcsrranked.client.utils.UUIDUtils;
import com.mcsrranked.client.world.WorldCreator;
import com.mcsrranked.client.world.WorldServerInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1659;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class MatchWaitingScreen
extends RankedScreen {
    private static final int TIP_MESSAGE_COUNT = 48;
    public static final class_2960 CUSTOM_BACKGROUND_ID = new class_2960("mcsrranked", "custom_wait_bg");
    MatchChatWidget matchChatWidget;
    private final int tipIndex = new Random().nextInt(48);

    public MatchWaitingScreen() {
        super(null, (class_2561)new class_2588("projectelo.title.match_waiting"));
        SocketInstance.on("m$timeline", payload -> {
            MatchTimeline matchTimeline = new MatchTimeline((SocketEvent)payload);
            boolean update = payload.getNextBoolean();
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                onlineMatch.addTimeline(matchTimeline);
                MCSRRankedClient.getReplayProcessor().filter(ReplayProcessor::isActive).ifPresent(p -> p.updateTimeline(matchTimeline));
                class_310.method_1551().execute(() -> {
                    if (class_310.method_1551().field_1755 instanceof TimelineUpdateListener) {
                        ((TimelineUpdateListener)class_310.method_1551().field_1755).onAddNewTimeline(matchTimeline);
                    }
                });
                if (MCSRRankedClient.LOCAL_PLAYER.isSpectator()) {
                    onlineMatch.writeFile();
                }
                for (OnlinePlayer player : onlineMatch.getPlayers()) {
                    if (!player.getUUID().equals(matchTimeline.getUUID())) continue;
                    MatchSplit matchSplit = MatchSplit.fromTimeline(matchTimeline);
                    if (matchSplit != null) {
                        if (matchSplit == MatchSplit.FORFEIT_MATCH) {
                            player.setStatus(PlayerStatus.FORFEIT);
                        }
                        if (matchSplit == MatchSplit.COMPLETE_MATCH) {
                            player.setStatus(PlayerStatus.COMPLETED);
                            onlineMatch.getPlayLog(player).setResult(Integer.parseInt(matchTimeline.getData().get(0)), Long.parseLong(matchTimeline.getData().get(1)));
                        }
                        if (update) {
                            onlineMatch.updateSplit(player, matchSplit, matchTimeline.getTime());
                        }
                    }
                    if (matchTimeline.isEliminate()) {
                        player.setStatus(PlayerStatus.FORFEIT);
                    }
                    if (matchTimeline.isShown() && (matchTimeline.isComplete() || matchTimeline.isEliminate() || !player.isMe() && !((Boolean)SpeedRunOption.getOption(RankedOptions.HIDE_OPPONENT_ADVANCEMENT)).booleanValue())) {
                        ClientUtils.addMessage((class_2561)matchTimeline.getText(player.getNickname()));
                    }
                    onlineMatch.getOption().getGameMode().onAddTimeline((OnlineMatch)onlineMatch, player);
                    break;
                }
            });
        });
        SocketInstance.on("m$elim_warn", payload -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
                ClientUtils.addMessage((class_2561)new class_2588("projectelo.text.elimination_warning.most").method_27692(class_124.field_1054));
            }
        }));
        SocketInstance.on("p$forfeit", payload -> {
            boolean hasForfeit = payload.getNextBoolean();
            class_310.method_1551().execute(() -> {
                if (hasForfeit) {
                    MCSRRankedClient.getOnlineMatch().ifPresent(match -> {
                        match.getLocalData().setHasForfeit();
                        match.getReplay().getPersonalPlayerTracker().stopTracking();
                    });
                    class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.text.has_been_forfeited", (Object[])new Object[0])));
                    ClientUtils.changeSpectate();
                } else {
                    class_310.method_1551().method_1566().method_1999((class_368)new MessageToast(class_1074.method_4662((String)"projectelo.text.forfeit_failed", (Object[])new Object[0])));
                }
                class_437 screen = class_310.method_1551().field_1755;
                if (screen instanceof ForfeitMatchConfirmScreen) {
                    ((ForfeitMatchConfirmScreen)screen).getRunnable().run();
                }
                class_310.method_1551().method_1507(null);
            });
        });
        SocketInstance.on("m$inv_update", payload -> {
            UUID uuid = UUIDUtils.fromString(payload.getNextString());
            String data = payload.getNextString();
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                for (OnlinePlayer player : onlineMatch.getPlayers()) {
                    if (!player.getUUID().equals(uuid)) continue;
                    onlineMatch.updateInventory(player, data);
                    break;
                }
                onlineMatch.writeFile();
            });
        });
        SocketInstance.on("m$vote", payload -> {
            int voteType = payload.getNextInteger();
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                ClientUtils.playSound(class_3417.field_14622, 1.0f, 0.8f);
                if (voteType == 0) {
                    ClientUtils.addMessage((class_2561)new class_2588("projectelo.text.started_seed_change_vote").method_27692(class_124.field_1054));
                } else {
                    ClientUtils.addMessage((class_2561)new class_2588("projectelo.text.started_draw_vote").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
                }
                onlineMatch.setVoting(true);
                onlineMatch.setVoteType(voteType);
            });
        });
        SocketInstance.on("m$vote_cancel", payload -> {
            int voteType = payload.getNextInteger();
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                ClientUtils.playSound(class_3417.field_15008, 1.0f, 0.8f);
                if (voteType == 0) {
                    ClientUtils.addMessage((class_2561)new class_2588("projectelo.text.rejected_seed_change_vote").method_27692(class_124.field_1061));
                } else {
                    ClientUtils.addMessage((class_2561)new class_2588("projectelo.text.rejected_draw_vote").method_27692(class_124.field_1061));
                }
                onlineMatch.setVoteType(-1);
                onlineMatch.setClickedVote(false);
                onlineMatch.setVoting(false);
            });
        });
        SocketInstance.on("m$vote_confirm", payload -> {
            int voteType = payload.getNextInteger();
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                ClientUtils.playSound(class_3417.field_14622, 2.0f, 0.8f);
                if (voteType == 0) {
                    ClientUtils.addMessage((class_2561)new class_2588("projectelo.text.approved_seed_change_vote").method_27692(class_124.field_1060));
                }
                onlineMatch.setBlockBehaviors(true);
            });
        });
        SocketInstance.on("m$end", payload -> {
            JsonObject resultData = payload.getNextJsonObject();
            JsonArray changeData = payload.getNextJsonArray();
            ArrayList changes = Lists.newArrayList();
            if (changeData != null) {
                for (JsonElement element : changeData) {
                    changes.add((OnlineEloChange)MCSRRankedClient.GSON.fromJson(element, OnlineEloChange.class));
                }
            }
            OnlineMatchResult matchResult = new OnlineMatchResult(resultData.get("uuid").isJsonNull() ? null : UUIDUtils.fromString(resultData.get("uuid").getAsString()), resultData.get("time").getAsLong(), changes);
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                onlineMatch.getReplay().getPersonalPlayerTracker().stopTracking();
                onlineMatch.setResult(matchResult);
                if (SpeedRunOption.getOption(RankedOptions.HIDE_OPPONENT_PROFILE) != RankedOptions.HideProfileType.ALWAYS) {
                    for (OnlinePlayer player : onlineMatch.getPlayers()) {
                        player.setHideOnClient(false);
                    }
                }
                onlineMatch.setStatus(MatchStatus.END);
                onlineMatch.setBlockBehaviors(true);
                if (MCSRRankedClient.LOCAL_PLAYER.isSpectator()) {
                    onlineMatch.writeFile();
                }
                class_310 mcClient = class_310.method_1551();
                mcClient.execute(() -> {
                    String resultMessage;
                    ClientUtils.closeScreen();
                    class_1659 chatVisibility = mcClient.field_1690.field_1877;
                    if (((Boolean)SpeedRunOption.getOption(RankedOptions.SPECTATE_AT_ENDS)).booleanValue()) {
                        ClientUtils.changeSpectate();
                    } else {
                        mcClient.method_1507((class_437)new EmptyRankedScreen());
                        mcClient.field_1690.field_1877 = class_1659.field_7536;
                    }
                    BasePlayer winner = null;
                    for (OnlinePlayer player : onlineMatch.getPlayers()) {
                        if (!player.getUUID().equals(matchResult.getWinner())) continue;
                        winner = player;
                        break;
                    }
                    mcClient.field_1705.method_1763((class_2561)(onlineMatch.getType() == MatchType.PRIVATE || winner == null ? new class_2588("projectelo.title.match_done").method_27695(new class_124[]{winner == null ? class_124.field_1075 : (winner.isMe() ? class_124.field_1054 : class_124.field_1061), class_124.field_1067}) : (winner.isMe() ? new class_2588("projectelo.title.match_done.win").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}) : new class_2588("projectelo.title.match_done.lose").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}))), null, 0, 0, 0);
                    String string = resultMessage = winner == null ? "" : " (" + InGameTimerUtils.timeToStringFormat((long)matchResult.getFinalTime()) + ")";
                    if (onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
                        int maxScore = 0;
                        for (OnlinePlayer player : onlineMatch.getPlayersExcludeSpectator()) {
                            maxScore = Math.max(maxScore, onlineMatch.getPlayLog(player).getScore());
                        }
                        resultMessage = " (Score: " + maxScore + ")";
                    }
                    if (winner != null) {
                        mcClient.field_1705.method_1763(null, (class_2561)new class_2588("projectelo.title.match_done.winner").method_27693(": ").method_10852((class_2561)new class_2585(((OnlinePlayer)winner).getNickname()).method_27692(class_124.field_1054)).method_27693(resultMessage), 0, 0, 0);
                    } else {
                        mcClient.field_1705.method_1763(null, (class_2561)new class_2588("projectelo.title.match_done.draw").method_27693(resultMessage), 0, 0, 0);
                    }
                    mcClient.field_1705.method_1763(null, null, 20, 120, 20);
                    MCSRRankedClient.THREAD_EXECUTOR.submit(() -> {
                        try {
                            Thread.sleep(1000L);
                            ClientUtils.playSound(class_3417.field_15195, 1.0f, ((Float)SpeedRunOption.getOption(RankedOptions.END_SOUND_VOLUME)).floatValue());
                            Thread.sleep(9000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        mcClient.execute(() -> {
                            mcClient.field_1705.method_1743().method_1808(true);
                            if (onlineMatch.getType() == MatchType.PRIVATE) {
                                mcClient.method_1507((class_437)new MatchPrivateResultScreen((OnlineMatch)onlineMatch));
                            } else {
                                MatchBattleScreen resultScreen = new MatchBattleScreen(null, onlineMatch.getType(), onlineMatch.getResult());
                                if (MatchRankUpScreen.isAvailable(onlineMatch.getResult())) {
                                    mcClient.method_1507((class_437)new MatchRankUpScreen(resultScreen, PlayerTier.fromScore((Integer)onlineMatch.getResult().getUpdatedPeak().method_15442()), PlayerTier.fromScore((Integer)onlineMatch.getResult().getUpdatedPeak().method_15441())));
                                } else {
                                    mcClient.method_1507((class_437)resultScreen);
                                }
                            }
                            mcClient.field_1690.field_1877 = chatVisibility;
                        });
                    });
                });
            });
        });
        SocketInstance.on("m$info_update", payload -> {
            if (MCSRRankedClient.RECENT_MATCHES.size() > 5) {
                MCSRRankedClient.RECENT_MATCHES.poll();
            }
            MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
                for (OnlinePlayer player : onlineMatch.getPlayers()) {
                    if (player.isMe()) continue;
                    MCSRRankedClient.RECENT_MATCHES.add((class_3545<Integer, OnlinePlayer>)new class_3545((Object)payload.getNextInteger(), (Object)player));
                    break;
                }
            });
        });
        SocketInstance.on("m$pause", payload -> class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new MatchPauseScreen(class_310.method_1551().field_1755))));
        SocketInstance.on("m$unpause", payload -> class_310.method_1551().execute(() -> {
            class_437 currentScreen = class_310.method_1551().field_1755;
            if (currentScreen instanceof MatchPauseScreen) {
                ((MatchPauseScreen)currentScreen).openScreen(((MatchPauseScreen)currentScreen).getParent());
            }
        }));
        SocketInstance.on("p$peak", payload -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            OnlineMatchResult result = onlineMatch.getResult();
            if (result != null) {
                result.setUpdatedPeak((class_3545<Integer, Integer>)new class_3545((Object)payload.getNextInteger(), (Object)payload.getNextInteger()));
                if (result.getUpdatedPeak().method_15442() == null) {
                    MCSRRankedClient.LOCAL_PLAYER.setEloRate((Integer)result.getUpdatedPeak().method_15441());
                }
            }
        }));
        SocketInstance.on("p$rank", payload -> MCSRRankedClient.getOnlineMatch().ifPresent(onlineMatch -> {
            OnlineMatchResult result = onlineMatch.getResult();
            if (result != null) {
                result.setUpdatedRank(payload.getNextInteger());
            }
        }));
        SocketInstance.on("p$best", payload -> ToastHud.addQueue(new PersonalBestToast(payload.getNextLong(), payload.getNextLong())));
    }

    protected void method_25426() {
        super.method_25426();
        OnlineMatch onlineMatch = MCSRRankedClient.getOnlineMatch().orElse(null);
        if (onlineMatch != null && onlineMatch.getStatus() == MatchStatus.START_GEN) {
            List<OnlinePlayer> players = onlineMatch.getPlayers();
            players.stream().filter(player -> !player.isMe()).findFirst().ifPresent(bannerPlayer -> DiscordRPCUtils.updateRichPresence(builder -> builder.setState("Match with " + (players.size() > 2 ? players.size() + " more players" : bannerPlayer.getNickname() + (bannerPlayer.getEloRate() == null ? "" : " (" + bannerPlayer.getEloRate() + ")")))));
            SocketInstance.getInstance().emit("p$worldgen", 100);
        }
        if (this.field_22787 != null) {
            this.field_22787.field_1690.field_1866 = false;
            this.field_22787.field_1705.method_1743().method_1808(true);
        }
        if (this.field_22787 != null) {
            this.field_22787.field_1774.method_1462(true);
        }
        this.matchChatWidget = (MatchChatWidget)this.method_25429((class_364)new MatchChatWidget(this.field_22793, 10, this.field_22790 - 25, (int)((float)this.field_22789 / 2.0f * 0.7f), this));
        this.method_20085((class_364)this.matchChatWidget);
    }

    public boolean method_25422() {
        return false;
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.matchChatWidget != null) {
            this.matchChatWidget.method_1865();
        }
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null) {
            return;
        }
        OnlineMatch onlineMatch = MCSRRankedClient.getOnlineMatch().orElse(null);
        if (onlineMatch == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Long startTime = onlineMatch.getEachTime(MatchStatus.RUNNING);
        WorldServerInfo currentServer = WorldCreator.getInstance().getCurrentServer();
        if (startTime != null && startTime <= currentTime && currentServer != null) {
            int prevWidth = this.field_22789;
            ClientUtils.initTimer(onlineMatch, currentServer.getWorldName(), System.currentTimeMillis());
            onlineMatch.setStatus(MatchStatus.RUNNING);
            onlineMatch.getReplay().getPersonalPlayerTracker().setActiveType(PersonalPlayerTracker.ActiveType.MATCH);
            this.field_22787.execute(() -> {
                this.field_22787.method_1507(null);
                this.field_22787.field_1705.method_1755(class_2556.field_11735, (class_2561)new class_2588("projectelo.text.chat_" + ((Boolean)SpeedRunOption.getOption(RankedOptions.MATCH_LIVE_CHAT_AVAILABLE) != false ? "available" : "unavailable")), class_156.field_25140);
                this.field_22787.field_1705.method_1755(class_2556.field_11735, (class_2561)new class_2588("projectelo.text.mute_available"), class_156.field_25140);
                if (onlineMatch.getOption().getFlag().isEnableFlag(MatchFlag.Type.BEGINNER_MODE)) {
                    this.field_22787.field_1705.method_1755(class_2556.field_11735, (class_2561)new class_2585("- ").method_10852((class_2561)new class_2588("projectelo.text.beginner_mode_activated")).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), class_156.field_25140);
                    List beginnerTexts = this.field_22787.field_1772.method_1728((class_5348)new class_2588("projectelo.match_flag.beginner_mode.description"), Integer.MAX_VALUE);
                    for (class_5348 beginnerText : beginnerTexts) {
                        this.field_22787.field_1705.method_1755(class_2556.field_11735, (class_2561)new class_2585(beginnerText.getString()).method_27692(class_124.field_1054), class_156.field_25140);
                    }
                } else if (onlineMatch.getType() == MatchType.CASUAL) {
                    this.field_22787.field_1705.method_1755(class_2556.field_11735, (class_2561)new class_2585("- ").method_10852((class_2561)new class_2588("projectelo.text.beginner_mode_inactivated")).method_27692(class_124.field_1061), class_156.field_25140);
                }
                if (MCSRRankedClient.CURRENT_EVENT != null && onlineMatch.getType() == MatchType.EVENT) {
                    this.field_22787.field_1705.method_1755(class_2556.field_11735, class_2585.field_24366, class_156.field_25140);
                    for (class_5348 wrapLine : this.field_22787.field_1772.method_1728((class_5348)class_2561.method_30163((String)MCSRRankedClient.CURRENT_EVENT.getDescription()), prevWidth / 2)) {
                        this.field_22787.field_1705.method_1755(class_2556.field_11735, class_2561.method_30163((String)wrapLine.getString()), class_156.field_25140);
                    }
                }
            });
            return;
        }
        this.method_25434(0);
        RenderSystem.pushMatrix();
        boolean customBackground = false;
        if (onlineMatch.getOption().getWaitingImageUrl() != null && !onlineMatch.getOption().getWaitingImageUrl().trim().isEmpty() && this.field_22787.method_1531().method_4619(CUSTOM_BACKGROUND_ID) != null) {
            this.field_22787.method_1531().method_22813(CUSTOM_BACKGROUND_ID);
            class_1044 texture = this.field_22787.method_1531().method_4619(CUSTOM_BACKGROUND_ID);
            if (texture instanceof class_1043) {
                RenderSystem.enableBlend();
                class_1043 bgTexture = (class_1043)this.field_22787.method_1531().method_4619(CUSTOM_BACKGROUND_ID);
                if (bgTexture != null && bgTexture.method_4525() != null) {
                    class_332.method_25293((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (float)0.0f, (float)0.0f, (int)bgTexture.method_4525().method_4307(), (int)bgTexture.method_4525().method_4323(), (int)bgTexture.method_4525().method_4307(), (int)bgTexture.method_4525().method_4323());
                    customBackground = true;
                }
                RenderSystem.disableBlend();
            }
        } else {
            this.renderSpecialBackground(matrices);
            RenderSystem.enableBlend();
            class_332.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)class_5253.class_5254.method_27764((int)120, (int)0, (int)0, (int)0));
            RenderSystem.disableBlend();
        }
        RenderSystem.popMatrix();
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (startTime == null) {
            if (!customBackground) {
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
                this.method_27534(matrices, this.field_22793, (class_5348)new class_2588("projectelo.text.roommessage.idle"), this.field_22789 / 4, this.field_22790 / 4 - 5, 0xFFFFFF);
                RenderSystem.popMatrix();
            }
        } else {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            this.method_25300(matrices, this.field_22793, String.valueOf((startTime - currentTime) / 1000L + 1L), this.field_22789 / 8, this.field_22790 / 8 - 5, 0xFFFFFF);
            RenderSystem.popMatrix();
        }
        OnlinePlayer targetPlayer = null;
        if (onlineMatch.getType() != MatchType.PRIVATE) {
            for (OnlinePlayer player : onlineMatch.getPlayers()) {
                if (player.isMe()) continue;
                targetPlayer = player;
                break;
            }
        } else {
            List<Map.Entry<OnlinePlayer, PlayLog>> progresses = onlineMatch.getWorldGeneratingPlayers();
            if (!progresses.isEmpty()) {
                targetPlayer = progresses.get((int)(System.currentTimeMillis() / 1500L) % progresses.size()).getKey();
            }
        }
        if (targetPlayer != null) {
            int nicknameWidth = BasePlayer.getNicknameWidth(targetPlayer);
            float scale = onlineMatch.getType() != MatchType.PRIVATE ? 1.5f : 1.0f;
            int xPos = (int)((float)this.field_22789 / scale - (float)nicknameWidth - 20.0f);
            int yPos = (int)((float)this.field_22790 / scale / 2.0f + 40.0f / scale);
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
            if (onlineMatch.getType() == MatchType.RANKED) {
                RenderUtils.renderPlayerHead(targetPlayer.getDisplayUUID(), matrices, xPos, yPos -= 11, 8, 8);
                BasePlayer.renderNickname(matrices, xPos + 10, yPos, targetPlayer, this, (int)((float)mouseX / scale), (int)((float)mouseY / scale));
                BasePlayer.renderEloText(matrices, xPos + 10 + nicknameWidth - BasePlayer.getEloTextWidth(targetPlayer.getEloRate(), targetPlayer.getEloRank()), yPos += 11, targetPlayer.getEloRate(), targetPlayer.getEloRank());
            } else {
                RenderUtils.renderPlayerHead(targetPlayer.getDisplayUUID(), matrices, xPos, yPos, 8, 8);
                BasePlayer.renderNickname(matrices, xPos + 10, yPos, targetPlayer, this, (int)((float)mouseX / scale), (int)((float)mouseY / scale));
            }
            int progress = onlineMatch.getWorldGeneratingPlayer(targetPlayer);
            if (progress < 100 && targetPlayer.isInteractable()) {
                int i;
                this.field_22787.method_1531().method_22813(field_22737);
                int barXPos = xPos + (nicknameWidth + 10) - 50;
                MatchWaitingScreen.method_25290((class_4587)matrices, (int)barXPos, (int)(yPos + 10), (float)0.0f, (float)64.0f, (int)10, (int)5, (int)256, (int)256);
                for (i = 0; i < 3; ++i) {
                    MatchWaitingScreen.method_25290((class_4587)matrices, (int)(barXPos + (i + 1) * 10), (int)(yPos + 10), (float)10.0f, (float)64.0f, (int)10, (int)5, (int)256, (int)256);
                }
                MatchWaitingScreen.method_25290((class_4587)matrices, (int)(barXPos + 39), (int)(yPos + 10), (float)171.0f, (float)64.0f, (int)11, (int)5, (int)256, (int)256);
                RenderSystem.pushMatrix();
                RenderUtils.enableScissor((int)((float)barXPos * scale), (int)((float)(yPos + 10) * scale), (int)(50.0 * ((double)progress / 100.0) * (double)scale), 10);
                MatchWaitingScreen.method_25290((class_4587)matrices, (int)barXPos, (int)(yPos + 10), (float)0.0f, (float)69.0f, (int)10, (int)5, (int)256, (int)256);
                for (i = 0; i < 3; ++i) {
                    MatchWaitingScreen.method_25290((class_4587)matrices, (int)(barXPos + (i + 1) * 10), (int)(yPos + 10), (float)10.0f, (float)69.0f, (int)10, (int)5, (int)256, (int)256);
                }
                MatchWaitingScreen.method_25290((class_4587)matrices, (int)(barXPos + 39), (int)(yPos + 10), (float)171.0f, (float)69.0f, (int)11, (int)5, (int)256, (int)256);
                RenderUtils.disableScissor();
                RenderSystem.popMatrix();
            }
            RenderSystem.popMatrix();
            if (onlineMatch.getType() != MatchType.PRIVATE && !targetPlayer.isHideOnClient()) {
                int achievementCount = targetPlayer.getAchievements().size();
                int achievementIndex = 0;
                xPos = this.field_22789 - 20;
                yPos = this.field_22790 / 2 + 42;
                for (PlayerAchievement achievement : targetPlayer.getAchievements()) {
                    AchievementWorker worker = AchievementManager.getWorker(achievement);
                    if (worker == null) continue;
                    int achievementX = xPos - (achievementCount - achievementIndex) * 36 + achievementCount * 4;
                    worker.renderIcon(matrices, achievementX, yPos + 26, achievement);
                    if (worker.isMouseOver(achievementX, yPos + 26, mouseX, mouseY, 1.0f)) {
                        this.setTooltip(worker.getTooltips(achievement));
                    }
                    ++achievementIndex;
                }
            }
        }
        if (this.matchChatWidget != null) {
            this.matchChatWidget.method_25394(matrices, mouseX, mouseY, delta);
        }
        if (onlineMatch.getType() != MatchType.PRIVATE) {
            this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)new class_2588("projectelo.tip_message.title").method_27692(class_124.field_1054), this.field_22789 / 2, 24, 0xFFFFFF);
            int row = 0;
            for (class_5348 wrapLine : this.field_22793.method_1728((class_5348)new class_2588("projectelo.tip_message." + this.tipIndex), (int)((float)this.field_22789 * 0.75f))) {
                int n = this.field_22789 / 2;
                int n2 = row++;
                Objects.requireNonNull(this.field_22793);
                this.drawCenteredTextWithShadow(matrices, this.field_22793, wrapLine, n, 34 + n2 * (9 + 1), 0xFFFFFF);
            }
        }
    }
}

