/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.screen.match.replay;

import com.google.common.collect.Lists;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.anticheat.replay.file.ReplayManager;
import com.mcsrranked.client.anticheat.replay.file.ReplayRecordFile;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.screen.info.UserMatchListScreen;
import com.mcsrranked.client.gui.screen.match.replay.ReplayDeleteConfirmScreen;
import com.mcsrranked.client.gui.screen.match.replay.ReplayEditScreen;
import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.utils.ClientUtils;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ReplayListScreen
extends RankedScreen {
    private ReplayListWidget replayListWidget = null;
    private class_342 searchBox;
    private String searchQuery = "";
    private class_4185 editButton;
    private class_4185 deleteButton;
    private class_4185 playButton;
    private List<class_5348> tooltips = null;

    public ReplayListScreen(class_437 parent) {
        super(parent, (class_2561)new class_2588("projectelo.title.my_replays"));
    }

    protected void method_25426() {
        assert (this.field_22787 != null);
        this.field_22787.field_1774.method_1462(true);
        this.replayListWidget = new ReplayListWidget(this.field_22787, this.field_22789, this.field_22790, 48, this.field_22790 - 56, 32, this.replayListWidget);
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 125, 22, 250, 20, null, (class_2561)new class_2588("projectelo.text.search_replay"));
        this.searchBox.method_1863(string -> {
            this.searchQuery = string.toLowerCase(Locale.ROOT);
            this.replayListWidget.filter(false);
            this.searchBox.method_1887(this.searchQuery.isEmpty() ? class_1074.method_4662((String)"projectelo.text.search_replay", (Object[])new Object[0]) + "..." : "");
        });
        this.searchBox.method_1852(this.searchQuery);
        this.method_25429((class_364)this.replayListWidget);
        this.method_20085((class_364)this.replayListWidget);
        this.method_25429((class_364)this.searchBox);
        this.editButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 28, 72, 20, (class_2561)RankedScreenTexts.EDIT.text(), button -> {
            if (this.replayListWidget != null && this.replayListWidget.method_25334() != null) {
                ((ReplayListWidget.Entry)this.replayListWidget.method_25334()).edit();
            }
        }));
        this.deleteButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 76, this.field_22790 - 28, 72, 20, (class_2561)RankedScreenTexts.DELETE.text(), button -> {
            if (this.replayListWidget != null && this.replayListWidget.method_25334() != null) {
                ((ReplayListWidget.Entry)this.replayListWidget.method_25334()).delete();
            }
        }));
        this.playButton = (class_4185)this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 4, this.field_22790 - 52, 150, 20, (class_2561)new class_2588("projectelo.button.watch_replay"), button -> {
            if (this.replayListWidget != null && this.replayListWidget.method_25334() != null) {
                ((ReplayListWidget.Entry)this.replayListWidget.method_25334()).play();
            }
        }));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 52, 150, 20, (class_2561)new class_2588("projectelo.button.download_replay"), button -> this.openScreen(new UserMatchListScreen((class_437)this, MCSRRankedClient.LOCAL_PLAYER)), (button, matrices, mouseX, mouseY) -> this.method_25424(matrices, (class_5348)new class_2588("projectelo.button.download_replay.description"), mouseX, mouseY)));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 82, this.field_22790 - 28, 72, 20, (class_2561)RankedScreenTexts.DONE.text(), button -> this.method_25419()));
        this.onSelectEntry();
    }

    public void onSelectEntry() {
        ReplayListWidget.Entry selectedEntry = (ReplayListWidget.Entry)this.replayListWidget.method_25334();
        this.deleteButton.field_22763 = selectedEntry != null;
        this.playButton.field_22763 = selectedEntry != null;
        this.editButton.field_22763 = selectedEntry != null;
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.replayListWidget.method_25394(matrices, mouseX, mouseY, delta);
        this.searchBox.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.drawCenteredTextWithShadow(matrices, this.field_22793, (class_5348)this.method_25440(), this.field_22789 / 2, 8, 0xFFFFFF);
        if (this.tooltips != null) {
            this.method_25417(matrices, this.tooltips, mouseX, mouseY);
            this.tooltips = null;
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.searchBox.method_1865();
        this.replayListWidget.tick();
    }

    public class ReplayListWidget
    extends class_4280<Entry>
    implements RankedEntryListWidget {
        private final CopyOnWriteArrayList<Pair<ReplayRecordFile, Boolean>> replayFiles;

        public ReplayListWidget(class_310 minecraftClient, int i, int j, int k, int l, int m, ReplayListWidget oldWidget) {
            super(minecraftClient, i, j, k, l, m);
            this.replayFiles = new CopyOnWriteArrayList();
            boolean needLoad = true;
            if (oldWidget != null && !oldWidget.replayFiles.isEmpty()) {
                this.replayFiles.addAll(oldWidget.replayFiles);
                needLoad = false;
            }
            this.filter(needLoad);
        }

        public boolean method_25316() {
            return ReplayListScreen.this.method_25399() == this;
        }

        protected int method_25329() {
            return super.method_25329() + 20 + 5;
        }

        public int method_25322() {
            return super.method_25322() + 50;
        }

        public void filter(boolean load) {
            this.method_25339();
            if (load) {
                this.replayFiles.clear();
                MCSRRankedClient.THREAD_EXECUTOR.submit(() -> ReplayManager.getAllReplayFiles(rp -> this.replayFiles.add(new Pair<ReplayRecordFile, Boolean>((ReplayRecordFile)rp, false))));
            } else {
                for (Pair<ReplayRecordFile, Boolean> replayFile : this.replayFiles) {
                    ((Pair)replayFile).second = false;
                }
            }
            this.tick();
            this.method_25307(0.0);
        }

        public void tick() {
            for (Pair<ReplayRecordFile, Boolean> replayFilePair : this.replayFiles) {
                if (((Boolean)((Pair)replayFilePair).second).booleanValue()) continue;
                String name = ((ReplayRecordFile)((Pair)replayFilePair).first).getName().toLowerCase(Locale.ROOT);
                if (!ReplayListScreen.this.searchQuery.isEmpty() && !ReplayListScreen.this.searchQuery.contains(name) && !name.contains(ReplayListScreen.this.searchQuery)) continue;
                ((Pair)replayFilePair).second = true;
                this.method_25321((class_350.class_351)new Entry((ReplayRecordFile)((Pair)replayFilePair).first));
            }
        }

        private class Pair<T, R> {
            private final T first;
            private R second;

            Pair(T first, R second) {
                this.first = first;
                this.second = second;
            }
        }

        public class Entry
        extends class_4280.class_4281<Entry> {
            private long lastClicked = 0L;
            private final ReplayRecordFile replayRecordFile;

            public Entry(ReplayRecordFile replayRecordFile) {
                this.replayRecordFile = replayRecordFile;
            }

            public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                String fullText = this.replayRecordFile.getName();
                int maxWidth = entryWidth - 8;
                String ellipsis = "\u2026";
                int ellipsisWidth = ReplayListScreen.this.field_22793.method_1727(ellipsis);
                StringBuilder visibleText = new StringBuilder();
                int currentWidth = 0;
                boolean trimmed = false;
                for (int i = 0; i < fullText.length(); ++i) {
                    String ch = String.valueOf(fullText.charAt(i));
                    int charWidth = ReplayListScreen.this.field_22793.method_1727(ch);
                    if (currentWidth + charWidth + ellipsisWidth > maxWidth) {
                        trimmed = true;
                        break;
                    }
                    visibleText.append(ch);
                    currentWidth += charWidth;
                }
                if (trimmed) {
                    visibleText.append(ellipsis);
                }
                ReplayListWidget.this.method_27535(matrices, ReplayListScreen.this.field_22793, (class_5348)new class_2585(visibleText.toString()), x + 2, y + 4, 0xFFFFFF);
                class_327 class_3272 = ReplayListScreen.this.field_22793;
                class_5250 class_52502 = new class_2585("").method_10852((class_2561)new class_2585(ClientUtils.timeToDurationFormat(this.replayRecordFile.getFile().lastModified())).method_27692(class_124.field_1062)).method_27693(" - ").method_10852((class_2561)new class_2588(this.replayRecordFile.getMeta().getMatchType().getKey()).method_27692(class_124.field_1077));
                Objects.requireNonNull(ReplayListScreen.this.field_22793);
                ReplayListWidget.this.method_27535(matrices, class_3272, (class_5348)class_52502, x + 2, y - 3 + entryHeight - 9, 0xFFFFFF);
                if (hovered) {
                    ArrayList targetTooltips = Lists.newArrayList();
                    targetTooltips.add(new class_2588("projectelo.text.match_date").method_27692(class_124.field_1054).method_10852((class_2561)new class_2585(": " + ClientUtils.timeToDurationFormat(this.replayRecordFile.getMeta().getDate().getTime())).method_27692(class_124.field_1068)));
                    targetTooltips.add(new class_2588("projectelo.text.match.final_time").method_27692(class_124.field_1054).method_10852((class_2561)new class_2585(": " + InGameTimerUtils.timeToStringFormat((long)this.replayRecordFile.getMeta().getResult().getTime())).method_27692(class_124.field_1068)));
                    BasePlayer winner = null;
                    for (BasePlayer player : this.replayRecordFile.getMeta().getPlayers()) {
                        if (!player.getUUID().equals(this.replayRecordFile.getMeta().getResult().getWinner())) continue;
                        winner = player;
                        break;
                    }
                    targetTooltips.add(new class_2588("projectelo.text.match.winner").method_27692(class_124.field_1054).method_10852((class_2561)new class_2585(": " + (winner == null ? "[None]" : winner.getNickname())).method_27692(class_124.field_1068)));
                    ReplayListScreen.this.tooltips = targetTooltips;
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (System.currentTimeMillis() - this.lastClicked <= 500L) {
                    this.play();
                    return true;
                }
                this.lastClicked = System.currentTimeMillis();
                ReplayListScreen.this.replayListWidget.method_25313((class_350.class_351)this);
                ReplayListScreen.this.onSelectEntry();
                return false;
            }

            public void edit() {
                ReplayListScreen.this.openScreen(new ReplayEditScreen((class_437)ReplayListScreen.this, this.replayRecordFile));
            }

            public void delete() {
                ReplayListScreen.this.openScreen(new ReplayDeleteConfirmScreen(ReplayListScreen.this, this.replayRecordFile, () -> {
                    try {
                        Files.delete(this.replayRecordFile.getFile().toPath());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        ReplayListScreen.this.onSelectEntry();
                        return;
                    }
                    for (Pair replayFile : ReplayListWidget.this.replayFiles) {
                        if (this.replayRecordFile != replayFile.first) continue;
                        ReplayListWidget.this.replayFiles.remove(replayFile);
                        break;
                    }
                    ReplayListWidget.this.method_25330((class_350.class_351)this);
                    ReplayListScreen.this.onSelectEntry();
                }));
            }

            public void play() {
                ReplayManager.playReplayProcessor(ReplayListScreen.this, this.replayRecordFile);
            }
        }
    }
}

