/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.toast;

import com.google.common.collect.Queues;
import com.mcsrranked.client.gui.toast.ToastContext;
import com.mcsrranked.client.utils.ClientUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Queue;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ToastHud
extends class_332 {
    private static final Queue<ToastContext> toastQueue = Queues.newConcurrentLinkedQueue();
    private static final int animateDuration = 7000;
    private final class_310 client;
    private ToastContext lastToast = null;
    private long lastUpdate = 0L;

    public static void addQueue(ToastContext toast) {
        toastQueue.add(toast);
    }

    public ToastHud(class_310 client) {
        this.client = client;
    }

    public void render(class_4587 matrixStack) {
        if (toastQueue.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        ToastContext target = toastQueue.peek();
        if (target != this.lastToast) {
            this.lastToast = target;
            this.lastUpdate = currentTime;
            if (target != null) {
                ClientUtils.playSound(class_3417.field_14709, 1.0f, this.client.field_1690.method_1630(class_3419.field_15248) * 0.7f);
            }
        }
        if (currentTime > this.lastUpdate + 7000L) {
            toastQueue.poll();
        }
        if (target == null) {
            return;
        }
        RenderSystem.pushMatrix();
        long duration = currentTime - this.lastUpdate;
        if (duration < 1000L) {
            RenderSystem.translated((double)0.0, (double)class_3532.method_16436((double)Math.pow(1.0 - (double)duration / 1000.0, 2.5), (double)0.0, (double)-60.0), (double)0.0);
        } else if (duration > 6000L) {
            RenderSystem.translated((double)0.0, (double)class_3532.method_16436((double)Math.pow(1.0 - (double)(7000L - duration) / 1000.0, 2.5), (double)0.0, (double)-60.0), (double)0.0);
        }
        int windowWidth = this.client.method_22683().method_4486();
        int baseY = 12;
        int toastWidth = 30;
        int iconWidth = 32;
        class_5250 title = target.getTitleText().method_27692(class_124.field_1054);
        class_2561 achieveText = target.getText();
        int textMaxWidth = Math.max(this.client.field_1772.method_27525((class_5348)achieveText), this.client.field_1772.method_27525((class_5348)title));
        RenderSystem.enableBlend();
        ToastHud.method_25294((class_4587)matrixStack, (int)((windowWidth - (toastWidth += textMaxWidth + iconWidth + 4)) / 2), (int)baseY, (int)((windowWidth + toastWidth) / 2), (int)(baseY + iconWidth + 6), (int)-587202560);
        RenderSystem.disableBlend();
        int iconLeft = (windowWidth - (textMaxWidth + iconWidth)) / 2 - 4;
        target.renderIcon(matrixStack, iconLeft, baseY + 3);
        this.client.field_1772.method_27517(matrixStack, (class_5348)title, (float)(iconLeft + iconWidth + 4), (float)(baseY + 8), 0xFFFFFF);
        this.client.field_1772.method_27517(matrixStack, (class_5348)achieveText, (float)(iconLeft + iconWidth + 4), (float)(baseY + 20), 0xFFFFFF);
        RenderSystem.popMatrix();
    }
}

