/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.google.common.collect.Lists;
import com.mcsrranked.client.info.match.server.BaseMatchData;
import com.mcsrranked.client.info.match.server.EloChange;
import com.mcsrranked.client.utils.ClientUtils;
import com.mcsrranked.client.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2585;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class EloChangeChartWidget
extends class_332
implements class_4068,
class_364 {
    private int x;
    private int y;
    private int width;
    private int height;
    private final class_327 textRenderer;
    private UUID targetUUID = null;
    private final CopyOnWriteArrayList<BaseMatchData> matchResults = Lists.newCopyOnWriteArrayList();
    private List<class_5348> targetToolTip = null;
    private int matchCount;
    private int minElo;
    private int maxElo;

    public EloChangeChartWidget(int x, int y, int width, int height, class_327 textRenderer) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textRenderer = textRenderer;
    }

    public void updatePos(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void updateMatchList(UUID targetPlayer, List<BaseMatchData> matchDataList) {
        this.targetUUID = targetPlayer;
        this.matchResults.clear();
        this.matchCount = 0;
        this.minElo = Integer.MAX_VALUE;
        this.maxElo = 0;
        for (BaseMatchData matchData : matchDataList) {
            EloChange eloChange = matchData.getEloChangeByUUID(this.targetUUID);
            if (eloChange == null || eloChange.getEloRate() == null) continue;
            this.minElo = Math.min(eloChange.getEloRate() + eloChange.getChange(), this.minElo);
            this.maxElo = Math.max(eloChange.getEloRate() + eloChange.getChange(), this.maxElo);
            ++this.matchCount;
            this.matchResults.add(matchData);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.targetUUID == null || this.matchCount < 2) {
            return;
        }
        RenderSystem.pushMatrix();
        class_332.method_25294((class_4587)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)class_5253.class_5254.method_27764((int)100, (int)0, (int)0, (int)0));
        Objects.requireNonNull(this.textRenderer);
        int maxHeight = this.height - 9 - 2;
        float steps = maxHeight >= 64 ? 4 : 2;
        int i = 0;
        while ((float)i <= steps) {
            int targetElo = (int)((float)(this.maxElo - this.minElo) / steps * (float)i + (float)this.minElo);
            int targetY = (int)((float)(maxHeight - 2) / steps * (steps - (float)i) + (float)this.y + 2.0f);
            this.textRenderer.method_1720(matrices, String.valueOf(targetElo), (float)(this.x + 26 - this.textRenderer.method_1727(String.valueOf(targetElo))), (float)targetY, 0xFFFFFF);
            RenderUtils.drawLine(matrices, this.x + 30, targetY + 4, this.x + this.width - 2, targetY + 4, 0.5f, i % 2 == 1 ? 0x44FFFFFF : -2130706433);
            ++i;
        }
        int index = 0;
        this.targetToolTip = null;
        class_3545 previousNodePos = null;
        ArrayList targetNodeList = Lists.newArrayList();
        for (BaseMatchData matchData : this.matchResults) {
            EloChange eloChange = matchData.getEloChangeByUUID(this.targetUUID);
            int nodeScore = eloChange.getEloRate() + eloChange.getChange();
            int nodeHeight = (int)((1.0f - (float)(nodeScore - this.minElo) / (float)(this.maxElo - this.minElo)) * (float)(maxHeight - 2));
            int nodeX = this.x + 30 + (int)((float)index / (float)(this.matchCount - 1) * (float)(this.width - 42));
            int nodeY = this.y + 2 + nodeHeight;
            if (mouseX >= nodeX && mouseX < nodeX + 8 && mouseY >= nodeY && mouseY < nodeY + 8) {
                this.targetToolTip = Lists.newArrayList((Object[])new class_5348[]{new class_2585("Elo: " + nodeScore).method_27692(class_124.field_1054), new class_2585(ClientUtils.timeToDurationFormat(matchData.getDate().getTime()))});
                if (matchData.isDecayed()) {
                    this.targetToolTip.add((class_5348)new class_2585("(" + class_1074.method_4662((String)"projectelo_tooltip.elo_decay", (Object[])new Object[0]) + ")").method_27692(class_124.field_1080));
                }
            }
            if (previousNodePos != null && matchData.getResult() != null) {
                int color = this.targetUUID.equals(matchData.getResult().getWinner()) ? -15409956 : (matchData.getResult().getWinner() == null ? -256 : -43434);
                RenderUtils.drawLine(matrices, nodeX + 4, nodeY + 4, (Integer)previousNodePos.method_15442() + 4, (Integer)previousNodePos.method_15441() + 4, 1.0f, color);
            }
            previousNodePos = new class_3545((Object)nodeX, (Object)nodeY);
            targetNodeList.add(previousNodePos);
            ++index;
        }
        for (class_3545 integerIntegerPair : targetNodeList) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.75f, (float)0.75f, (float)0.0f);
            RenderUtils.renderPlayerHead(this.targetUUID, matrices, (int)(((double)((Integer)integerIntegerPair.method_15442()).intValue() + 1.5) * 4.0 / 3.0), (int)(((double)((Integer)integerIntegerPair.method_15441()).intValue() + 1.5) * 4.0 / 3.0), 8, 8);
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
    }

    public List<class_5348> getTargetToolTip() {
        return this.targetToolTip;
    }
}

