/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.google.common.collect.Queues;
import com.mcsrranked.client.config.RankedOptions;
import com.mcsrranked.client.utils.ClientUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.speedrunigt.option.SpeedRunOption;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class GeometryDashWidget
implements class_4068,
class_364 {
    private static final char CUBE = '\u25a0';
    private static final char SPIKE = '\u25b3';
    private static final int GRAVITY = 400;
    private static final float SPIKE_WIDTH_HITBOX = 0.6f;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final class_327 textRenderer;
    private final Random random = new Random();
    private final Queue<Spike> spikes = Queues.newArrayDeque();
    private boolean isVisible = false;
    private GamePlay currentGamePlay = GamePlay.IDLE;
    private boolean isLanded = true;
    private long lastFrameTime = 0L;
    private long nextSpikeTime = 0L;
    private long jumpTime = 0L;
    private double speed = 1.0;
    private double cubeX = 0.0;
    private double cubeY = 0.0;

    public GeometryDashWidget(int x, int y, int width, int height, class_327 textRenderer) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textRenderer = textRenderer;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!this.isVisible) {
            return;
        }
        this.update();
        float cubeDrawX = (float)this.x + (float)this.width * 0.3f;
        float cubeDrawY = (float)this.y + (float)this.height * 0.3f;
        RenderSystem.pushMatrix();
        for (Spike spike : this.spikes) {
            double d = spike.getX() - this.cubeX;
            Objects.requireNonNull(this.textRenderer);
            float spikeDrawX = (float)(d * 9.0);
            this.textRenderer.method_1729(matrices, String.valueOf('\u25b3'), cubeDrawX + spikeDrawX, cubeDrawY, 0xFFFFFF);
        }
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        Objects.requireNonNull(this.textRenderer);
        RenderSystem.translated((double)0.0, (double)(-(this.cubeY * 9.0)), (double)0.0);
        this.textRenderer.method_1729(matrices, String.valueOf('\u25a0'), cubeDrawX, cubeDrawY, this.currentGamePlay != GamePlay.DEAD ? 0xFFFFFF : 0xFF0000);
        RenderSystem.popMatrix();
        int bestScore = (Integer)SpeedRunOption.getOption(RankedOptions.BEST_GD_SCORE);
        class_2588 statusText = new class_2588("projectelo.geometry_dash." + this.currentGamePlay.name().toLowerCase(Locale.ROOT), new Object[]{bestScore});
        int currentScore = this.getScore();
        class_2588 scoreText = new class_2588("projectelo.geometry_dash.status", new Object[]{currentScore, bestScore});
        int maxTextWidth = Math.max(this.textRenderer.method_27525((class_5348)statusText), this.textRenderer.method_27525((class_5348)scoreText));
        class_332.method_25294((class_4587)matrices, (int)((int)((float)this.x + (float)(this.width - maxTextWidth) / 2.0f) - 3), (int)((int)((float)this.y + (float)this.height * 0.6f - 2.0f)), (int)((int)((float)this.x + (float)(this.width + maxTextWidth) / 2.0f) + 3), (int)(this.y + this.height + 2), (int)class_5253.class_5254.method_27764((int)150, (int)0, (int)0, (int)0));
        this.textRenderer.method_27528(matrices, (class_5348)statusText, (float)this.x + (float)(this.width - this.textRenderer.method_27525((class_5348)statusText)) / 2.0f, (float)this.y + (float)this.height * 0.8f, 0xFFFFFF);
        this.textRenderer.method_27528(matrices, (class_5348)scoreText, (float)this.x + (float)(this.width - this.textRenderer.method_27525((class_5348)scoreText)) / 2.0f, (float)this.y + (float)this.height * 0.6f, 0xFFFFFF);
        this.lastFrameTime = System.currentTimeMillis();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.isVisible) {
            return false;
        }
        if (keyCode == 265) {
            if (this.currentGamePlay != GamePlay.PLAYING) {
                this.start();
            } else if (this.isLanded) {
                this.jump();
            }
        }
        return false;
    }

    public void update() {
        if (this.lastFrameTime == 0L || this.currentGamePlay != GamePlay.PLAYING) {
            return;
        }
        long current = System.currentTimeMillis();
        double xProgress = (double)(current - this.lastFrameTime) / 100.0 * this.speed;
        this.cubeX += xProgress;
        this.speed = 1.0 + this.cubeX / 2000.0;
        if (!this.isLanded) {
            if (current >= this.jumpTime + 400L) {
                this.isLanded = true;
                this.cubeY = 0.0;
            } else {
                float jumpDuration = (float)(current - this.jumpTime) / 200.0f;
                this.cubeY = class_3532.method_15390((double)0.0, (double)2.8f, (double)(-Math.pow((jumpDuration >= 1.0f ? 2.0f - jumpDuration : jumpDuration) - 1.0f, 2.0) + 1.0));
            }
        }
        if (this.nextSpikeTime < current) {
            double spikeX = this.cubeX + 12.0;
            int spikeCount = 1 + this.random.nextInt(class_3532.method_15357((double)(this.speed * 1.9)));
            for (int i = 0; i < spikeCount; ++i) {
                this.spikes.add(new Spike(spikeX + (double)i));
            }
            this.nextSpikeTime = current + (long)this.random.nextInt(1200) + 800L;
        }
        Spike pastSpike = this.spikes.peek();
        while (pastSpike != null && pastSpike.getMaxX() + 4.0 < this.cubeX) {
            this.spikes.poll();
            pastSpike = this.spikes.peek();
        }
        for (Spike spike : this.spikes) {
            if (!spike.isCollided(this.cubeX, this.cubeX + 0.38, this.cubeY)) continue;
            this.destroy();
            break;
        }
    }

    public void jump() {
        if (!this.isLanded || this.currentGamePlay != GamePlay.PLAYING) {
            return;
        }
        this.isLanded = false;
        this.jumpTime = System.currentTimeMillis();
    }

    public void start() {
        if (!this.isVisible) {
            return;
        }
        this.currentGamePlay = GamePlay.PLAYING;
        this.speed = 1.0;
        this.cubeX = 0.0;
        this.cubeY = 0.0;
        this.spikes.clear();
        this.isLanded = true;
        this.nextSpikeTime = 0L;
        this.jumpTime = 0L;
    }

    public void destroy() {
        if (!this.isVisible || this.currentGamePlay != GamePlay.PLAYING) {
            return;
        }
        this.currentGamePlay = GamePlay.DEAD;
        ClientUtils.playSound(class_3417.field_15115, 1.5f, 0.5f);
        SpeedRunOption.setOption(RankedOptions.BEST_GD_SCORE, (Object)Math.max(this.getScore(), (Integer)SpeedRunOption.getOption(RankedOptions.BEST_GD_SCORE)));
    }

    public int getScore() {
        return (int)(this.cubeX / 20.0);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static enum GamePlay {
        IDLE,
        PLAYING,
        DEAD;

    }

    private static class Spike {
        private final double x;

        private Spike(double x) {
            this.x = x;
        }

        public double getX() {
            return this.x;
        }

        public double getMinX() {
            return this.x - (double)0.3f;
        }

        public double getMaxX() {
            return this.x + (double)0.3f;
        }

        public boolean isCollided(double playerMinX, double playerMaxX, double playerY) {
            if (playerY >= 0.6) {
                return false;
            }
            return this.getMinX() <= playerMinX && this.getMaxX() >= playerMinX || this.getMinX() <= playerMaxX && this.getMaxX() >= playerMaxX;
        }
    }
}

