/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.google.common.collect.Lists;
import com.mcsrranked.client.MCSRRankedClient;
import com.mcsrranked.client.gui.widget.FreeSizeButtonWidget;
import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.info.match.online.JoinRequestRemoval;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.interaction.AutoRequestManager;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.utils.RenderUtils;
import com.mcsrranked.client.utils.UUIDUtils;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class MatchJoinRequestListWidget
extends class_4265<Entry>
implements RankedEntryListWidget {
    private final class_437 currentScreen;
    private class_3545<Long, class_2561> lastMessage = null;
    private boolean hasNew = false;

    public MatchJoinRequestListWidget(class_310 minecraftClient, class_437 currentScreen) {
        super(minecraftClient, currentScreen.field_22789, currentScreen.field_22790, 52, currentScreen.field_22790 - 30, 20);
        this.currentScreen = currentScreen;
    }

    public void onReceivedRequest(OnlinePlayer onlinePlayer) {
        class_310.method_1551().execute(() -> {
            Entry targetEntry = new Entry(onlinePlayer);
            if (AutoRequestManager.contains(onlinePlayer.getNickname()) || AutoRequestManager.contains(onlinePlayer.getUUID().toString())) {
                targetEntry.send(true);
                MCSRRankedClient.LOGGER.info("Accepted " + onlinePlayer.getNickname() + " by auto accept");
            } else {
                this.method_25321((class_350.class_351)targetEntry);
                this.hasNew = true;
            }
        });
    }

    public void onRemovedRequest(UUID uuid, JoinRequestRemoval reason) {
        class_310.method_1551().execute(() -> {
            OnlinePlayer removed = this.tryRemoveRequest(uuid);
            if (reason != JoinRequestRemoval.CANCELED && removed != null) {
                this.lastMessage = new class_3545((Object)System.currentTimeMillis(), (Object)new class_2588("projectelo.toast.join_request_" + reason.name().toLowerCase(Locale.ROOT), new Object[]{removed.getNickname()}));
            }
        });
    }

    public void onRemovedAllRequest(Collection<UUID> uuids, JoinRequestRemoval reason) {
        class_310.method_1551().execute(() -> {
            for (UUID uuid : uuids) {
                this.tryRemoveRequest(uuid);
            }
            if (reason != JoinRequestRemoval.CANCELED) {
                this.lastMessage = new class_3545((Object)System.currentTimeMillis(), (Object)new class_2588("projectelo.toast.join_request_" + reason.name().toLowerCase(Locale.ROOT)));
            }
        });
    }

    public boolean hasNewRequest() {
        return this.hasNew;
    }

    public OnlinePlayer tryRemoveRequest(UUID uuid) {
        for (Entry child : this.method_25396()) {
            if (!child.onlinePlayer.getUUID().equals(uuid)) continue;
            this.method_25330((class_350.class_351)child);
            return child.onlinePlayer;
        }
        return null;
    }

    public void acceptAll() {
        if (this.method_25396().isEmpty()) {
            return;
        }
        SocketInstance.getInstance().emit("p$req_result_all", true);
        for (Entry child : this.method_25396()) {
            child.buttons.forEach(buttonWidget -> {
                buttonWidget.field_22763 = false;
            });
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.lastMessage != null && (Long)this.lastMessage.method_15442() + 3000L > System.currentTimeMillis()) {
            int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.lastMessage.method_15441());
            class_332.method_25294((class_4587)matrices, (int)((this.field_22742 - textWidth) / 2 - 4), (int)(this.field_19086 - 19), (int)((this.field_22742 - textWidth) / 2 + textWidth + 4), (int)(this.field_19086 - 6), (int)-2013265920);
            this.currentScreen.method_27535(matrices, class_310.method_1551().field_1772, (class_5348)this.lastMessage.method_15441(), (this.field_22742 - textWidth) / 2, this.field_19086 - 16, 0xFFFFFF);
        }
        this.hasNew = false;
    }

    public static class Entry
    extends class_4265.class_4266<Entry> {
        private final List<class_339> buttons = Lists.newArrayList();
        private final FreeSizeButtonWidget acceptButton;
        private final FreeSizeButtonWidget denyButton;
        public final OnlinePlayer onlinePlayer;

        public Entry(OnlinePlayer onlinePlayer) {
            this.onlinePlayer = onlinePlayer;
            this.acceptButton = new FreeSizeButtonWidget(0, 0, 18, 18, (class_2561)new class_2585("\u2714").method_27695(new class_124[]{class_124.field_1067, class_124.field_1060}), button -> this.send(true));
            this.buttons.add((class_339)this.acceptButton);
            this.denyButton = new FreeSizeButtonWidget(0, 0, 18, 18, (class_2561)new class_2585("\u274c").method_27695(new class_124[]{class_124.field_1067, class_124.field_1061}), button -> this.send(false));
            this.buttons.add((class_339)this.denyButton);
        }

        public void send(boolean accept) {
            this.buttons.forEach(buttonWidget -> {
                buttonWidget.field_22763 = false;
            });
            SocketInstance.getInstance().emit("p$req_result", UUIDUtils.toString(this.onlinePlayer.getUUID()), accept ? 1 : 0);
        }

        public List<? extends class_364> method_25396() {
            return this.buttons;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            RenderUtils.renderPlayerHead(this.onlinePlayer.getUUID(), matrices, x, y + 2, 16, 16);
            String nickname = this.onlinePlayer.getNickname();
            textRenderer.method_1720(matrices, nickname, (float)(x + 20), (float)(y + 6), 0xFFFFFF);
            textRenderer.method_27517(matrices, (class_5348)new class_2585(String.format(" (%s)", index + 1)).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), (float)(x + 20 + 2 + textRenderer.method_1727(nickname)), (float)(y + 6), 0xFFFFFF);
            this.denyButton.field_22760 = x + entryWidth - this.denyButton.method_25368();
            this.denyButton.field_22761 = y + (entryHeight - this.denyButton.method_25364()) / 2;
            this.acceptButton.field_22760 = this.denyButton.field_22760 - 4 - this.acceptButton.method_25368();
            this.acceptButton.field_22761 = this.denyButton.field_22761;
            for (class_339 button : this.buttons) {
                button.method_25394(matrices, mouseX, mouseY, tickDelta);
            }
        }
    }
}

