/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.google.common.collect.Lists;
import com.mcsrranked.client.gui.RankedScreenTexts;
import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.gui.widget.TimeFormatFieldWidget;
import com.mcsrranked.client.info.match.online.MatchFlag;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.player.PlayerPermission;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4893;
import net.minecraft.class_5348;

public class MatchOptionListWidget
extends class_4265<MatchOptionEntry>
implements class_4893,
RankedEntryListWidget {
    private final class_437 currentScreen;
    private OnlineMatch onlineMatch;
    private final boolean flagsOnly;

    public MatchOptionListWidget(class_310 minecraftClient, class_437 currentScreen, OnlineMatch onlineMatch, boolean flagsOnly) {
        super(minecraftClient, currentScreen.field_22789 - 80, currentScreen.field_22790, 24, currentScreen.field_22790, 22);
        this.currentScreen = currentScreen;
        this.onlineMatch = onlineMatch;
        this.flagsOnly = flagsOnly;
        this.method_25333(80);
    }

    protected int method_25329() {
        return this.field_19087 - 8;
    }

    public void updateEntries(OnlineMatch onlineMatch) {
        this.onlineMatch = onlineMatch;
        this.method_25339();
        if (this.flagsOnly) {
            for (MatchFlag.Type value : MatchFlag.Type.sortedValues()) {
                if (!value.isShown()) continue;
                this.method_25321((class_350.class_351)new MatchFlagEntry(value));
            }
            this.method_25321((class_350.class_351)new MatchTextEntry(class_2585.field_24366));
            this.method_25321((class_350.class_351)new MatchTextEntry(class_2585.field_24366));
        } else {
            boolean customNameAvailable = onlineMatch.checkPermission(PlayerPermission::isCustomRoomName, false);
            this.method_25321((class_350.class_351)new MatchTextEntry((class_2561)new class_2588("projectelo.text.room_name").method_27692(customNameAvailable ? class_124.field_1068 : class_124.field_1061)));
            MatchTextFieldEntry roomNameField = new MatchTextFieldEntry(this.onlineMatch.getOption().getRoomName(), 32, text -> this.onlineMatch.getOption().setRoomName((String)text), (class_2561)new class_2588("projectelo.text.room_name.description", new Object[]{32, "Iron Pickaxe"}));
            roomNameField.setActive(customNameAvailable);
            this.method_25321((class_350.class_351)roomNameField);
            this.method_25321((class_350.class_351)new MatchTextEntry(class_2585.field_24366));
            if (onlineMatch.checkPermission(PlayerPermission::isCustomBackgroundImage, false).booleanValue()) {
                this.method_25321((class_350.class_351)new MatchTextEntry((class_2561)new class_2588("projectelo.text.waiting_image_url")));
                this.method_25321((class_350.class_351)new MatchTextFieldEntry(this.onlineMatch.getOption().getWaitingImageUrl(), 256, text -> this.onlineMatch.getOption().setWaitingImageUrl((String)text), (class_2561)new class_2588("projectelo.text.waiting_image_url.description")));
                this.method_25321((class_350.class_351)new MatchTextEntry(class_2585.field_24366));
            }
            this.method_25321((class_350.class_351)new MatchTextEntry((class_2561)new class_2588("projectelo.text.start_command")));
            this.method_25321((class_350.class_351)new MatchTextFieldEntry(this.onlineMatch.getOption().getCommand(), 32500, text -> this.onlineMatch.getOption().setCommand((String)text), (class_2561)new class_2588("projectelo.text.start_command.description", new Object[]{32500})));
            this.method_25321((class_350.class_351)new MatchTextEntry(class_2585.field_24366));
            this.method_25321((class_350.class_351)new MatchTextEntry((class_2561)new class_2588("projectelo.text.match_time_limit")));
            MatchTimeFieldEntry timeLimitEntry = new MatchTimeFieldEntry(this.onlineMatch.getOption().getTimeLimit(), seconds -> this.onlineMatch.getOption().setTimeLimit(seconds != null ? seconds : 0), (class_2561)new class_2588("projectelo.text.match_time_limit.description")){

                @Override
                public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                    super.method_25343(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
                    MatchOptionListWidget.this.currentScreen.method_27535(matrices, ((MatchOptionListWidget)MatchOptionListWidget.this).field_22740.field_1772, (class_5348)new class_2588("projectelo.text.time_format"), x + 45, y + 7, 0xFFFFFF);
                }
            };
            timeLimitEntry.setWidth(42);
            this.method_25321((class_350.class_351)timeLimitEntry);
            this.method_25321((class_350.class_351)new MatchTextEntry(class_2585.field_24366));
            this.method_25321((class_350.class_351)new MatchTextEntry((class_2561)new class_2588("projectelo.text.match_time_limit_after_first_completion")));
            MatchTimeFieldEntry timeAttackEntry = new MatchTimeFieldEntry(this.onlineMatch.getOption().getTimeAttack(), seconds -> this.onlineMatch.getOption().setTimeAttack(seconds != null ? seconds : 0), (class_2561)new class_2588("projectelo.text.match_time_limit_after_first_completion.description")){

                @Override
                public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                    super.method_25343(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
                    MatchOptionListWidget.this.currentScreen.method_27535(matrices, ((MatchOptionListWidget)MatchOptionListWidget.this).field_22740.field_1772, (class_5348)new class_2588("projectelo.text.time_format"), x + 45, y + 7, 0xFFFFFF);
                }
            };
            timeAttackEntry.setWidth(42);
            this.method_25321((class_350.class_351)timeAttackEntry);
            this.method_25321((class_350.class_351)new MatchTextEntry(class_2585.field_24366));
        }
    }

    public MatchFlag getMatchFlag() {
        return this.onlineMatch.getOption().getFlag();
    }

    public void method_25393() {
        for (MatchOptionEntry child : this.method_25396()) {
            child.tick();
        }
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        if (mouseY < (double)this.field_19085 || mouseY > (double)this.field_19086) {
            return Optional.empty();
        }
        return super.method_19355(mouseX, mouseY);
    }

    public class MatchFlagEntry
    extends MatchOptionEntry
    implements ToolTipEntry {
        private final MatchFlag.Type value;
        private final class_4185 toggleButton;

        public MatchFlagEntry(MatchFlag.Type value) {
            this.value = value;
            Supplier<class_2561> toggleSupplier = () -> MatchOptionListWidget.this.getMatchFlag().isEnableFlag(this.value) ? RankedScreenTexts.ON.text().method_27695(new class_124[]{class_124.field_1067, class_124.field_1060}) : RankedScreenTexts.OFF.text().method_27695(new class_124[]{class_124.field_1067, class_124.field_1061});
            this.toggleButton = new class_4185(0, 0, 40, 20, toggleSupplier.get(), button -> {
                MatchOptionListWidget.this.getMatchFlag().setFlag(this.value, !MatchOptionListWidget.this.getMatchFlag().isEnableFlag(this.value));
                button.method_25355((class_2561)toggleSupplier.get());
            });
            this.method_25396().add((class_339)this.toggleButton);
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 textRenderer = ((MatchOptionListWidget)MatchOptionListWidget.this).field_22740.field_1772;
            class_437 class_4372 = MatchOptionListWidget.this.currentScreen;
            class_2588 class_25882 = new class_2588("projectelo.match_flag." + this.value.name().toLowerCase(Locale.ROOT));
            Objects.requireNonNull(textRenderer);
            class_4372.method_27535(matrices, textRenderer, (class_5348)class_25882, x, y + (entryHeight + 9) / 4, 0xFFFFFF);
            this.toggleButton.field_22760 = x + entryWidth - this.toggleButton.method_25368();
            this.toggleButton.field_22761 = y + 1;
            this.toggleButton.method_25394(matrices, mouseX, mouseY, tickDelta);
        }

        @Override
        public class_2561 getTooltip() {
            return new class_2585("- ").method_10852((class_2561)new class_2588("projectelo.match_flag." + this.value.name().toLowerCase(Locale.ROOT))).method_27693("\n").method_10852((class_2561)new class_2588("projectelo.match_flag." + this.value.name().toLowerCase(Locale.ROOT) + ".description"));
        }

        @Override
        public void tick() {
        }
    }

    public class MatchTextEntry
    extends MatchOptionEntry {
        private final class_2561 text;

        public MatchTextEntry(class_2561 text) {
            this.text = text;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 textRenderer = ((MatchOptionListWidget)MatchOptionListWidget.this).field_22740.field_1772;
            class_437 class_4372 = MatchOptionListWidget.this.currentScreen;
            Objects.requireNonNull(textRenderer);
            class_4372.method_27535(matrices, textRenderer, (class_5348)this.text, x, y + entryHeight - 9 - 2, 0xFFFFFF);
        }

        @Override
        public void tick() {
        }
    }

    public class MatchTextFieldEntry
    extends MatchOptionEntry
    implements ToolTipEntry {
        private final class_342 textFieldWidget;
        private final class_2561 tooltip;
        private int width = 0;
        private boolean active = true;

        public MatchTextFieldEntry(String text, int maxLength, Consumer<String> changeListener, class_2561 tooltip) {
            this.textFieldWidget = new class_342(((MatchOptionListWidget)MatchOptionListWidget.this).field_22740.field_1772, 0, 0, 100, 20, class_2585.field_24366);
            this.textFieldWidget.method_1880(maxLength);
            this.textFieldWidget.method_1863(changeListener);
            this.textFieldWidget.method_1852(text == null ? "" : text);
            this.tooltip = tooltip;
            this.method_25396().add((class_339)this.textFieldWidget);
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.textFieldWidget.field_22760 = x;
            this.textFieldWidget.field_22761 = y + 1;
            this.textFieldWidget.method_1888(this.active);
            this.textFieldWidget.method_1856(this.active);
            this.textFieldWidget.method_25358(this.width == 0 ? entryWidth : this.width);
            this.textFieldWidget.method_25394(matrices, mouseX, mouseY, tickDelta);
        }

        public void setWidth(int width) {
            this.width = width;
        }

        @Override
        public class_2561 getTooltip() {
            return this.tooltip;
        }

        @Override
        public void tick() {
            this.textFieldWidget.method_1865();
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    public class MatchTimeFieldEntry
    extends MatchOptionEntry
    implements ToolTipEntry {
        private final TimeFormatFieldWidget timeFormatFieldWidget;
        private final class_2561 tooltip;
        private int width = 0;
        private boolean active = true;

        public MatchTimeFieldEntry(int time, Consumer<Integer> changeListener, class_2561 tooltip) {
            this.timeFormatFieldWidget = new TimeFormatFieldWidget(((MatchOptionListWidget)MatchOptionListWidget.this).field_22740.field_1772, 0, 0, 100, 20, changeListener);
            this.timeFormatFieldWidget.setTime(time);
            this.tooltip = tooltip;
            this.method_25396().add((class_339)this.timeFormatFieldWidget);
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.timeFormatFieldWidget.field_22760 = x;
            this.timeFormatFieldWidget.field_22761 = y + 1;
            this.timeFormatFieldWidget.method_1888(this.active);
            this.timeFormatFieldWidget.method_1856(this.active);
            this.timeFormatFieldWidget.method_25358(this.width == 0 ? entryWidth : this.width);
            this.timeFormatFieldWidget.method_25394(matrices, mouseX, mouseY, tickDelta);
        }

        public void setWidth(int width) {
            this.width = width;
        }

        @Override
        public class_2561 getTooltip() {
            return this.tooltip;
        }

        @Override
        public void tick() {
            this.timeFormatFieldWidget.method_1865();
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    public static abstract class MatchOptionEntry
    extends class_4265.class_4266<MatchOptionEntry> {
        private final List<class_339> children = Lists.newArrayList();

        public List<class_339> method_25396() {
            return this.children;
        }

        public abstract void tick();
    }

    public static interface ToolTipEntry {
        public class_2561 getTooltip();
    }
}

