/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.widget.AbstractMatchMemberListWidget;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.match.online.OnlineMatchResult;
import com.mcsrranked.client.info.match.online.PlayLog;
import com.mcsrranked.client.info.match.online.gamemode.MostPercentGameMode;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.utils.RenderUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class MatchResultMemberListWidget
extends AbstractMatchMemberListWidget<ResultEntry> {
    public MatchResultMemberListWidget(class_310 minecraftClient, RankedScreen currentScreen, OnlineMatch onlineMatch) {
        super(minecraftClient, currentScreen, onlineMatch);
    }

    @Override
    public void updatePlayerList(List<OnlinePlayer> playerList) {
        super.updatePlayerList(playerList);
        double scrolls = this.method_25341();
        CopyOnWriteArrayList<ResultEntry> newEntries = new CopyOnWriteArrayList<ResultEntry>();
        for (OnlinePlayer player : playerList) {
            newEntries.add(new ResultEntry(this.getScreen(), player, this.getOnlineMatch(), this.isCompact()));
        }
        if (this.getOnlineMatch().getResult() != null) {
            if (this.getOnlineMatch().getOption().getGameMode() instanceof MostPercentGameMode) {
                newEntries.sort((entry1, entry2) -> {
                    PlayLog pl1 = this.getOnlineMatch().getPlayLog(entry1.onlinePlayer);
                    PlayLog pl2 = this.getOnlineMatch().getPlayLog(entry2.onlinePlayer);
                    return pl2.getScore() - pl1.getScore();
                });
            } else {
                newEntries.sort((entry1, entry2) -> {
                    PlayLog pl1 = this.getOnlineMatch().getPlayLog(entry1.onlinePlayer);
                    PlayLog pl2 = this.getOnlineMatch().getPlayLog(entry2.onlinePlayer);
                    return (pl1.getResultRank() == 0 ? Integer.MAX_VALUE : pl1.getResultRank()) - (pl2.getResultRank() == 0 ? Integer.MAX_VALUE : pl2.getResultRank());
                });
            }
        }
        this.method_25314(newEntries);
        this.method_25307(scrolls);
    }

    public static class ResultEntry
    extends AbstractMatchMemberListWidget.MemberEntry<ResultEntry> {
        public ResultEntry(RankedScreen screen, OnlinePlayer onlinePlayer, OnlineMatch onlineMatch, boolean compact) {
            super(screen, onlinePlayer, onlineMatch, compact);
        }

        @Override
        public void renderWidget(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta, int adjust) {
            OnlineMatchResult matchResult = this.onlineMatch.getResult();
            if (matchResult != null) {
                if (this.onlineMatch.getOption().getGameMode() instanceof MostPercentGameMode) {
                    PlayLog playLog = this.onlineMatch.getPlayLog(this.onlinePlayer);
                    class_5250 winnerText = new class_2585(String.valueOf(playLog.getScore())).method_27695(new class_124[]{class_124.field_1067, this.onlinePlayer.getUUID().equals(matchResult.getWinner()) ? class_124.field_1054 : class_124.field_1075});
                    RenderUtils.drawOutlineText(this.screen.getClient().field_1772, matrices, (class_2561)winnerText, x + this.cv(entryWidth - 30, 16), y + this.cv(5, 23));
                } else if (this.onlinePlayer.getUUID().equals(matchResult.getWinner())) {
                    class_5250 winnerText = new class_2585("Winner!").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054});
                    RenderUtils.drawOutlineText(this.screen.getClient().field_1772, matrices, (class_2561)winnerText, x + this.cv(entryWidth - 30, 16), y + this.cv(5, 23));
                } else {
                    PlayLog playLog = this.onlineMatch.getPlayLog(this.onlinePlayer);
                    if (playLog.getResultRank() > 1) {
                        class_5250 winnerText = new class_2585("#" + playLog.getResultRank()).method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
                        RenderUtils.drawOutlineText(this.screen.getClient().field_1772, matrices, (class_2561)winnerText, x + this.cv(entryWidth - 30, 16), y + this.cv(5, 23));
                    }
                }
            }
        }
    }
}

