/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.gui.widget.AbstractMatchMemberListWidget;
import com.mcsrranked.client.gui.widget.FreeSizeButtonWidget;
import com.mcsrranked.client.info.match.MatchType;
import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.player.OnlinePlayer;
import com.mcsrranked.client.interaction.PlayerMuteManager;
import com.mcsrranked.client.socket.SocketInstance;
import com.mcsrranked.client.utils.TextureUtils;
import com.mcsrranked.client.utils.UUIDUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class MatchRoomMemberListWidget
extends AbstractMatchMemberListWidget<RoomMemberEntry> {
    public MatchRoomMemberListWidget(class_310 minecraftClient, RankedScreen currentScreen, OnlineMatch onlineMatch) {
        super(minecraftClient, currentScreen, onlineMatch);
    }

    @Override
    public void updatePlayerList(List<OnlinePlayer> playerList) {
        double scrolls = this.method_25341();
        super.updatePlayerList(playerList);
        CopyOnWriteArrayList<RoomMemberEntry> newEntries = new CopyOnWriteArrayList<RoomMemberEntry>();
        Ordering ordering = Ordering.from((p1, p2) -> ComparisonChain.start().compareTrueFirst(this.getOnlineMatch().isHost((OnlinePlayer)p1), this.getOnlineMatch().isHost((OnlinePlayer)p2)).compareTrueFirst(this.getOnlineMatch().isCoHost((OnlinePlayer)p1), this.getOnlineMatch().isCoHost((OnlinePlayer)p2)).compareTrueFirst(p1.isSpectator(), p2.isSpectator()).compareTrueFirst(p1.isMe(), p2.isMe()).result());
        for (OnlinePlayer player : ordering.sortedCopy((Iterable)Lists.newCopyOnWriteArrayList(playerList))) {
            newEntries.add(new RoomMemberEntry(this.getScreen(), player, this.getOnlineMatch(), this.isCompact()));
        }
        this.method_25314(newEntries);
        this.method_25307(scrolls);
    }

    public int method_25322() {
        return super.method_25322() + 20;
    }

    public static class RoomMemberEntry
    extends AbstractMatchMemberListWidget.MemberEntry<RoomMemberEntry> {
        private final class_4185 activeButton;
        private final class_4185 promoteButton;
        private final class_4185 demoteButton;

        public RoomMemberEntry(RankedScreen screen, OnlinePlayer onlinePlayer, OnlineMatch onlineMatch, boolean compact) {
            super(screen, onlinePlayer, onlineMatch, compact);
            this.activeButton = this.onlineMatch.getType() == MatchType.PRIVATE ? new FreeSizeButtonWidget(0, 0, 40, this.cv(16, 20), class_2585.field_24366, button -> {
                if (this.onlineMatch.canManage()) {
                    SocketInstance.getInstance().emit("p$kick", UUIDUtils.toString(this.onlinePlayer.getUUID()), class_437.method_25442());
                }
                button.field_22763 = false;
            }) : new FreeSizeButtonWidget(0, 0, 40, this.cv(16, 20), (class_2561)new class_2588("projectelo.button." + (!PlayerMuteManager.isMutedPlayer(this.onlinePlayer.getUUID()) ? "mute" : "unmute")), button -> {
                boolean isMuted = PlayerMuteManager.isMutedPlayer(this.onlinePlayer.getUUID());
                if (isMuted) {
                    PlayerMuteManager.removePlayer(this.onlinePlayer.getUUID());
                } else {
                    PlayerMuteManager.addPlayer(this.onlinePlayer.getUUID());
                }
                button.method_25355((class_2561)new class_2588("projectelo.button." + (isMuted ? "mute" : "unmute")));
            });
            this.activeButton.field_22764 = false;
            this.promoteButton = new FreeSizeButtonWidget(0, 0, 20, this.cv(16, 20), class_2585.field_24366, button -> SocketInstance.getInstance().emit("p$promote", UUIDUtils.toString(this.onlinePlayer.getUUID())), (button, matrices, mouseX, mouseY) -> this.screen.setTooltip(new class_2588("projectelo.text.promote_cohost")));
            this.promoteButton.field_22764 = false;
            this.demoteButton = new FreeSizeButtonWidget(0, 0, 20, this.cv(16, 20), class_2585.field_24366, button -> SocketInstance.getInstance().emit("p$demote", UUIDUtils.toString(this.onlinePlayer.getUUID())), (button, matrices, mouseX, mouseY) -> this.screen.setTooltip(new class_2588("projectelo.text.demote_cohost")));
            this.demoteButton.field_22764 = false;
            this.addChild((class_339)this.activeButton);
            this.addChild((class_339)this.promoteButton);
            this.addChild((class_339)this.demoteButton);
        }

        @Override
        public void renderWidget(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta, int adjust) {
            this.activeButton.field_22760 = x + entryWidth - this.activeButton.method_25368();
            this.activeButton.field_22761 = y + (entryHeight - this.activeButton.method_25364()) / 2;
            boolean bl = this.activeButton.field_22764 = !this.onlinePlayer.isMe() && this.onlinePlayer.isInteractable() && (this.onlineMatch.getType() != MatchType.PRIVATE || this.onlineMatch.isHost() || !this.onlineMatch.canManage(this.onlinePlayer) && this.onlineMatch.canManage());
            if (class_437.method_25442()) {
                this.activeButton.method_25355((class_2561)new class_2588("projectelo.button.ban"));
            } else {
                if (this.activeButton.method_25405((double)mouseX, (double)mouseY) && !class_437.method_25442()) {
                    this.screen.setTooltipWithWrap(new class_2588("projectelo.text.hold_shift_to_ban"), 200);
                }
                this.activeButton.method_25355((class_2561)new class_2588("projectelo.button.kick"));
            }
            this.promoteButton.field_22760 = this.demoteButton.field_22760 = this.activeButton.field_22760 - 28;
            this.promoteButton.field_22761 = this.demoteButton.field_22761 = this.activeButton.field_22761;
            this.demoteButton.field_22764 = false;
            this.promoteButton.field_22764 = false;
            this.demoteButton.field_22763 = false;
            this.promoteButton.field_22763 = false;
            if (!this.onlinePlayer.isMe() && this.onlinePlayer.isInteractable() && this.onlineMatch.isHost()) {
                this.promoteButton.field_22764 = !this.onlineMatch.isCoHost(this.onlinePlayer) && this.onlineMatch.getCoHostList().size() < 5;
                this.promoteButton.field_22763 = this.promoteButton.field_22764;
                this.demoteButton.field_22763 = this.demoteButton.field_22764 = this.onlineMatch.isCoHost(this.onlinePlayer);
                this.screen.getClient().method_1531().method_22813(TextureUtils.DEFAULT_GUI_TEXTURE);
                if (this.promoteButton.field_22764 || this.demoteButton.field_22764) {
                    class_332.method_25293((class_4587)matrices, (int)(this.promoteButton.field_22760 + 2), (int)(this.promoteButton.field_22761 + this.cv(0, 2) + 4), (int)16, (int)8, (float)16.0f, (float)52.0f, (int)16, (int)8, (int)128, (int)128);
                    if (this.demoteButton.field_22764) {
                        class_332.method_25293((class_4587)matrices, (int)this.promoteButton.field_22760, (int)(this.promoteButton.field_22761 + this.cv(0, 2)), (int)16, (int)16, (float)32.0f, (float)48.0f, (int)16, (int)16, (int)128, (int)128);
                    }
                }
            }
        }
    }
}

