/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.mcsrranked.client.gui.widget.RankedEntryListWidget;
import com.mcsrranked.client.info.match.MatchTimeline;
import com.mcsrranked.client.info.player.BasePlayer;
import com.mcsrranked.client.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redlimerl.speedrunigt.timer.InGameTimerUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class MatchTimelineListWidget<T extends BasePlayer>
extends class_350<Entry>
implements RankedEntryListWidget {
    @NotNull
    private final class_437 currentScreen;
    private final class_327 textRenderer;
    private List<T> players;

    public MatchTimelineListWidget(class_310 minecraftClient, int width, int height) {
        Objects.requireNonNull(minecraftClient.field_1772);
        super(minecraftClient, width, height, 40, height - 40, 9 + 4);
        this.players = null;
        assert (minecraftClient.field_1755 != null);
        this.currentScreen = minecraftClient.field_1755;
        this.textRenderer = minecraftClient.field_1772;
    }

    public void updateEntries(List<MatchTimeline> timelines, List<T> players) {
        this.players = players;
        this.method_25314(timelines.stream().sorted((t1, t2) -> Math.toIntExact(t2.getTime() - t1.getTime())).map(x$0 -> new Entry((MatchTimeline)x$0)).collect(Collectors.toList()));
    }

    public void addEntry(MatchTimeline timeline) {
        this.method_25396().add(0, new Entry(timeline));
    }

    public int method_25322() {
        return (int)((float)this.currentScreen.field_22789 * 0.6f);
    }

    protected int method_25329() {
        return this.field_22742 / 2 + (this.method_25322() + 10) / 2;
    }

    protected class Entry
    extends class_350.class_351<Entry> {
        private final MatchTimeline timeline;

        private Entry(MatchTimeline timeline) {
            this.timeline = timeline;
        }

        public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_5250 originalText;
            if (MatchTimelineListWidget.this.players == null) {
                return;
            }
            BasePlayer player = MatchTimelineListWidget.this.players.stream().filter(p -> p.getUUID().equals(this.timeline.getUUID())).findFirst().orElse(null);
            if (player == null) {
                return;
            }
            String nickname = player.getNickname();
            originalText = originalText.method_10862((originalText = this.timeline.getCompactText(nickname)).method_10866().method_10984() ? originalText.method_10866() : class_2585.field_24366.method_10866());
            RenderUtils.renderPlayerHead(this.timeline.getUUID(), matrices, x, y + 1, 8, 8);
            class_5250 timeText = new class_2585(InGameTimerUtils.timeToStringFormat((long)this.timeline.getTime())).method_27692(class_124.field_1075);
            MatchTimelineListWidget.this.method_27535(matrices, MatchTimelineListWidget.this.textRenderer, (class_5348)timeText, x + 11, y + 1, 0xFFFFFF);
            int textWidth = MatchTimelineListWidget.this.textRenderer.method_27525((class_5348)originalText);
            int timeTextWidth = MatchTimelineListWidget.this.textRenderer.method_27525((class_5348)timeText);
            int textX = x + 16 + timeTextWidth;
            int remainWidth = entryWidth - 16 - timeTextWidth;
            if (textWidth - remainWidth > 0) {
                RenderSystem.pushMatrix();
                RenderUtils.enableScissor(textX, y, remainWidth, entryHeight);
                int textLength = originalText.getString().length();
                double time = (double)System.currentTimeMillis() % ((double)textLength * 120.0) / ((double)textLength * 120.0);
                double amount = class_3532.method_16436((double)(time < 0.2 ? 0.0 : (time > 0.8 ? 1.0 : (time - 0.2) / 0.6)), (double)0.0, (double)(textWidth - remainWidth));
                MatchTimelineListWidget.this.method_27535(matrices, MatchTimelineListWidget.this.textRenderer, (class_5348)originalText, (int)((double)textX - amount), y + 1, 0xFFFFFF);
                RenderUtils.disableScissor();
                RenderSystem.popMatrix();
            } else {
                MatchTimelineListWidget.this.method_27535(matrices, MatchTimelineListWidget.this.textRenderer, (class_5348)originalText, textX, y + 1, 0xFFFFFF);
            }
        }
    }
}

