/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.gui.widget;

import com.mcsrranked.client.gui.screen.RankedScreen;
import com.mcsrranked.client.info.player.PlayerTier;
import com.mcsrranked.client.utils.ClientUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class RankUpAnimationWidget
implements class_4068,
class_364 {
    public static final class_3414 RANK_UP_SOUND = new class_3414(new class_2960("mcsrranked", "ui.rank_up"));
    private final RankedScreen screen;
    private final PlayerTier beforeTier;
    private final PlayerTier afterTier;
    private boolean hasStarted = false;
    private boolean soundPlayed = false;
    private boolean isCloseable = false;
    private boolean isClosed = false;
    private long startTime = 0L;

    public RankUpAnimationWidget(RankedScreen screen, PlayerTier beforeTier, PlayerTier afterTier) {
        this.screen = screen;
        this.beforeTier = beforeTier;
        this.afterTier = afterTier;
    }

    public void startAnimate() {
        this.hasStarted = true;
    }

    public boolean isStarted() {
        return this.hasStarted;
    }

    private boolean isRankUp() {
        return !this.beforeTier.getName().equals(this.afterTier.getName());
    }

    public boolean isCloseable() {
        return this.isCloseable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean shouldRender() {
        return this.isStarted() && !this.isClosed();
    }

    public void close() {
        this.isClosed = true;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (!this.shouldRender()) {
            return;
        }
        int width = this.screen.getClient().method_22683().method_4486();
        int height = this.screen.getClient().method_22683().method_4502();
        float centerX = (float)width / 2.0f;
        float centerY = (float)height / 2.0f - 32.0f;
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        long currentTime = System.currentTimeMillis() - this.startTime;
        if (this.isRankUp()) {
            int color;
            int alpha;
            if (!this.soundPlayed && currentTime >= 800L) {
                ClientUtils.playSound(RANK_UP_SOUND, 1.0f, 0.6f);
                this.soundPlayed = true;
            }
            Pair<Float, Long> scaleInfo = this.getScale(currentTime);
            float translatedX = centerX - 13.0f * ((Float)scaleInfo.getFirst()).floatValue() / 2.0f;
            float translatedY = centerY - 13.0f * ((Float)scaleInfo.getFirst()).floatValue() / 2.0f;
            matrices.method_22903();
            RenderSystem.enableBlend();
            matrices.method_22904((double)translatedX, (double)translatedY, 0.0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)class_3532.method_15363((float)((float)currentTime / 400.0f), (float)0.0f, (float)1.0f));
            matrices.method_22905(((Float)scaleInfo.getFirst()).floatValue(), ((Float)scaleInfo.getFirst()).floatValue(), ((Float)scaleInfo.getFirst()).floatValue());
            ((Long)scaleInfo.getSecond() > 0L ? this.afterTier : this.beforeTier).renderBadge(matrices, 0, 0, 13, 13);
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)class_3532.method_15363((float)((((Float)scaleInfo.getFirst()).floatValue() - 6.0f) / 1.8f), (float)0.0f, (float)1.0f));
            class_310.method_1551().method_1531().method_22813(PlayerTier.TIER_BADGE);
            class_332.method_25293((class_4587)matrices, (int)0, (int)0, (int)13, (int)13, (float)0.0f, (float)13.0f, (int)13, (int)13, (int)104, (int)26);
            RenderSystem.popMatrix();
            RenderSystem.disableBlend();
            matrices.method_22909();
            if ((Long)scaleInfo.getSecond() > 400L) {
                matrices.method_22903();
                matrices.method_22905(3.0f, 3.0f, 1.0f);
                matrices.method_22904((double)((float)width / 6.0f), (double)((float)height / 6.0f + 5.0f), 0.0);
                alpha = (int)(class_3532.method_15363((float)((float)((Long)scaleInfo.getSecond() - 400L) / 1200.0f), (float)0.0f, (float)1.0f) * 255.0f);
                color = class_5253.class_5254.method_27764((int)alpha, (int)255, (int)255, (int)255);
                if (alpha > 10) {
                    this.screen.method_27534(matrices, this.screen.getClient().field_1772, (class_5348)new class_2585("Rank UP!").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), 0, 0, color);
                }
                alpha = (int)(class_3532.method_15363((float)((float)((Long)scaleInfo.getSecond() - 1200L) / 1200.0f), (float)0.0f, (float)1.0f) * 255.0f);
                color = class_5253.class_5254.method_27764((int)alpha, (int)255, (int)255, (int)255);
                if (alpha > 10) {
                    this.screen.method_27534(matrices, this.screen.getClient().field_1772, (class_5348)this.afterTier.getText(), 0, 10, color);
                }
                matrices.method_22909();
            }
            if ((Long)scaleInfo.getSecond() >= 3000L) {
                this.isCloseable = true;
                alpha = (int)(class_3532.method_15363((float)((float)Math.abs((Long)scaleInfo.getSecond() % 1200L - 600L) / 600.0f), (float)0.0f, (float)1.0f) * 255.0f);
                color = class_5253.class_5254.method_27764((int)alpha, (int)255, (int)255, (int)255);
                if (alpha > 10) {
                    this.screen.method_27534(matrices, this.screen.getClient().field_1772, (class_5348)new class_2588("projectelo.text.press_any_continue"), width / 2, height - 40, color);
                }
            }
        } else {
            int color;
            int alpha;
            if (!this.soundPlayed && currentTime >= 2800L) {
                ClientUtils.playSound(class_3417.field_14709, 1.0f, 1.0f);
                this.soundPlayed = true;
            }
            float scale = 6.0f;
            float translatedX = centerX - 13.0f * scale / 2.0f;
            float translatedY = centerY - 13.0f * scale / 2.0f;
            matrices.method_22903();
            RenderSystem.enableBlend();
            matrices.method_22904((double)translatedX, (double)translatedY, 0.0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)class_3532.method_15363((float)((float)currentTime / 400.0f), (float)0.0f, (float)1.0f));
            matrices.method_22905(scale, scale, scale);
            this.beforeTier.renderBadge(matrices, 0, 0, 13, 13);
            RenderSystem.disableBlend();
            matrices.method_22909();
            if (currentTime >= 400L) {
                matrices.method_22903();
                matrices.method_22905(3.0f, 3.0f, 1.0f);
                matrices.method_22904((double)((float)width / 6.0f), (double)((float)height / 6.0f + 5.0f), 0.0);
                alpha = (int)(class_3532.method_15363((float)((float)(currentTime - 400L) / 1200.0f), (float)0.0f, (float)1.0f) * 255.0f);
                color = class_5253.class_5254.method_27764((int)alpha, (int)255, (int)255, (int)255);
                if (alpha > 10) {
                    this.screen.method_27534(matrices, this.screen.getClient().field_1772, (class_5348)new class_2585("Tier UP!").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), 0, 0, color);
                }
                alpha = (int)(class_3532.method_15363((float)((float)(currentTime - 1200L) / 1200.0f), (float)0.0f, (float)1.0f) * 255.0f);
                color = class_5253.class_5254.method_27764((int)alpha, (int)255, (int)255, (int)255);
                if (alpha > 10) {
                    this.screen.method_27534(matrices, this.screen.getClient().field_1772, (class_5348)(currentTime >= 2800L ? this.afterTier : this.beforeTier).getText(), 0, 10, color);
                    if (currentTime >= 2800L && currentTime < 4000L) {
                        int changeColor = Objects.requireNonNull((this.afterTier.getFormatting() == class_124.field_1054 ? class_124.field_1068 : class_124.field_1054).method_532());
                        alpha = (int)(class_3532.method_15363((float)(1.0f - (float)(currentTime - 2800L) / 1200.0f), (float)0.0f, (float)1.0f) * 255.0f);
                        color = class_5253.class_5254.method_27764((int)alpha, (int)class_5253.class_5254.method_27765((int)changeColor), (int)class_5253.class_5254.method_27766((int)changeColor), (int)class_5253.class_5254.method_27767((int)changeColor));
                        if (alpha > 5) {
                            this.screen.method_27534(matrices, this.screen.getClient().field_1772, (class_5348)new class_2585(this.afterTier.getFullName()), 0, 10, color);
                        }
                    }
                }
                matrices.method_22909();
            }
            if (currentTime >= 4200L) {
                this.isCloseable = true;
                alpha = (int)(class_3532.method_15363((float)((float)Math.abs(currentTime % 1200L - 600L) / 600.0f), (float)0.0f, (float)1.0f) * 255.0f);
                color = class_5253.class_5254.method_27764((int)alpha, (int)255, (int)255, (int)255);
                if (alpha > 10) {
                    this.screen.method_27534(matrices, this.screen.getClient().field_1772, (class_5348)new class_2588("projectelo.text.press_any_continue"), width / 2, height - 40, color);
                }
            }
        }
    }

    private Pair<Float, Long> getScale(long currentTime) {
        float scale;
        float startScale = 6.0f;
        float peakScale = 8.0f;
        float bounceScale = 9.0f;
        float endScale = 6.0f;
        long timeToPeak = 0L;
        if (currentTime <= 800L) {
            scale = startScale;
        } else if (currentTime <= 3200L) {
            float progress = (float)(currentTime - 800L) / 2400.0f;
            scale = startScale + (peakScale - startScale) * progress;
        } else if (currentTime <= 4000L) {
            float progress = (float)(currentTime - 3200L) / 800.0f;
            scale = bounceScale + (endScale - bounceScale) * (1.0f - (float)Math.pow(1.0f - progress, 3.0));
        } else {
            scale = endScale;
        }
        if (currentTime > 3200L) {
            timeToPeak = currentTime - 3200L;
        }
        return Pair.of((Object)Float.valueOf(scale), (Object)timeToPeak);
    }
}

