/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info;

import java.time.Instant;
import java.util.Date;

public class DateDuration {
    private final long startsAt;
    private final long endsAt;

    public DateDuration(long startsAt, long endsAt) {
        this.startsAt = startsAt;
        this.endsAt = endsAt;
    }

    public Date getStartsAt() {
        return Date.from(Instant.ofEpochSecond(this.startsAt));
    }

    public Date getEndsAt() {
        return Date.from(Instant.ofEpochSecond(this.endsAt));
    }

    public boolean isEndless() {
        return this.endsAt <= 0L;
    }

    public final boolean isAvailableAtNow() {
        Date now = new Date();
        Date start = this.getStartsAt();
        if (this.isEndless() && start.getTime() < now.getTime()) {
            return true;
        }
        Date end = this.getEndsAt();
        return start.getTime() < now.getTime() && end.getTime() > now.getTime();
    }
}

