/*
 * Decompiled with CFR 0.152.
 */
package com.mcsrranked.client.info.match.online.gamemode;

import com.mcsrranked.client.info.match.online.OnlineMatch;
import com.mcsrranked.client.info.match.online.gamemode.GameMode;
import com.mcsrranked.client.socket.SocketEvent;
import com.mcsrranked.client.utils.EasyBitFlag;
import com.mcsrranked.client.world.WorldCreator;
import com.redlimerl.speedrunigt.timer.InGameTimer;

public class ScoutRouteGameMode
extends GameMode {
    private int scoutTime = 900;
    private boolean enableFreeScout = false;
    private boolean enableCheat = true;
    private boolean enableSeed = true;
    private boolean allowMultipleCompletions = false;
    private boolean resetTimer = false;
    private boolean isScouting = false;

    public ScoutRouteGameMode() {
        super("scout");
    }

    public ScoutRouteGameMode(SocketEvent payload) {
        this();
        this.setScoutTime(payload.getNextInteger());
        EasyBitFlag flags = new EasyBitFlag(payload.getNextInteger());
        this.setEnableCheat(flags.includeValue(0));
        this.setEnableSeed(flags.includeValue(1));
        this.setEnableFreeScout(flags.includeValue(2));
        this.setAllowMultipleCompletions(flags.includeValue(3));
        this.setResetTimer(flags.includeValue(4));
    }

    public int getScoutTime() {
        return this.scoutTime;
    }

    public boolean isEnableCheat() {
        return this.enableCheat;
    }

    public boolean isEnableSeed() {
        return this.enableSeed;
    }

    public boolean isEnableFreeScout() {
        return this.enableFreeScout;
    }

    public boolean isAllowMultipleCompletions() {
        return this.allowMultipleCompletions;
    }

    public boolean shouldResetTimer() {
        return this.resetTimer;
    }

    public void setResetTimer(boolean resetTimer) {
        this.resetTimer = resetTimer;
    }

    public void setAllowMultipleCompletions(boolean allowMultipleCompletions) {
        this.allowMultipleCompletions = allowMultipleCompletions;
    }

    public void setEnableFreeScout(boolean enableFreeScout) {
        this.enableFreeScout = enableFreeScout;
    }

    public void setScoutTime(int scoutTime) {
        this.scoutTime = scoutTime;
    }

    public void setEnableCheat(boolean enableCheat) {
        this.enableCheat = enableCheat;
    }

    public void setEnableSeed(boolean enableSeed) {
        this.enableSeed = enableSeed;
    }

    public void setScouting(boolean scouting) {
        this.isScouting = scouting;
    }

    public boolean isScouting() {
        return this.isScouting;
    }

    @Override
    public String toDataString() {
        return String.format("%s:%s", this.getScoutTime(), EasyBitFlag.of(this.isEnableCheat(), this.isEnableSeed(), this.isEnableFreeScout(), this.isAllowMultipleCompletions(), this.shouldResetTimer()).getFlagValue());
    }

    @Override
    public boolean enableSeedChange() {
        return false;
    }

    @Override
    public void onTimerInitialize(InGameTimer timer, OnlineMatch match) {
        super.onTimerInitialize(timer, match);
        if (this.isAllowMultipleCompletions() && (match.getLocalData().hasCompleted() || this.shouldResetTimer()) && !this.isScouting() && System.currentTimeMillis() > match.getStartTime()) {
            match.getRunTimer().reset();
        }
    }

    @Override
    public void onBeforeJoinWorld(WorldCreator creator) {
        super.onBeforeJoinWorld(creator);
        if (this.isScouting() && this.isEnableCheat()) {
            creator.setEnableCheat(true);
        } else {
            creator.setEnableCheat(false);
        }
    }
}

